/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import java.sql.Date;
import java.time.LocalDate;
import org.apache.kudu.util.DateUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestDateUtil {
    @Test(expected=IllegalArgumentException.class)
    public void testDateOutOfRange() {
        DateUtil.checkDateWithinRange((long)LocalDate.of(10000, 1, 1).toEpochDay());
    }

    @Test
    public void testSqlDateToEpochDays() {
        Date b = Date.valueOf(LocalDate.of(1, 1, 1));
        Date e = Date.valueOf(LocalDate.of(9999, 12, 31));
        Assert.assertEquals((long)DateUtil.sqlDateToEpochDays((Date)b), (long)DateUtil.MIN_DATE_VALUE);
        Assert.assertEquals((long)DateUtil.sqlDateToEpochDays((Date)e), (long)DateUtil.MAX_DATE_VALUE);
    }

    @Test
    public void testEpochDaysToSqlDate() {
        Date b = Date.valueOf(LocalDate.of(1, 1, 1));
        Date e = Date.valueOf(LocalDate.of(9999, 12, 31));
        Assert.assertEquals((Object)DateUtil.epochDaysToSqlDate((int)DateUtil.MIN_DATE_VALUE), (Object)b);
        Assert.assertEquals((Object)DateUtil.epochDaysToSqlDate((int)DateUtil.MAX_DATE_VALUE), (Object)e);
    }

    @Test
    public void testEpochDaysToDateString() {
        Assert.assertEquals((Object)DateUtil.epochDaysToDateString((int)DateUtil.MIN_DATE_VALUE), (Object)"0001-01-01");
        Assert.assertEquals((Object)DateUtil.epochDaysToDateString((int)DateUtil.MAX_DATE_VALUE), (Object)"9999-12-31");
        Assert.assertEquals((Object)DateUtil.epochDaysToDateString((int)0), (Object)"1970-01-01");
        Assert.assertEquals((Object)DateUtil.epochDaysToDateString((int)-10000), (Object)"1942-08-16");
        Assert.assertEquals((Object)DateUtil.epochDaysToDateString((int)10000), (Object)"1997-05-19");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinInt() {
        DateUtil.checkDateWithinRange((long)Integer.MIN_VALUE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxInt() {
        DateUtil.checkDateWithinRange((long)Integer.MAX_VALUE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBeforeMinDate() {
        DateUtil.checkDateWithinRange((long)(DateUtil.MIN_DATE_VALUE - 1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAfterMaxDate() {
        DateUtil.checkDateWithinRange((long)(DateUtil.MAX_DATE_VALUE + 1));
    }
}

