/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.util.ByteVec;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestByteVec {
    private static final Random RAND = new Random();
    @Rule
    public RetryRule retryRule = new RetryRule();

    private void assertBytesEqual(byte a, byte b) {
        if (a != b) {
            throw new AssertionError((Object)String.format("%s != %s", a, b));
        }
    }

    private List<Byte> random() {
        return this.random(RAND.nextInt(1024));
    }

    private List<Byte> random(int len) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (int i = 0; i < len; ++i) {
            list.add((byte)RAND.nextInt(i + 1));
        }
        return Collections.unmodifiableList(list);
    }

    private void checkByteVec(List<Byte> vals) {
        ByteVec vec = ByteVec.create();
        Assert.assertEquals((long)0L, (long)vec.len());
        for (byte i : vals) {
            vec.push(i);
        }
        Assert.assertEquals(vals, (Object)vec.asList());
        Assert.assertEquals((long)0L, (long)ByteVec.withCapacity((int)0).capacity());
        Assert.assertEquals((long)13L, (long)ByteVec.withCapacity((int)13).capacity());
        Assert.assertEquals((Object)vec, (Object)ByteVec.wrap((byte[])vec.toArray()));
        ByteVec copy = vec.clone();
        Assert.assertEquals((Object)copy, (Object)vec);
        copy.truncate(vec.len() + 1);
        Assert.assertEquals(vals, (Object)copy.asList());
        vec.truncate(copy.len());
        Assert.assertEquals(vals, (Object)copy.asList());
        copy.truncate(vals.size() / 2);
        Assert.assertEquals(vals.subList(0, vals.size() / 2), (Object)copy.asList());
        if (vals.size() > 0) {
            Assert.assertNotEquals(vals, (Object)copy.asList());
        }
        int unused = copy.capacity() - copy.len();
        copy.reserveAdditional(unused);
        Assert.assertEquals((long)vec.capacity(), (long)copy.capacity());
        copy.reserveAdditional(unused + 1);
        Assert.assertTrue((copy.capacity() > vec.capacity() ? 1 : 0) != 0);
        unused = copy.capacity() - copy.len();
        copy.reserveExact(unused + 3);
        Assert.assertEquals((long)(copy.capacity() - copy.len()), (long)(unused + 3));
        copy.truncate(0);
        Assert.assertEquals((long)0L, (long)copy.len());
        copy.shrinkToFit();
        Assert.assertEquals((long)0L, (long)copy.capacity());
        vec.shrinkToFit();
        Assert.assertEquals((long)vec.len(), (long)vec.capacity());
        for (int i = 0; i < vals.size(); ++i) {
            this.assertBytesEqual(vals.get(i), vec.get(i));
        }
        if (vec.len() > 0) {
            copy = vec.clone();
            int index = RAND.nextInt(vec.len());
            copy.set(index, (byte)index);
            ArrayList<Byte> intsCopy = new ArrayList<Byte>(vals);
            intsCopy.set(index, (byte)index);
            Assert.assertEquals(intsCopy, (Object)copy.asList());
        }
    }

    @Test
    public void testByteVec() throws Exception {
        this.checkByteVec(this.random(0));
        this.checkByteVec(this.random(1));
        this.checkByteVec(this.random(2));
        this.checkByteVec(this.random(3));
        this.checkByteVec(this.random(30));
        this.checkByteVec(this.random(31));
        this.checkByteVec(this.random(32));
        this.checkByteVec(this.random(33));
        this.checkByteVec(this.random(34));
        for (int i = 0; i < 100; ++i) {
            this.checkByteVec(this.random());
        }
    }
}

