/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.util.AsyncUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestAsyncUtil {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test(expected=IllegalStateException.class)
    public void testAddCallbacksDeferring() throws Exception {
        Deferred d = new Deferred();
        TestCallback cb = new TestCallback();
        TestErrback eb = new TestErrback();
        AsyncUtil.addCallbacksDeferring((Deferred)d, (Callback)cb, (Callback)eb);
        String testStr = "hello world";
        d.callback((Object)"hello world");
        Assert.assertEquals((Object)d.join(), (Object)"callback: hello world");
        d = new Deferred();
        AsyncUtil.addCallbacksDeferring((Deferred)d, (Callback)cb, (Callback)eb);
        d.callback((Object)new IllegalArgumentException());
        Assert.assertEquals((Object)d.join(), (Object)"illegal arg");
        d = new Deferred();
        AsyncUtil.addCallbacksDeferring((Deferred)d, (Callback)cb, (Callback)eb);
        d.callback((Object)new IllegalStateException());
        d.join();
    }

    static final class TestErrback
    implements Callback<Deferred<String>, Exception> {
        TestErrback() {
        }

        public Deferred<String> call(Exception arg) {
            if (arg instanceof IllegalArgumentException) {
                return Deferred.fromResult((Object)"illegal arg");
            }
            return Deferred.fromError((Exception)arg);
        }
    }

    static final class TestCallback
    implements Callback<Deferred<String>, String> {
        TestCallback() {
        }

        public Deferred<String> call(String arg) throws Exception {
            return Deferred.fromResult((Object)("callback: " + arg));
        }
    }
}

