/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kudu.client.TimeoutTracker;
import org.apache.kudu.test.junit.RetryRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestTimeoutTracker {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testTimeout() {
        final AtomicLong timeToReturn = new AtomicLong();
        Ticker ticker = new Ticker(){

            public long read() {
                return timeToReturn.get();
            }
        };
        Stopwatch stopwatch = Stopwatch.createUnstarted((Ticker)ticker);
        TimeoutTracker tracker = new TimeoutTracker(stopwatch);
        tracker.setTimeout(0L);
        Assert.assertFalse((boolean)tracker.hasTimeout());
        Assert.assertFalse((boolean)tracker.timedOut());
        tracker.reset();
        tracker.setTimeout(500L);
        Assert.assertTrue((boolean)tracker.hasTimeout());
        Assert.assertFalse((boolean)tracker.timedOut());
        Assert.assertFalse((boolean)tracker.wouldSleepingTimeoutMillis(499L));
        Assert.assertTrue((boolean)tracker.wouldSleepingTimeoutMillis(500L));
        Assert.assertTrue((boolean)tracker.wouldSleepingTimeoutMillis(501L));
        Assert.assertEquals((long)500L, (long)tracker.getMillisBeforeTimeout());
        timeToReturn.set(200000000L);
        Assert.assertTrue((boolean)tracker.hasTimeout());
        Assert.assertFalse((boolean)tracker.timedOut());
        Assert.assertFalse((boolean)tracker.wouldSleepingTimeoutMillis(299L));
        Assert.assertTrue((boolean)tracker.wouldSleepingTimeoutMillis(300L));
        Assert.assertTrue((boolean)tracker.wouldSleepingTimeoutMillis(301L));
        Assert.assertEquals((long)300L, (long)tracker.getMillisBeforeTimeout());
        timeToReturn.set(600000000L);
        Assert.assertTrue((boolean)tracker.hasTimeout());
        Assert.assertTrue((boolean)tracker.timedOut());
        Assert.assertTrue((boolean)tracker.wouldSleepingTimeoutMillis(299L));
        Assert.assertTrue((boolean)tracker.wouldSleepingTimeoutMillis(300L));
        Assert.assertTrue((boolean)tracker.wouldSleepingTimeoutMillis(301L));
        Assert.assertEquals((long)1L, (long)tracker.getMillisBeforeTimeout());
    }
}

