/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.Statistics;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestStatistics {
    private static final String TABLE_NAME = TestStatistics.class.getName() + "-" + System.currentTimeMillis();
    private KuduTable table;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() throws Exception {
        CreateTableOptions options = ClientTestUtil.getBasicCreateTableOptions().setNumReplicas(1);
        this.table = this.harness.getClient().createTable(TABLE_NAME, ClientTestUtil.getBasicSchema(), options);
    }

    @Test(timeout=10000L)
    public void test() throws Exception {
        KuduClient client = this.harness.getClient();
        KuduSession session = client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        int rowCount = 20;
        for (int i = 0; i < rowCount; ++i) {
            Insert insert = ClientTestUtil.createBasicSchemaInsert((KuduTable)this.table, (int)i);
            session.apply((Operation)insert);
            if (i % 2 != 1) continue;
            session.flush();
        }
        Statistics statistics = client.getStatistics();
        Assert.assertEquals((long)(rowCount / 2), (long)statistics.getClientStatistic(Statistics.Statistic.WRITE_RPCS));
        Assert.assertEquals((long)rowCount, (long)statistics.getClientStatistic(Statistics.Statistic.WRITE_OPS));
        Assert.assertEquals((long)0L, (long)statistics.getClientStatistic(Statistics.Statistic.RPC_ERRORS));
        Assert.assertEquals((long)0L, (long)statistics.getClientStatistic(Statistics.Statistic.OPS_ERRORS));
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC);
        long byteSize = 0L;
        for (int i = 0; i < rowCount; ++i) {
            Insert insert = ClientTestUtil.createBasicSchemaInsert((KuduTable)this.table, (int)i);
            session.apply((Operation)insert);
            byteSize += insert.getRowOperationSizeBytes();
        }
        Assert.assertEquals((long)(rowCount + rowCount / 2), (long)statistics.getClientStatistic(Statistics.Statistic.WRITE_RPCS));
        Assert.assertEquals((long)rowCount, (long)statistics.getClientStatistic(Statistics.Statistic.WRITE_OPS));
        Assert.assertEquals((long)0L, (long)statistics.getClientStatistic(Statistics.Statistic.RPC_ERRORS));
        Assert.assertEquals((long)rowCount, (long)statistics.getClientStatistic(Statistics.Statistic.OPS_ERRORS));
        Assert.assertEquals((long)(byteSize * 2L), (long)statistics.getClientStatistic(Statistics.Statistic.BYTES_WRITTEN));
        ArrayList tableNames = new ArrayList(statistics.getTableSet());
        Assert.assertEquals((long)1L, (long)tableNames.size());
        Assert.assertEquals((Object)TABLE_NAME, tableNames.get(0));
        Assert.assertEquals((long)rowCount, (long)statistics.getTableStatistic(TABLE_NAME, Statistics.Statistic.WRITE_OPS));
        ArrayList tabletIds = new ArrayList(statistics.getTabletSet());
        Assert.assertEquals((long)1L, (long)tabletIds.size());
        Assert.assertEquals((long)rowCount, (long)statistics.getTabletStatistic((String)tabletIds.get(0), Statistics.Statistic.WRITE_OPS));
    }
}

