/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.stumbleupon.async.Deferred;
import java.io.Closeable;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.apache.kudu.client.Client;
import org.apache.kudu.client.ConnectToCluster;
import org.apache.kudu.client.Connection;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.Operation;
import org.apache.kudu.test.CapturingLogAppender;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.cluster.FakeDNS;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.apache.kudu.test.junit.AssertHelpers;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.util.SecurityUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestSecurity {
    private static final String TABLE_NAME = "TestSecurity-table";
    private static final int TICKET_LIFETIME_SECS = 10;
    private static final int RENEWABLE_LIFETIME_SECS = 20;
    private CapturingLogAppender cla;
    private MiniKuduCluster miniCluster;
    private KuduClient client;
    @Rule
    public RetryRule retryRule = new RetryRule();

    private void startCluster(Set<Option> opts) throws IOException {
        MiniKuduCluster.MiniKuduClusterBuilder mcb = new MiniKuduCluster.MiniKuduClusterBuilder();
        mcb.enableKerberos();
        if (opts.contains((Object)Option.LONG_LEADER_ELECTION)) {
            mcb.addMasterServerFlag("--leader_failure_max_missed_heartbeat_periods=10.0");
        }
        if (opts.contains((Object)Option.SHORT_TOKENS_AND_TICKETS)) {
            mcb.addMasterServerFlag("--authn_token_validity_seconds=10").kdcRenewLifetime("20s").kdcTicketLifetime("10s");
        }
        this.miniCluster = mcb.numMasterServers(3).numTabletServers(opts.contains((Object)Option.START_TSERVERS) ? 3 : 0).build();
        this.miniCluster.kinit("test-admin");
        this.client = new KuduClient.KuduClientBuilder(this.miniCluster.getMasterAddressesAsString()).build();
    }

    @Before
    public void setUp() {
        FakeDNS.getInstance().install();
        this.cla = new CapturingLogAppender();
    }

    @After
    public void tearDown() throws IOException {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            if (this.miniCluster != null) {
                this.miniCluster.shutdown();
            }
        }
    }

    private KuduClient createClientFromSubject(Subject subject) throws PrivilegedActionException {
        return Subject.doAs(subject, new PrivilegedExceptionAction<KuduClient>(){

            @Override
            public KuduClient run() throws Exception {
                return TestSecurity.this.createClient();
            }
        });
    }

    private KuduClient createClient() {
        return new KuduClient.KuduClientBuilder(this.miniCluster.getMasterAddressesAsString()).build();
    }

    private void checkClientCanReconnect(KuduClient client) throws IOException {
        this.miniCluster.killAllMasterServers();
        this.miniCluster.startAllMasterServers();
        client.listTabletServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportExportAuthenticationCredentials() throws Exception {
        this.startCluster((Set<Option>)ImmutableSet.of((Object)((Object)Option.START_TSERVERS)));
        byte[] authnData = this.client.exportAuthenticationCredentials();
        Assert.assertNotNull((Object)authnData);
        String oldTicketCache = System.getProperty("kudu.krb5ccname");
        System.clearProperty("kudu.krb5ccname");
        try (KuduClient newClient = new KuduClient.KuduClientBuilder(this.miniCluster.getMasterAddressesAsString()).build();){
            try {
                newClient.listTabletServers();
                Assert.fail((String)"should not have been able to connect to a secure cluster with no credentials");
            }
            catch (NonRecoverableException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"server requires authentication, but client does not have Kerberos credentials (tgt). Authentication tokens were not used because no token is available"));
            }
            newClient.importAuthenticationCredentials(authnData);
            KuduTable table = newClient.createTable(TABLE_NAME, ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions());
            KuduSession session = newClient.newSession();
            session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)1));
            session.flush();
        }
        finally {
            System.setProperty("kudu.krb5ccname", oldTicketCache);
        }
    }

    @Test(timeout=60000L)
    public void testExportCredentialsBeforeAnyOtherAccess() throws IOException {
        this.startCluster((Set<Option>)ImmutableSet.of());
        try (KuduClient c = this.createClient();){
            Client.AuthenticationCredentialsPB pb = Client.AuthenticationCredentialsPB.parseFrom((byte[])c.exportAuthenticationCredentials());
            Assert.assertTrue((boolean)pb.hasAuthnToken());
            Assert.assertTrue((pb.getCaCertDersCount() > 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorMessageWithNoCaCert() throws Exception {
        this.startCluster((Set<Option>)ImmutableSet.of((Object)((Object)Option.SHORT_TOKENS_AND_TICKETS)));
        byte[] authnData = this.client.exportAuthenticationCredentials();
        authnData = Client.AuthenticationCredentialsPB.parseFrom((byte[])authnData).toBuilder().clearCaCertDers().build().toByteArray();
        String oldTicketCache = System.getProperty("kudu.krb5ccname");
        System.clearProperty("kudu.krb5ccname");
        try (KuduClient newClient = this.createClient();){
            newClient.importAuthenticationCredentials(authnData);
            try {
                newClient.listTabletServers();
                Assert.fail((String)"should not have been able to connect to a secure cluster with no credentials");
            }
            catch (NonRecoverableException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"server requires authentication, but client does not have Kerberos credentials (tgt). Authentication tokens were not used because no TLS certificates are trusted by the client"));
            }
        }
        finally {
            System.setProperty("kudu.krb5ccname", oldTicketCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKudu2267() throws Exception {
        this.startCluster((Set<Option>)ImmutableSet.of((Object)((Object)Option.SHORT_TOKENS_AND_TICKETS)));
        byte[] authnData = this.client.exportAuthenticationCredentials();
        Assert.assertNotNull((Object)authnData);
        String oldTicketCache = System.getProperty("kudu.krb5ccname");
        System.clearProperty("kudu.krb5ccname");
        try (final KuduClient newClient = this.createClient();){
            newClient.importAuthenticationCredentials(authnData);
            AssertHelpers.assertEventuallyTrue((String)"Not able to connect to all the masters", (AssertHelpers.BooleanExpression)new AssertHelpers.BooleanExpression(){

                public boolean get() throws Exception {
                    ConnectToCluster connector = new ConnectToCluster(TestSecurity.this.miniCluster.getMasterServers());
                    List deferreds = connector.connectToMasters(newClient.asyncClient.getMasterTable(), null, 50000L, Connection.CredentialsPolicy.ANY_CREDENTIALS);
                    for (Deferred deferred : deferreds) {
                        deferred.join();
                    }
                    List s = connector.getExceptionsReceived();
                    return s.size() == 0;
                }
            }, (long)50000L);
        }
        finally {
            System.setProperty("kudu.krb5ccname", oldTicketCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectToNonLeaderMasters() throws Exception {
        this.startCluster((Set<Option>)ImmutableSet.of((Object)((Object)Option.LONG_LEADER_ELECTION)));
        System.err.println("=> started cluster");
        byte[] authnData = this.client.exportAuthenticationCredentials();
        System.err.println("=> exported auth");
        Assert.assertNotNull((Object)authnData);
        String oldTicketCache = System.getProperty("kudu.krb5ccname");
        System.clearProperty("kudu.krb5ccname");
        try (KuduClient newClient = this.createClient();){
            newClient.importAuthenticationCredentials(authnData);
            System.err.println("=> imported auth");
            this.miniCluster.killAllMasterServers();
            this.miniCluster.startAllMasterServers();
            newClient.listTabletServers();
            System.err.println("=> listTabletServers");
        }
        finally {
            System.setProperty("kudu.krb5ccname", oldTicketCache);
        }
    }

    @Test(timeout=300000L)
    public void testRenewAndReacquireKeberosCredentials() throws Exception {
        this.startCluster((Set<Option>)ImmutableSet.of((Object)((Object)Option.SHORT_TOKENS_AND_TICKETS)));
        Stopwatch timeSinceKinit = Stopwatch.createStarted();
        try (Closeable c = this.cla.attach();){
            Stopwatch sw = Stopwatch.createStarted();
            while (sw.elapsed(TimeUnit.SECONDS) < 40L) {
                if (timeSinceKinit.elapsed(TimeUnit.SECONDS) > 12L) {
                    this.miniCluster.kinit("test-admin");
                    timeSinceKinit.reset().start();
                }
                Thread.sleep(1000L);
                this.client.asyncClient.securityContext.setAuthenticationToken(null);
                this.checkClientCanReconnect(this.client);
            }
        }
        Assert.assertThat((Object)this.cla.getAppendedText(), (Matcher)CoreMatchers.containsString((String)"Successfully refreshed Kerberos credentials from ticket cache"));
    }

    @Test(timeout=300000L)
    public void testDoNotSwitchPrincipalsInExistingClient() throws Exception {
        this.startCluster((Set<Option>)ImmutableSet.of((Object)((Object)Option.SHORT_TOKENS_AND_TICKETS)));
        this.miniCluster.kinit("test-user");
        try (Closeable c = this.cla.attach();){
            this.assertEventualAuthenticationFailure(this.client, "server requires authentication, but client Kerberos credentials (TGT) have expired");
        }
        Assert.assertThat((Object)this.cla.getAppendedText(), (Matcher)CoreMatchers.containsString((String)"found that the new Kerberos principal test-user@KRBTEST.COM did not match the original principal test-admin@KRBTEST.COM"));
    }

    private void assertEventualAuthenticationFailure(final KuduClient client, final String exceptionSubstring) throws Exception {
        AssertHelpers.assertEventuallyTrue((String)"should eventually fail to connect", (AssertHelpers.BooleanExpression)new AssertHelpers.BooleanExpression(){

            public boolean get() throws Exception {
                Thread.sleep(3000L);
                TestSecurity.this.miniCluster.killAllMasterServers();
                TestSecurity.this.miniCluster.startAllMasterServers();
                try {
                    client.listTabletServers();
                }
                catch (Exception e) {
                    if (e.toString().contains(exceptionSubstring)) {
                        return true;
                    }
                    throw e;
                }
                return false;
            }
        }, (long)60000L);
    }

    @Test(timeout=300000L)
    public void testExternallyProvidedSubjectExpires() throws Exception {
        this.startCluster((Set<Option>)ImmutableSet.of((Object)((Object)Option.SHORT_TOKENS_AND_TICKETS)));
        Subject subject = SecurityUtil.getSubjectFromTicketCacheOrNull();
        Assert.assertNotNull((Object)subject);
        try (Closeable c = this.cla.attach();
             KuduClient newClient = this.createClientFromSubject(subject);){
            this.assertEventualAuthenticationFailure(newClient, "server requires authentication, but client Kerberos credentials (TGT) have expired");
        }
        Assert.assertThat((Object)this.cla.getAppendedText(), (Matcher)CoreMatchers.containsString((String)"Using caller-provided subject with Kerberos principal test-admin@KRBTEST.COM."));
        Assert.assertThat((Object)this.cla.getAppendedText(), (Matcher)CoreMatchers.containsString((String)"Caller-provided Subject has a Kerberos ticket that is about to expire"));
    }

    @Test(timeout=300000L)
    public void testExternallyProvidedSubjectRefreshedExternally() throws Exception {
        this.startCluster((Set<Option>)ImmutableSet.of((Object)((Object)Option.SHORT_TOKENS_AND_TICKETS)));
        Subject subject = SecurityUtil.getSubjectFromTicketCacheOrNull();
        Assert.assertNotNull((Object)subject);
        try (Closeable c = this.cla.attach();
             KuduClient newClient = this.createClientFromSubject(subject);){
            Stopwatch sw = Stopwatch.createStarted();
            while (sw.elapsed(TimeUnit.SECONDS) < 25L) {
                this.miniCluster.kinit("test-admin");
                Subject newSubject = SecurityUtil.getSubjectFromTicketCacheOrNull();
                subject.getPrivateCredentials().clear();
                subject.getPrivateCredentials().addAll(newSubject.getPrivateCredentials());
                newClient.asyncClient.securityContext.setAuthenticationToken(null);
                this.checkClientCanReconnect(newClient);
                Thread.sleep(1000L);
            }
        }
        Assert.assertThat((Object)this.cla.getAppendedText(), (Matcher)CoreMatchers.containsString((String)"Using caller-provided subject with Kerberos principal test-admin@KRBTEST.COM."));
    }

    @Test(timeout=60000L)
    public void testNegotiationChannelBindings() throws Exception {
        this.startCluster((Set<Option>)ImmutableSet.of((Object)((Object)Option.START_TSERVERS)));
        this.client.createTable("TestSecurity-channel-bindings-0", ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions());
        ImmutableList variants = ImmutableList.of((Object)new KeyValueMessage("rpc_inject_invalid_channel_bindings_ratio", "1.0", "invalid channel bindings provided by remote peer"), (Object)new KeyValueMessage("rpc_send_channel_bindings", "false", "no channel bindings provided by remote peer"));
        for (KeyValueMessage kvm : variants) {
            for (HostAndPort hp : this.miniCluster.getMasterServers()) {
                this.miniCluster.setMasterFlag(hp, kvm.key, kvm.val);
            }
            try {
                KuduClient c = new KuduClient.KuduClientBuilder(this.miniCluster.getMasterAddressesAsString()).build();
                c.createTable("TestSecurity-channel-bindings-1", ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions());
                Assert.fail((String)"client should not be able to connect to any master");
            }
            catch (NonRecoverableException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"unable to verify identity of peer"));
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)kvm.msg));
            }
        }
    }

    private static class KeyValueMessage {
        final String key;
        final String val;
        final String msg;

        KeyValueMessage(String k, String v, String m) {
            this.key = k;
            this.val = v;
            this.msg = m;
        }
    }

    private static enum Option {
        LONG_LEADER_ELECTION,
        SHORT_TOKENS_AND_TICKETS,
        START_TSERVERS;

    }
}

