/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Common;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.AsyncKuduSession;
import org.apache.kudu.client.Client;
import org.apache.kudu.client.ColumnRangePredicate;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduScanToken;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.client.ResourceMetrics;
import org.apache.kudu.client.RowResultIterator;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestScannerMultiTablet {
    private static final String TABLE_NAME = TestScannerMultiTablet.class.getName() + "-" + System.currentTimeMillis();
    private static Schema schema = TestScannerMultiTablet.getSchema();
    private long beforeWriteTimestamp;
    private KuduTable table;
    private KuduClient client;
    private AsyncKuduClient asyncClient;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() throws Exception {
        String[] keys;
        CreateTableOptions builder = new CreateTableOptions().setRangePartitionColumns((List)ImmutableList.of((Object)"key1", (Object)"key2"));
        for (int i = 1; i < 4; ++i) {
            PartialRow splitRow = schema.newPartialRow();
            splitRow.addString("key1", "" + i);
            splitRow.addString("key2", "");
            builder.addSplitRow(splitRow);
        }
        this.harness.getClient().createTable(TABLE_NAME, schema, builder);
        KuduTable insertTable = this.harness.getClient().openTable(TABLE_NAME);
        AsyncKuduSession session = this.harness.getAsyncClient().newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC);
        for (String key1 : keys = new String[]{"1", "2", "3"}) {
            for (String key2 : keys) {
                Insert insert = insertTable.newInsert();
                PartialRow row = insert.getRow();
                row.addString(0, key1);
                row.addString(1, key2);
                row.addString(2, key2);
                Deferred d = session.apply((Operation)insert);
                d.join(50000L);
            }
        }
        this.beforeWriteTimestamp = this.harness.getAsyncClient().getLastPropagatedTimestamp();
        this.harness.resetClients();
        this.table = this.harness.getClient().openTable(TABLE_NAME);
        this.client = this.harness.getClient();
        this.asyncClient = this.harness.getAsyncClient();
    }

    private void validateResourceMetrics(ResourceMetrics resourceMetrics) {
        Assert.assertTrue((String)"queue_duration_nanos > 0", (resourceMetrics.getMetric("queue_duration_nanos") > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"total_duration_nanos > 0", (resourceMetrics.getMetric("total_duration_nanos") > 0L ? 1 : 0) != 0);
    }

    @Test(timeout=100000L)
    public void testResourceMetrics() throws Exception {
        AsyncKuduScanner oneTabletScanner = this.getScanner("1", "1", "1", "4");
        Assert.assertEquals((long)3L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)oneTabletScanner));
        AsyncKuduScanner fullTableScanner = this.getScanner(null, null, null, null);
        Assert.assertEquals((long)9L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)fullTableScanner));
        this.validateResourceMetrics(oneTabletScanner.getResourceMetrics());
        this.validateResourceMetrics(fullTableScanner.getResourceMetrics());
    }

    @Test(timeout=100000L)
    public void testKeyStartEnd() throws Exception {
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("", "", "1", "")));
        Assert.assertEquals((long)1L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("", "", "1", "2")));
        Assert.assertEquals((long)3L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("1", "1", "1", "4")));
        Assert.assertEquals((long)3L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("1", "1", "2", "")));
        Assert.assertEquals((long)3L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("1", "1", "2", "0")));
        Assert.assertEquals((long)4L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("1", "2", "2", "3")));
        Assert.assertEquals((long)3L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("1", "4", "2", "4")));
        Assert.assertEquals((long)6L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("1", "5", "3", "4")));
        Assert.assertEquals((long)9L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("", "", "4", "")));
        Assert.assertEquals((long)9L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("", "", null, null)));
        Assert.assertEquals((long)9L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner(null, null, "4", "")));
        Assert.assertEquals((long)9L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner(null, null, null, null)));
        AsyncKuduScanner scanner = this.getScanner("1", "", null, null);
        Deferred d = scanner.nextRows();
        RowResultIterator rri = (RowResultIterator)d.join(50000L);
        Assert.assertEquals((long)3L, (long)rri.getNumRows());
        d = scanner.close();
        rri = (RowResultIterator)d.join(50000L);
        Assert.assertNull((Object)rri);
    }

    @Test(timeout=100000L)
    public void testKeysAndPredicates() throws Exception {
        ColumnRangePredicate predicate = new ColumnRangePredicate(schema.getColumnByIndex(1));
        predicate.setUpperBound("1");
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("1", "2", "1", "3", predicate)));
        predicate = new ColumnRangePredicate(schema.getColumnByIndex(2));
        predicate.setLowerBound("1");
        predicate.setUpperBound("1");
        Assert.assertEquals((long)1L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("1", "", "2", "", predicate)));
        predicate = new ColumnRangePredicate(schema.getColumnByIndex(2));
        predicate.setLowerBound("1");
        predicate.setUpperBound("3");
        Assert.assertEquals((long)3L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("1", "", "2", "", predicate)));
        predicate = new ColumnRangePredicate(schema.getColumnByIndex(2));
        predicate.setLowerBound("4");
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner("1", "", "2", "", predicate)));
        predicate = new ColumnRangePredicate(schema.getColumnByIndex(2));
        predicate.setLowerBound("1");
        predicate.setUpperBound("1");
        Assert.assertEquals((long)3L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner(null, null, null, null, predicate)));
        predicate = new ColumnRangePredicate(schema.getColumnByIndex(2));
        predicate.setLowerBound("1");
        Assert.assertEquals((long)9L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.getScanner(null, null, null, null, predicate)));
    }

    @Test(timeout=100000L)
    public void testProjections() throws Exception {
        AsyncKuduScanner.AsyncKuduScannerBuilder builder = this.asyncClient.newScannerBuilder(this.table);
        builder.setProjectedColumnNames((List)Lists.newArrayList((Object[])new String[]{schema.getColumnByIndex(0).getName(), schema.getColumnByIndex(1).getName()}));
        this.buildScannerAndCheckColumnsCount(builder, 2);
        builder = this.asyncClient.newScannerBuilder(this.table);
        builder.setProjectedColumnIndexes((List)Lists.newArrayList((Object[])new Integer[]{0, 1}));
        this.buildScannerAndCheckColumnsCount(builder, 2);
        builder = this.asyncClient.newScannerBuilder(this.table);
        builder.setProjectedColumnIndexes((List)Lists.newArrayList((Object[])new Integer[]{0, 1}));
        builder.setProjectedColumnNames((List)Lists.newArrayList((Object[])new String[]{schema.getColumnByIndex(0).getName()}));
        this.buildScannerAndCheckColumnsCount(builder, 1);
        builder = this.asyncClient.newScannerBuilder(this.table);
        builder.setProjectedColumnIndexes((List)Lists.newArrayList((Object[])new Integer[]{2, 1, 0}));
        this.buildScannerAndCheckColumnsCount(builder, 3);
        builder = this.asyncClient.newScannerBuilder(this.table);
        builder.setProjectedColumnNames((List)Lists.newArrayList((Object[])new String[]{schema.getColumnByIndex(2).getName(), schema.getColumnByIndex(0).getName()}));
        this.buildScannerAndCheckColumnsCount(builder, 2);
    }

    @Test(timeout=100000L)
    public void testReplicaSelections() throws Exception {
        AsyncKuduScanner scanner = ((AsyncKuduScanner.AsyncKuduScannerBuilder)this.asyncClient.newScannerBuilder(this.table).replicaSelection(ReplicaSelection.LEADER_ONLY)).build();
        Assert.assertEquals((long)9L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)scanner));
        scanner = ((AsyncKuduScanner.AsyncKuduScannerBuilder)this.asyncClient.newScannerBuilder(this.table).replicaSelection(ReplicaSelection.CLOSEST_REPLICA)).build();
        Assert.assertEquals((long)9L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)scanner));
    }

    @Test(timeout=100000L)
    public void testScanTokenReplicaSelections() throws Exception {
        Client.ScanTokenPB.Builder pbBuilder = Client.ScanTokenPB.newBuilder();
        pbBuilder.setTableName(this.table.getName());
        pbBuilder.setReplicaSelection(Common.ReplicaSelection.CLOSEST_REPLICA);
        Client.ScanTokenPB scanTokenPB = pbBuilder.build();
        byte[] serializedToken = KuduScanToken.serialize((Client.ScanTokenPB)scanTokenPB);
        KuduScanner scanner = KuduScanToken.deserializeIntoScanner((byte[])serializedToken, (KuduClient)this.client);
        Assert.assertEquals((Object)ReplicaSelection.CLOSEST_REPLICA, (Object)scanner.getReplicaSelection());
        Assert.assertEquals((long)9L, (long)ClientTestUtil.countRowsInScan((KuduScanner)scanner));
    }

    @Test(timeout=100000L)
    public void testReadAtSnapshotNoTimestamp() throws Exception {
        AsyncKuduScanner scanner = ((AsyncKuduScanner.AsyncKuduScannerBuilder)this.asyncClient.newScannerBuilder(this.table).readMode(AsyncKuduScanner.ReadMode.READ_AT_SNAPSHOT)).build();
        Assert.assertEquals((long)-1L, (long)scanner.getSnapshotTimestamp());
        KuduScanner syncScanner = new KuduScanner(scanner);
        Assert.assertEquals((Object)scanner.getReadMode(), (Object)syncScanner.getReadMode());
        Assert.assertTrue((boolean)syncScanner.hasMoreRows());
        Assert.assertEquals((long)-1L, (long)scanner.getSnapshotTimestamp());
        int rowCount = syncScanner.nextRows().getNumRows();
        long tsRef = scanner.getSnapshotTimestamp();
        Assert.assertNotEquals((long)-1L, (long)tsRef);
        Assert.assertTrue((boolean)syncScanner.hasMoreRows());
        while (syncScanner.hasMoreRows()) {
            rowCount += syncScanner.nextRows().getNumRows();
            Assert.assertEquals((long)tsRef, (long)scanner.getSnapshotTimestamp());
        }
        Assert.assertEquals((long)9L, (long)rowCount);
    }

    @Test(timeout=100000L)
    public void testReadYourWritesFreshClientFreshTable() throws Exception {
        AsyncKuduScanner scanner = ((AsyncKuduScanner.AsyncKuduScannerBuilder)this.asyncClient.newScannerBuilder(this.table).readMode(AsyncKuduScanner.ReadMode.READ_YOUR_WRITES)).build();
        KuduScanner syncScanner = new KuduScanner(scanner);
        Assert.assertEquals((Object)scanner.getReadMode(), (Object)syncScanner.getReadMode());
        Assert.assertEquals((long)-1L, (long)this.asyncClient.getLastPropagatedTimestamp());
        Assert.assertEquals((long)-1L, (long)scanner.getSnapshotTimestamp());
        int count = ClientTestUtil.countRowsInScan((KuduScanner)syncScanner);
        Assert.assertTrue((count >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((count <= 9 ? 1 : 0) != 0);
        Assert.assertNotEquals((long)-1L, (long)this.asyncClient.getLastPropagatedTimestamp());
        Assert.assertNotEquals((long)-1L, (long)scanner.getSnapshotTimestamp());
    }

    @Test(timeout=100000L)
    public void testReadYourWrites() throws Exception {
        long preTs = this.beforeWriteTimestamp;
        this.client.updateLastPropagatedTimestamp(preTs);
        AsyncKuduScanner scanner = ((AsyncKuduScanner.AsyncKuduScannerBuilder)this.asyncClient.newScannerBuilder(this.table).readMode(AsyncKuduScanner.ReadMode.READ_YOUR_WRITES)).build();
        KuduScanner syncScanner = new KuduScanner(scanner);
        Assert.assertEquals((Object)scanner.getReadMode(), (Object)syncScanner.getReadMode());
        Assert.assertEquals((long)-1L, (long)scanner.getSnapshotTimestamp());
        Assert.assertEquals((long)9L, (long)ClientTestUtil.countRowsInScan((KuduScanner)syncScanner));
        Assert.assertNotEquals((long)-1L, (long)scanner.getSnapshotTimestamp());
        Assert.assertTrue((preTs < scanner.getSnapshotTimestamp() ? 1 : 0) != 0);
        syncScanner.close();
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        String[] keys = new String[]{"11", "22", "33"};
        for (int i = 0; i < keys.length; ++i) {
            Insert insert = this.table.newInsert();
            PartialRow row = insert.getRow();
            row.addString(schema.getColumnByIndex(0).getName(), keys[i]);
            row.addString(schema.getColumnByIndex(1).getName(), keys[i]);
            session.apply((Operation)insert);
        }
        session.flush();
        session.close();
        scanner = ((AsyncKuduScanner.AsyncKuduScannerBuilder)this.asyncClient.newScannerBuilder(this.table).readMode(AsyncKuduScanner.ReadMode.READ_YOUR_WRITES)).build();
        syncScanner = new KuduScanner(scanner);
        Assert.assertTrue((preTs < this.asyncClient.getLastPropagatedTimestamp() ? 1 : 0) != 0);
        preTs = this.asyncClient.getLastPropagatedTimestamp();
        Assert.assertEquals((long)12L, (long)ClientTestUtil.countRowsInScan((KuduScanner)syncScanner));
        Assert.assertTrue((preTs < scanner.getSnapshotTimestamp() ? 1 : 0) != 0);
        syncScanner.close();
    }

    @Test(timeout=100000L)
    public void testScanPropagatesLatestTimestamp() throws Exception {
        AsyncKuduScanner scanner = this.asyncClient.newScannerBuilder(this.table).build();
        Assert.assertEquals((long)-1L, (long)this.asyncClient.getLastPropagatedTimestamp());
        Assert.assertEquals((long)-1L, (long)this.client.getLastPropagatedTimestamp());
        KuduScanner syncScanner = new KuduScanner(scanner);
        Assert.assertTrue((boolean)syncScanner.hasMoreRows());
        Assert.assertEquals((long)-1L, (long)this.asyncClient.getLastPropagatedTimestamp());
        Assert.assertEquals((long)-1L, (long)this.client.getLastPropagatedTimestamp());
        int rowCount = syncScanner.nextRows().getNumRows();
        long asyncTsRef = this.asyncClient.getLastPropagatedTimestamp();
        long syncTsRef = this.client.getLastPropagatedTimestamp();
        Assert.assertEquals((long)asyncTsRef, (long)syncTsRef);
        Assert.assertNotEquals((long)-1L, (long)asyncTsRef);
        Assert.assertNotEquals((long)-1L, (long)syncTsRef);
        Assert.assertTrue((boolean)syncScanner.hasMoreRows());
        while (syncScanner.hasMoreRows()) {
            rowCount += syncScanner.nextRows().getNumRows();
            long asyncTs = this.asyncClient.getLastPropagatedTimestamp();
            long syncTs = this.client.getLastPropagatedTimestamp();
            Assert.assertEquals((long)syncTs, (long)asyncTs);
            Assert.assertTrue((asyncTs > asyncTsRef ? 1 : 0) != 0);
            asyncTsRef = asyncTs;
        }
        Assert.assertNotEquals((long)0L, (long)rowCount);
    }

    @Test(timeout=100000L)
    public void testScanTokenPropagatesTimestamp() throws Exception {
        Assert.assertEquals((long)-1L, (long)this.asyncClient.getLastPropagatedTimestamp());
        Assert.assertEquals((long)-1L, (long)this.client.getLastPropagatedTimestamp());
        AsyncKuduScanner scanner = this.asyncClient.newScannerBuilder(this.table).build();
        KuduScanner syncScanner = new KuduScanner(scanner);
        syncScanner.nextRows().getNumRows();
        long tsPrev = this.asyncClient.getLastPropagatedTimestamp();
        long tsPropagated = tsPrev + 1000000L;
        Client.ScanTokenPB.Builder pbBuilder = Client.ScanTokenPB.newBuilder();
        pbBuilder.setTableName(this.table.getName());
        pbBuilder.setPropagatedTimestamp(tsPropagated);
        Client.ScanTokenPB scanTokenPB = pbBuilder.build();
        byte[] serializedToken = KuduScanToken.serialize((Client.ScanTokenPB)scanTokenPB);
        Assert.assertEquals((long)tsPrev, (long)this.asyncClient.getLastPropagatedTimestamp());
        KuduScanToken.deserializeIntoScanner((byte[])serializedToken, (KuduClient)this.client);
        Assert.assertEquals((long)tsPropagated, (long)this.asyncClient.getLastPropagatedTimestamp());
    }

    @Test(timeout=100000L)
    public void testScanTokenReadMode() throws Exception {
        Client.ScanTokenPB.Builder pbBuilder = Client.ScanTokenPB.newBuilder();
        pbBuilder.setTableName(this.table.getName());
        pbBuilder.setReadMode(Common.ReadMode.READ_YOUR_WRITES);
        Client.ScanTokenPB scanTokenPB = pbBuilder.build();
        byte[] serializedToken = KuduScanToken.serialize((Client.ScanTokenPB)scanTokenPB);
        KuduScanner scanner = KuduScanToken.deserializeIntoScanner((byte[])serializedToken, (KuduClient)this.client);
        Assert.assertEquals((Object)AsyncKuduScanner.ReadMode.READ_YOUR_WRITES, (Object)scanner.getReadMode());
    }

    private AsyncKuduScanner getScanner(String lowerBoundKeyOne, String lowerBoundKeyTwo, String exclusiveUpperBoundKeyOne, String exclusiveUpperBoundKeyTwo) {
        return this.getScanner(lowerBoundKeyOne, lowerBoundKeyTwo, exclusiveUpperBoundKeyOne, exclusiveUpperBoundKeyTwo, null);
    }

    private AsyncKuduScanner getScanner(String lowerBoundKeyOne, String lowerBoundKeyTwo, String exclusiveUpperBoundKeyOne, String exclusiveUpperBoundKeyTwo, ColumnRangePredicate predicate) {
        AsyncKuduScanner.AsyncKuduScannerBuilder builder = this.asyncClient.newScannerBuilder(this.table);
        if (lowerBoundKeyOne != null) {
            PartialRow lowerBoundRow = schema.newPartialRow();
            lowerBoundRow.addString(0, lowerBoundKeyOne);
            lowerBoundRow.addString(1, lowerBoundKeyTwo);
            builder.lowerBound(lowerBoundRow);
        }
        if (exclusiveUpperBoundKeyOne != null) {
            PartialRow upperBoundRow = schema.newPartialRow();
            upperBoundRow.addString(0, exclusiveUpperBoundKeyOne);
            upperBoundRow.addString(1, exclusiveUpperBoundKeyTwo);
            builder.exclusiveUpperBound(upperBoundRow);
        }
        if (predicate != null) {
            builder.addColumnRangePredicate(predicate);
        }
        return builder.build();
    }

    private void buildScannerAndCheckColumnsCount(AsyncKuduScanner.AsyncKuduScannerBuilder builder, int count) throws Exception {
        AsyncKuduScanner scanner = builder.build();
        scanner.nextRows().join(50000L);
        RowResultIterator rri = (RowResultIterator)scanner.nextRows().join(50000L);
        Assert.assertEquals((long)count, (long)rri.next().getSchema().getColumns().size());
    }

    private static Schema getSchema() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(3);
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key1", Type.STRING).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key2", Type.STRING).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("val", Type.STRING).nullable(true).build());
        return new Schema(columns);
    }
}

