/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestRowResult {
    private static final String TABLE_NAME = TestRowResult.class.getName() + "-" + System.currentTimeMillis();
    private static final Schema allTypesSchema = ClientTestUtil.getSchemaWithAllTypes();
    private KuduTable table;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() throws Exception {
        this.harness.getClient().createTable(TABLE_NAME, allTypesSchema, ClientTestUtil.getAllTypesCreateTableOptions());
        this.table = this.harness.getClient().openTable(TABLE_NAME);
    }

    @Test(timeout=10000L)
    public void test() throws Exception {
        Insert insert = this.table.newInsert();
        PartialRow row = insert.getRow();
        row.addByte(0, (byte)1);
        row.addShort(1, (short)2);
        row.addInt(2, 3);
        row.addLong(3, 4L);
        row.addBoolean(4, true);
        row.addFloat(5, 5.6f);
        row.addDouble(6, 7.8);
        row.addString(7, "string-value");
        row.addBinary(8, "binary-array".getBytes(StandardCharsets.UTF_8));
        ByteBuffer bb = ByteBuffer.wrap("binary-bytebuffer".getBytes(StandardCharsets.UTF_8));
        bb.position(7);
        row.addBinary(9, bb);
        row.setNull(10);
        row.addTimestamp(11, new Timestamp(11L));
        row.addDecimal(12, BigDecimal.valueOf(12345L, 3));
        row.addVarchar(13, "varcharval");
        row.addDate(14, new Date(0L));
        KuduClient client = this.harness.getClient();
        KuduSession session = client.newSession();
        session.apply((Operation)insert);
        KuduScanner scanner = client.newScannerBuilder(this.table).build();
        while (scanner.hasMoreRows()) {
            RowResultIterator it = scanner.nextRows();
            Assert.assertTrue((boolean)it.hasNext());
            RowResult rr = it.next();
            Assert.assertEquals((long)1L, (long)rr.getByte(0));
            Assert.assertEquals((Object)1, (Object)rr.getObject(0));
            Assert.assertEquals((long)1L, (long)rr.getByte(allTypesSchema.getColumnByIndex(0).getName()));
            Assert.assertEquals((long)2L, (long)rr.getShort(1));
            Assert.assertEquals((Object)2, (Object)rr.getObject(1));
            Assert.assertEquals((long)2L, (long)rr.getShort(allTypesSchema.getColumnByIndex(1).getName()));
            Assert.assertEquals((long)3L, (long)rr.getInt(2));
            Assert.assertEquals((Object)3, (Object)rr.getObject(2));
            Assert.assertEquals((long)3L, (long)rr.getInt(allTypesSchema.getColumnByIndex(2).getName()));
            Assert.assertEquals((long)4L, (long)rr.getLong(3));
            Assert.assertEquals((Object)4L, (Object)rr.getObject(3));
            Assert.assertEquals((long)4L, (long)rr.getLong(allTypesSchema.getColumnByIndex(3).getName()));
            Assert.assertEquals((Object)true, (Object)rr.getBoolean(4));
            Assert.assertEquals((Object)true, (Object)rr.getObject(4));
            Assert.assertEquals((Object)true, (Object)rr.getBoolean(allTypesSchema.getColumnByIndex(4).getName()));
            Assert.assertEquals((float)5.6f, (float)rr.getFloat(5), (float)0.001f);
            Assert.assertEquals((float)5.6f, (float)((Float)rr.getObject(5)).floatValue(), (float)0.001f);
            Assert.assertEquals((float)5.6f, (float)rr.getFloat(allTypesSchema.getColumnByIndex(5).getName()), (float)0.001f);
            Assert.assertEquals((double)7.8, (double)rr.getDouble(6), (double)0.001);
            Assert.assertEquals((double)7.8, (double)((Double)rr.getObject(6)), (double)0.001);
            Assert.assertEquals((double)7.8, (double)rr.getDouble(allTypesSchema.getColumnByIndex(6).getName()), (double)0.001f);
            Assert.assertEquals((Object)"string-value", (Object)rr.getString(7));
            Assert.assertEquals((Object)"string-value", (Object)rr.getObject(7));
            Assert.assertEquals((Object)"string-value", (Object)rr.getString(allTypesSchema.getColumnByIndex(7).getName()));
            Assert.assertArrayEquals((byte[])"binary-array".getBytes(StandardCharsets.UTF_8), (byte[])rr.getBinaryCopy(8));
            Assert.assertArrayEquals((byte[])"binary-array".getBytes(StandardCharsets.UTF_8), (byte[])((byte[])rr.getObject(8)));
            Assert.assertArrayEquals((byte[])"binary-array".getBytes(StandardCharsets.UTF_8), (byte[])rr.getBinaryCopy(allTypesSchema.getColumnByIndex(8).getName()));
            ByteBuffer buffer = rr.getBinary(8);
            Assert.assertEquals((Object)buffer, (Object)rr.getBinary(allTypesSchema.getColumnByIndex(8).getName()));
            byte[] binaryValue = new byte[buffer.remaining()];
            buffer.get(binaryValue);
            Assert.assertArrayEquals((byte[])"binary-array".getBytes(StandardCharsets.UTF_8), (byte[])binaryValue);
            Assert.assertArrayEquals((byte[])"bytebuffer".getBytes(StandardCharsets.UTF_8), (byte[])rr.getBinaryCopy(9));
            Assert.assertEquals((Object)true, (Object)rr.isNull(10));
            Assert.assertNull((Object)rr.getObject(10));
            Assert.assertEquals((Object)true, (Object)rr.isNull(allTypesSchema.getColumnByIndex(10).getName()));
            Assert.assertEquals((Object)new Timestamp(11L), (Object)rr.getTimestamp(11));
            Assert.assertEquals((Object)new Timestamp(11L), (Object)rr.getObject(11));
            Assert.assertEquals((Object)new Timestamp(11L), (Object)rr.getTimestamp(allTypesSchema.getColumnByIndex(11).getName()));
            Assert.assertEquals((Object)BigDecimal.valueOf(12345L, 3), (Object)rr.getDecimal(12));
            Assert.assertEquals((Object)BigDecimal.valueOf(12345L, 3), (Object)rr.getObject(12));
            Assert.assertEquals((Object)BigDecimal.valueOf(12345L, 3), (Object)rr.getDecimal(allTypesSchema.getColumnByIndex(12).getName()));
            Assert.assertEquals((Object)"varcharval", (Object)rr.getVarchar(13));
            Assert.assertEquals((Object)"varcharval", (Object)rr.getObject(13));
            Assert.assertEquals((Object)"varcharval", (Object)rr.getVarchar(allTypesSchema.getColumnByIndex(13).getName()));
            Assert.assertEquals((Object)new Date(0L), (Object)rr.getDate(14));
            Assert.assertEquals((Object)new Date(0L), (Object)rr.getObject(14));
            Assert.assertEquals((Object)new Date(0L), (Object)rr.getDate(allTypesSchema.getColumnByIndex(14).getName()));
            Assert.assertEquals((Object)Type.INT8, (Object)rr.getColumnType(allTypesSchema.getColumnByIndex(0).getName()));
            Assert.assertEquals((Object)Type.INT8, (Object)rr.getColumnType(0));
            Assert.assertEquals((Object)Type.INT16, (Object)rr.getColumnType(1));
            Assert.assertEquals((Object)Type.INT32, (Object)rr.getColumnType(2));
            Assert.assertEquals((Object)Type.INT64, (Object)rr.getColumnType(3));
            Assert.assertEquals((Object)Type.BOOL, (Object)rr.getColumnType(4));
            Assert.assertEquals((Object)Type.FLOAT, (Object)rr.getColumnType(5));
            Assert.assertEquals((Object)Type.DOUBLE, (Object)rr.getColumnType(6));
            Assert.assertEquals((Object)Type.STRING, (Object)rr.getColumnType(7));
            Assert.assertEquals((Object)Type.BINARY, (Object)rr.getColumnType(8));
            Assert.assertEquals((Object)Type.UNIXTIME_MICROS, (Object)rr.getColumnType(11));
            Assert.assertEquals((Object)Type.DECIMAL, (Object)rr.getColumnType(12));
            Assert.assertEquals((Object)Type.VARCHAR, (Object)rr.getColumnType(13));
            Assert.assertEquals((Object)Type.DATE, (Object)rr.getColumnType(14));
        }
    }
}

