/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.List;
import org.apache.kudu.Schema;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduSession;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.RowError;
import org.apache.kudu.client.RowErrorsAndOverflowStatus;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestRowErrors {
    private static final Schema basicSchema = ClientTestUtil.getBasicSchema();
    private KuduTable table;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Test(timeout=100000L)
    public void singleTabletTest() throws Exception {
        String tableName = TestRowErrors.class.getName() + "-" + System.currentTimeMillis();
        this.harness.getClient().createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        this.table = this.harness.getClient().openTable(tableName);
        AsyncKuduSession session = this.harness.getAsyncClient().newSession();
        for (int i = 0; i < 3; ++i) {
            session.apply((Operation)this.createInsert(i)).join(50000L);
        }
        Insert dupeForZero = this.createInsert(0);
        OperationResponse resp = (OperationResponse)session.apply((Operation)dupeForZero).join(50000L);
        Assert.assertTrue((boolean)resp.hasRowError());
        Assert.assertTrue((resp.getRowError().getOperation() == dupeForZero ? 1 : 0) != 0);
        dupeForZero = this.createInsert(0);
        Insert dupeForTwo = this.createInsert(2);
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        session.apply((Operation)dupeForZero);
        session.apply((Operation)dupeForTwo);
        session.apply((Operation)this.createInsert(4));
        List responses = (List)session.flush().join(50000L);
        List errors = OperationResponse.collectErrors((List)responses);
        Assert.assertEquals((long)2L, (long)errors.size());
        Assert.assertTrue((((RowError)errors.get(0)).getOperation() == dupeForZero ? 1 : 0) != 0);
        Assert.assertTrue((((RowError)errors.get(1)).getOperation() == dupeForTwo ? 1 : 0) != 0);
    }

    @Test(timeout=100000L)
    public void multiTabletTest() throws Exception {
        String tableName = TestRowErrors.class.getName() + "-" + System.currentTimeMillis();
        ClientTestUtil.createFourTabletsTableWithNineRows((AsyncKuduClient)this.harness.getAsyncClient(), (String)tableName, (long)50000L);
        this.table = this.harness.getClient().openTable(tableName);
        KuduSession session = this.harness.getClient().newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        int dupRows = 3;
        session.apply((Operation)this.createInsert(12));
        session.apply((Operation)this.createInsert(22));
        session.apply((Operation)this.createInsert(32));
        session.flush();
        RowErrorsAndOverflowStatus reos = session.getPendingErrors();
        Assert.assertEquals((long)3L, (long)reos.getRowErrors().length);
        Assert.assertEquals((long)0L, (long)session.countPendingErrors());
    }

    private Insert createInsert(int key) {
        return ClientTestUtil.createBasicSchemaInsert((KuduTable)this.table, (int)key);
    }
}

