/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kudu.client.RequestTracker;
import org.apache.kudu.test.junit.RetryRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestRequestTracker {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test(timeout=10000L)
    public void test() {
        int i;
        RequestTracker tracker = new RequestTracker("test");
        Assert.assertEquals((long)-1L, (long)tracker.firstIncomplete());
        int max = 10;
        for (i = 0; i < max; ++i) {
            tracker.newSeqNo();
        }
        Assert.assertEquals((long)1L, (long)tracker.firstIncomplete());
        tracker.rpcCompleted(1L);
        Assert.assertEquals((long)2L, (long)tracker.firstIncomplete());
        tracker.rpcCompleted(5L);
        Assert.assertEquals((long)2L, (long)tracker.firstIncomplete());
        for (i = 2; i <= 4; ++i) {
            tracker.rpcCompleted((long)i);
        }
        Assert.assertEquals((long)6L, (long)tracker.firstIncomplete());
        long lastSeqNo = 0L;
        for (int i2 = max / 2; i2 <= max; ++i2) {
            lastSeqNo = tracker.newSeqNo();
        }
        while (tracker.firstIncomplete() != lastSeqNo) {
            tracker.rpcCompleted(tracker.firstIncomplete());
        }
        Assert.assertEquals((long)lastSeqNo, (long)tracker.firstIncomplete());
        tracker.rpcCompleted(lastSeqNo);
        Assert.assertEquals((long)-1L, (long)tracker.firstIncomplete());
    }

    @Test(timeout=30000L)
    public void testMultiThreaded() throws InterruptedException, ExecutionException {
        final AtomicBoolean done = new AtomicBoolean(false);
        final RequestTracker rt = new RequestTracker("fake id");
        final Checker checker = new Checker();
        ExecutorService exec = Executors.newCachedThreadPool();
        ArrayList futures = Lists.newArrayList();
        for (int i = 0; i < 16; ++i) {
            futures.add(exec.submit(new Callable<Void>(){

                @Override
                public Void call() {
                    while (!done.get()) {
                        long seqNo = rt.newSeqNo();
                        long incomplete = rt.firstIncomplete();
                        checker.check(seqNo, incomplete);
                        rt.rpcCompleted(seqNo);
                    }
                    return null;
                }
            }));
        }
        Thread.sleep(5000L);
        done.set(true);
        for (Future f : futures) {
            f.get();
        }
    }

    private static class Checker {
        long curIncomplete = 0L;

        private Checker() {
        }

        public synchronized void check(long seqNo, long firstIncomplete) {
            Assert.assertTrue((String)"should not send a seq number that was previously marked complete", (seqNo >= this.curIncomplete ? 1 : 0) != 0);
            this.curIncomplete = Math.max(firstIncomplete, this.curIncomplete);
        }
    }
}

