/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.kudu.Common;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.consensus.Metadata;
import org.apache.kudu.test.ProtobufUtils;
import org.apache.kudu.test.junit.RetryRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestRemoteTablet {
    private static final String kClientLocation = "/fake-client";
    private static final String kLocation = "/fake-noclient";
    private static final String kNoLocation = "";
    private static final String[] kUuids = new String[]{"uuid-0", "uuid-1", "uuid-2"};
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testLeaderLastRemovedLast() {
        RemoteTablet tablet = this.getTablet(2);
        Assert.assertEquals((Object)kUuids[2], (Object)tablet.getLeaderServerInfo().getUuid());
        tablet.demoteLeader(kUuids[1]);
        Assert.assertEquals((Object)kUuids[2], (Object)tablet.getLeaderServerInfo().getUuid());
        Assert.assertTrue((boolean)tablet.removeTabletClient(kUuids[1]));
        Assert.assertEquals((Object)kUuids[2], (Object)tablet.getLeaderServerInfo().getUuid());
        Assert.assertFalse((boolean)tablet.removeTabletClient(kUuids[1]));
        Assert.assertTrue((boolean)tablet.removeTabletClient(kUuids[0]));
        Assert.assertEquals((Object)kUuids[2], (Object)tablet.getLeaderServerInfo().getUuid());
        tablet.demoteLeader(kUuids[2]);
        Assert.assertNull((Object)tablet.getLeaderServerInfo());
        tablet.demoteLeader(kUuids[2]);
        Assert.assertNull((Object)tablet.getLeaderServerInfo());
    }

    @Test
    public void testLeaderLastRemovedFirst() {
        RemoteTablet tablet = this.getTablet(2);
        Assert.assertTrue((boolean)tablet.removeTabletClient("uuid-2"));
        Assert.assertNull((Object)tablet.getLeaderServerInfo());
        tablet.demoteLeader("uuid-2");
        Assert.assertNull((Object)tablet.getLeaderServerInfo());
    }

    @Test
    public void testLeaderFirst() {
        RemoteTablet tablet = this.getTablet(0);
        Assert.assertTrue((boolean)tablet.removeTabletClient("uuid-0"));
        Assert.assertNull((Object)tablet.getLeaderServerInfo());
        tablet.demoteLeader("uuid-0");
        Assert.assertNull((Object)tablet.getLeaderServerInfo());
        Assert.assertTrue((boolean)tablet.removeTabletClient("uuid-2"));
    }

    @Test
    public void testLocalReplica() {
        RemoteTablet tablet = TestRemoteTablet.getTablet(0, 0, -1);
        Assert.assertEquals((Object)kUuids[0], (Object)tablet.getClosestServerInfo(kNoLocation).getUuid());
        Assert.assertEquals((Object)kUuids[0], (Object)tablet.getClosestServerInfo(kClientLocation).getUuid());
        tablet = TestRemoteTablet.getTablet(0, 0, 1);
        Assert.assertEquals((Object)kUuids[0], (Object)tablet.getClosestServerInfo(kNoLocation).getUuid());
        Assert.assertEquals((Object)kUuids[0], (Object)tablet.getClosestServerInfo(kClientLocation).getUuid());
        tablet = TestRemoteTablet.getTablet(0, 0, 0);
        Assert.assertEquals((Object)kUuids[0], (Object)tablet.getClosestServerInfo(kNoLocation).getUuid());
        Assert.assertEquals((Object)kUuids[0], (Object)tablet.getClosestServerInfo(kClientLocation).getUuid());
    }

    @Test
    public void testNoLocalOrSameLocationReplica() {
        RemoteTablet tablet = TestRemoteTablet.getTablet(0, -1, -1);
        Assert.assertNotNull((Object)tablet.getClosestServerInfo(kClientLocation).getUuid());
    }

    @Test
    public void testReplicaSelection() {
        RemoteTablet tablet = TestRemoteTablet.getTablet(0, 1, 2);
        Assert.assertEquals((Object)kUuids[0], (Object)tablet.getReplicaSelectedServerInfo(ReplicaSelection.LEADER_ONLY, kClientLocation).getUuid());
        Assert.assertEquals((Object)kUuids[1], (Object)tablet.getReplicaSelectedServerInfo(ReplicaSelection.CLOSEST_REPLICA, kClientLocation).getUuid());
        tablet = TestRemoteTablet.getTablet(0, -1, 1);
        Assert.assertEquals((Object)kUuids[0], (Object)tablet.getReplicaSelectedServerInfo(ReplicaSelection.LEADER_ONLY, kClientLocation).getUuid());
        Assert.assertEquals((Object)kUuids[1], (Object)tablet.getReplicaSelectedServerInfo(ReplicaSelection.CLOSEST_REPLICA, kClientLocation).getUuid());
    }

    @Test
    public void testGetReplicaSelectedServerInfoDeterminism() {
        RemoteTablet tabletWithLocal = TestRemoteTablet.getTablet(0, 0, 0);
        this.verifyGetReplicaSelectedServerInfoDeterminism(tabletWithLocal);
        RemoteTablet tabletWithSameLocation = TestRemoteTablet.getTablet(0, -1, 0);
        this.verifyGetReplicaSelectedServerInfoDeterminism(tabletWithSameLocation);
        RemoteTablet tabletWithRemote = TestRemoteTablet.getTablet(0, -1, -1);
        this.verifyGetReplicaSelectedServerInfoDeterminism(tabletWithRemote);
    }

    private void verifyGetReplicaSelectedServerInfoDeterminism(RemoteTablet tablet) {
        String init = tablet.getReplicaSelectedServerInfo(ReplicaSelection.CLOSEST_REPLICA, kClientLocation).getUuid();
        for (int i = 0; i < 10; ++i) {
            String next = tablet.getReplicaSelectedServerInfo(ReplicaSelection.CLOSEST_REPLICA, kClientLocation).getUuid();
            Assert.assertEquals((String)"getReplicaSelectedServerInfo was not deterministic", (Object)init, (Object)next);
        }
    }

    @Test
    public void testToString() {
        RemoteTablet tablet = TestRemoteTablet.getTablet(0, 1, -1);
        Assert.assertEquals((Object)"fake tablet@[uuid-0(host:1000)[L],uuid-1(host:1001),uuid-2(host:1002)]", (Object)tablet.toString());
    }

    private RemoteTablet getTablet(int leaderIndex) {
        return TestRemoteTablet.getTablet(leaderIndex, -1, -1);
    }

    static RemoteTablet getTablet(int leaderIndex, int localReplicaIndex, int sameLocationReplicaIndex) {
        Partition partition = ProtobufHelper.pbToPartition((Common.PartitionPB)ProtobufUtils.getFakePartitionPB().build());
        ArrayList<LocatedTablet.Replica> replicas = new ArrayList<LocatedTablet.Replica>();
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
        for (int i = 0; i < 3; ++i) {
            InetAddress addr;
            try {
                addr = i == localReplicaIndex ? InetAddress.getByName("127.0.0.1") : InetAddress.getByName("1.2.3.4");
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            String uuid = kUuids[i];
            String location = i == sameLocationReplicaIndex ? kClientLocation : kLocation;
            servers.add(new ServerInfo(uuid, new HostAndPort("host", 1000 + i), addr, location));
            Metadata.RaftPeerPB.Role role = leaderIndex == i ? Metadata.RaftPeerPB.Role.LEADER : Metadata.RaftPeerPB.Role.FOLLOWER;
            replicas.add(new LocatedTablet.Replica("host", Integer.valueOf(i), role, null));
        }
        return new RemoteTablet("fake table", "fake tablet", partition, replicas, servers);
    }
}

