/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.io.Closeable;
import junit.framework.TestCase;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.test.CapturingLogAppender;
import org.apache.kudu.test.cluster.FakeDNS;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.apache.kudu.test.junit.RetryRule;
import org.junit.Rule;
import org.junit.Test;

public class TestNegotiation {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testSaslPlainFallback() throws Exception {
        FakeDNS.getInstance().install();
        MiniKuduCluster.MiniKuduClusterBuilder clusterBuilder = new MiniKuduCluster.MiniKuduClusterBuilder();
        clusterBuilder.numMasterServers(1).numTabletServers(0).enableKerberos().addMasterServerFlag("--rpc-authentication=optional").addMasterServerFlag("--rpc-trace-negotiation").addMasterServerFlag("--user-acl=*");
        CapturingLogAppender cla = new CapturingLogAppender();
        try (MiniKuduCluster cluster = clusterBuilder.build();){
            cluster.kdestroy();
            try (Closeable c = cla.attach();
                 KuduClient client = new KuduClient.KuduClientBuilder(cluster.getMasterAddressesAsString()).build();){
                TestCase.assertTrue((boolean)client.getTablesList().getTablesList().isEmpty());
            }
        }
        TestCase.assertTrue((String)cla.getAppendedText(), (boolean)cla.getAppendedText().contains("Client requested to use mechanism: PLAIN"));
    }
}

