/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.List;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.junit.AssertHelpers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestMultipleLeaderFailover {
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    private void waitUntilRowCount(final KuduTable table, final int rowCount, long timeoutMs) throws Exception {
        AssertHelpers.assertEventuallyTrue((String)String.format("Read count should be %s", rowCount), (AssertHelpers.BooleanExpression)new AssertHelpers.BooleanExpression(){

            public boolean get() throws Exception {
                AsyncKuduScanner scanner = TestMultipleLeaderFailover.this.harness.getAsyncClient().newScannerBuilder(table).build();
                int readCount = ClientTestUtil.countRowsInScan((AsyncKuduScanner)scanner);
                return readCount == rowCount;
            }
        }, (long)timeoutMs);
    }

    @Test(timeout=100000L)
    public void testMultipleFailover() throws Exception {
        CreateTableOptions builder = ClientTestUtil.getBasicCreateTableOptions();
        String tableName = TestMultipleLeaderFailover.class.getName() + "-" + System.currentTimeMillis();
        this.harness.getClient().createTable(tableName, ClientTestUtil.getBasicSchema(), builder);
        KuduTable table = this.harness.getClient().openTable(tableName);
        KuduSession session = this.harness.getClient().newSession();
        int ROWS_PER_ITERATION = 3;
        int NUM_ITERATIONS = 10;
        int TOTAL_ROWS_TO_INSERT = 33;
        for (int i = 0; i < 3; ++i) {
            session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)i));
        }
        this.waitUntilRowCount(table, 3, 50000L);
        int currentRows = 3;
        for (int i = 0; i < 10; ++i) {
            List tablets = table.getTabletsLocations(50000L);
            Assert.assertEquals((long)1L, (long)tablets.size());
            this.harness.killTabletLeader((LocatedTablet)tablets.get(0));
            for (int j = 0; j < 3; ++j) {
                OperationResponse resp = session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)currentRows));
                if (resp.hasRowError()) {
                    Assert.fail((String)("Encountered a row error " + resp.getRowError()));
                }
                ++currentRows;
            }
            this.harness.startAllTabletServers();
            this.waitUntilRowCount(table, currentRows, 50000L);
        }
        this.waitUntilRowCount(table, 33, 50000L);
    }
}

