/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestMasterFailover {
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Test(timeout=30000L)
    public void testKillLeaderBeforeCreateClient() throws Exception {
        this.doTestKillLeader(KillBefore.CREATE_CLIENT);
    }

    @Test(timeout=30000L)
    public void testKillLeaderBeforeCreateTable() throws Exception {
        this.doTestKillLeader(KillBefore.CREATE_TABLE);
    }

    @Test(timeout=30000L)
    public void testKillLeaderBeforeOpenTable() throws Exception {
        this.doTestKillLeader(KillBefore.OPEN_TABLE);
    }

    @Test(timeout=30000L)
    public void testKillLeaderBeforeScanTable() throws Exception {
        this.doTestKillLeader(KillBefore.SCAN_TABLE);
    }

    private void doTestKillLeader(KillBefore killBefore) throws Exception {
        String tableName = "TestMasterFailover-killBefore=" + (Object)((Object)killBefore);
        int countMasters = this.harness.getMasterServers().size();
        if (countMasters < 3) {
            throw new Exception("This test requires at least 3 master servers, but only " + countMasters + " are specified.");
        }
        if (killBefore == KillBefore.CREATE_CLIENT) {
            this.harness.killLeaderMasterServer();
        }
        try (KuduClient c = new KuduClient.KuduClientBuilder(this.harness.getMasterAddressesAsString()).build();){
            if (killBefore == KillBefore.CREATE_TABLE) {
                this.harness.killLeaderMasterServer();
            }
            this.harness.getClient().createTable(tableName, ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions());
            if (killBefore == KillBefore.OPEN_TABLE) {
                this.harness.killLeaderMasterServer();
            }
            KuduTable table = this.harness.getClient().openTable(tableName);
            if (killBefore == KillBefore.SCAN_TABLE) {
                this.harness.killLeaderMasterServer();
            }
            Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)this.harness.getAsyncClient().newScannerBuilder(table).build()));
        }
    }

    static enum KillBefore {
        CREATE_CLIENT,
        CREATE_TABLE,
        OPEN_TABLE,
        SCAN_TABLE;

    }
}

