/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestLeaderFailover {
    private static final String TABLE_NAME = TestLeaderFailover.class.getName() + "-" + System.currentTimeMillis();
    private KuduTable table;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() throws Exception {
        CreateTableOptions builder = ClientTestUtil.getBasicCreateTableOptions();
        this.harness.getClient().createTable(TABLE_NAME, ClientTestUtil.getBasicSchema(), builder);
        this.table = this.harness.getClient().openTable(TABLE_NAME);
    }

    @Test(timeout=100000L)
    public void testFailover() throws Exception {
        KuduSession session = this.harness.getClient().newSession();
        for (int i = 0; i < 3; ++i) {
            session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)this.table, (int)i));
        }
        AsyncKuduScanner scanner = this.harness.getAsyncClient().newScannerBuilder(this.table).build();
        Assert.assertEquals((long)3L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)scanner));
        this.harness.killTabletLeader(this.table);
        for (int i = 3; i < 6; ++i) {
            OperationResponse resp = session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)this.table, (int)i));
            if (!resp.hasRowError()) continue;
            Assert.fail((String)("Encountered a row error " + resp.getRowError()));
        }
        scanner = this.harness.getAsyncClient().newScannerBuilder(this.table).build();
        Assert.assertEquals((long)6L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)scanner));
    }
}

