/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Type;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.util.CharUtil;
import org.apache.kudu.util.DecimalUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestKuduPredicate {
    private static final ColumnSchema boolCol = new ColumnSchema.ColumnSchemaBuilder("bool", Type.BOOL).build();
    private static final ColumnSchema byteCol = new ColumnSchema.ColumnSchemaBuilder("byte", Type.INT8).build();
    private static final ColumnSchema shortCol = new ColumnSchema.ColumnSchemaBuilder("short", Type.INT16).build();
    private static final ColumnSchema intCol = new ColumnSchema.ColumnSchemaBuilder("int", Type.INT32).build();
    private static final ColumnSchema longCol = new ColumnSchema.ColumnSchemaBuilder("long", Type.INT64).build();
    private static final ColumnSchema floatCol = new ColumnSchema.ColumnSchemaBuilder("float", Type.FLOAT).build();
    private static final ColumnSchema doubleCol = new ColumnSchema.ColumnSchemaBuilder("double", Type.DOUBLE).build();
    private static final ColumnSchema stringCol = new ColumnSchema.ColumnSchemaBuilder("string", Type.STRING).nullable(true).build();
    private static final ColumnSchema binaryCol = new ColumnSchema.ColumnSchemaBuilder("binary", Type.BINARY).build();
    private static final ColumnSchema decimal32Col = new ColumnSchema.ColumnSchemaBuilder("decimal32", Type.DECIMAL).typeAttributes(DecimalUtil.typeAttributes((int)9, (int)2)).build();
    private static final ColumnSchema decimal64Col = new ColumnSchema.ColumnSchemaBuilder("decimal64", Type.DECIMAL).typeAttributes(DecimalUtil.typeAttributes((int)18, (int)2)).build();
    private static final ColumnSchema decimal128Col = new ColumnSchema.ColumnSchemaBuilder("decimal128", Type.DECIMAL).typeAttributes(DecimalUtil.typeAttributes((int)38, (int)2)).build();
    private static final ColumnSchema varcharCol = new ColumnSchema.ColumnSchemaBuilder("varchar", Type.VARCHAR).typeAttributes(CharUtil.typeAttributes((int)10)).nullable(true).build();
    @Rule
    public RetryRule retryRule = new RetryRule();

    private static KuduPredicate intRange(int lower, int upper) {
        Preconditions.checkArgument((lower < upper ? 1 : 0) != 0);
        return new KuduPredicate(KuduPredicate.PredicateType.RANGE, intCol, Bytes.fromInt((int)lower), Bytes.fromInt((int)upper));
    }

    private static KuduPredicate intInList(Integer ... values) {
        return KuduPredicate.newInListPredicate((ColumnSchema)intCol, Arrays.asList(values));
    }

    private static KuduPredicate boolInList(Boolean ... values) {
        return KuduPredicate.newInListPredicate((ColumnSchema)boolCol, Arrays.asList(values));
    }

    private static KuduPredicate stringInList(String ... values) {
        return KuduPredicate.newInListPredicate((ColumnSchema)stringCol, Arrays.asList(values));
    }

    private void testMerge(KuduPredicate a, KuduPredicate b, KuduPredicate expected) {
        Assert.assertEquals((Object)expected, (Object)a.merge(b));
        Assert.assertEquals((Object)expected, (Object)b.merge(a));
    }

    @Test
    public void testMergeInt() {
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)1L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)10L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)10L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)5L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)5L));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)5L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)5L));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)0L));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)-10L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)-10L));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)10L), TestKuduPredicate.intRange(0, 10));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)5L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)6L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)5L));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)5L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)5L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)5L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)3L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(TestKuduPredicate.intRange(0, 10), TestKuduPredicate.intRange(0, 10), TestKuduPredicate.intRange(0, 10));
        this.testMerge(TestKuduPredicate.intRange(0, 10), TestKuduPredicate.intRange(0, 5), TestKuduPredicate.intRange(0, 5));
        this.testMerge(TestKuduPredicate.intRange(0, 10), TestKuduPredicate.intRange(3, 8), TestKuduPredicate.intRange(3, 8));
        this.testMerge(TestKuduPredicate.intRange(0, 8), TestKuduPredicate.intRange(3, 10), TestKuduPredicate.intRange(3, 8));
        this.testMerge(TestKuduPredicate.intRange(0, 5), TestKuduPredicate.intRange(5, 10), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(TestKuduPredicate.intRange(0, 3), TestKuduPredicate.intRange(5, 10), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), TestKuduPredicate.intRange(5, 10), TestKuduPredicate.intRange(5, 10));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)5L), TestKuduPredicate.intRange(5, 10), TestKuduPredicate.intRange(5, 10));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)5L), TestKuduPredicate.intRange(0, 10), TestKuduPredicate.intRange(5, 10));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)10L), TestKuduPredicate.intRange(0, 5), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)10L), TestKuduPredicate.intRange(3, 8), TestKuduPredicate.intRange(3, 8));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)10L), TestKuduPredicate.intRange(5, 10), TestKuduPredicate.intRange(5, 10));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)5L), TestKuduPredicate.intRange(0, 10), TestKuduPredicate.intRange(0, 5));
        this.testMerge(TestKuduPredicate.intRange(3, 5), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)1L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(TestKuduPredicate.intRange(0, 5), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L));
        this.testMerge(TestKuduPredicate.intRange(0, 5), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)3L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)3L));
        this.testMerge(TestKuduPredicate.intRange(0, 5), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)5L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(TestKuduPredicate.intRange(0, 5), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)7L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(TestKuduPredicate.intInList(0, 10, 20), TestKuduPredicate.intInList(20, 10, 20, 30), TestKuduPredicate.intInList(10, 20));
        this.testMerge(TestKuduPredicate.intInList(0, 20), TestKuduPredicate.intInList(15, 30), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(TestKuduPredicate.intInList(10), KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L));
        this.testMerge(TestKuduPredicate.intInList(10, -100), KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol), TestKuduPredicate.intInList(-100, 10));
        this.testMerge(TestKuduPredicate.intInList(0, 10, 20), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L));
        this.testMerge(TestKuduPredicate.intInList(0, 10, 20), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)30L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(TestKuduPredicate.intInList(0, 10, 20, 30, 40), TestKuduPredicate.intRange(10, 30), TestKuduPredicate.intInList(10, 20));
        this.testMerge(TestKuduPredicate.intInList(0, 10, 20, 30), TestKuduPredicate.intRange(25, 30), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(TestKuduPredicate.intInList(0, 10, 20, 30), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)15L), TestKuduPredicate.intInList(20, 30));
        this.testMerge(TestKuduPredicate.intInList(0, 10, 20), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)15L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)20L));
        this.testMerge(TestKuduPredicate.intInList(0, 10), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)15L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(TestKuduPredicate.intInList(0, 10, 20, 30), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)15L), TestKuduPredicate.intInList(0, 10));
        this.testMerge(TestKuduPredicate.intInList(0, 10, 20), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)10L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L));
        this.testMerge(TestKuduPredicate.intInList(10, 20), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)5L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.none((ColumnSchema)intCol), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.none((ColumnSchema)intCol), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)0L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.none((ColumnSchema)intCol), TestKuduPredicate.intRange(3, 7), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.none((ColumnSchema)intCol), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)5L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.none((ColumnSchema)intCol), KuduPredicate.none((ColumnSchema)intCol), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol), KuduPredicate.none((ColumnSchema)intCol), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol), KuduPredicate.newIsNullPredicate((ColumnSchema)intCol), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol), KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol), KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)5L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)5L));
        this.testMerge(KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)5L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)5L));
        this.testMerge(KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)5L), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)5L));
        this.testMerge(KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol), TestKuduPredicate.intRange(0, 12), TestKuduPredicate.intRange(0, 12));
        this.testMerge(KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol), TestKuduPredicate.intInList(0, 10, 20), TestKuduPredicate.intInList(0, 10, 20));
        this.testMerge(KuduPredicate.newIsNullPredicate((ColumnSchema)intCol), KuduPredicate.none((ColumnSchema)intCol), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newIsNullPredicate((ColumnSchema)intCol), KuduPredicate.newIsNullPredicate((ColumnSchema)intCol), KuduPredicate.newIsNullPredicate((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newIsNullPredicate((ColumnSchema)intCol), KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newIsNullPredicate((ColumnSchema)intCol), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)5L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newIsNullPredicate((ColumnSchema)intCol), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newIsNullPredicate((ColumnSchema)intCol), KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)5L), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newIsNullPredicate((ColumnSchema)intCol), TestKuduPredicate.intRange(0, 12), KuduPredicate.none((ColumnSchema)intCol));
        this.testMerge(KuduPredicate.newIsNullPredicate((ColumnSchema)intCol), TestKuduPredicate.intInList(0, 10, 20), KuduPredicate.none((ColumnSchema)intCol));
    }

    @Test
    public void testMergeString() {
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)"b\u0000"), KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"b"), KuduPredicate.none((ColumnSchema)stringCol));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)"b"), KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"b"), KuduPredicate.none((ColumnSchema)stringCol));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)"b"), KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"b\u0000"), KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"b"));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)"a"), KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"a\u0000\u0000"), new KuduPredicate(KuduPredicate.PredicateType.RANGE, stringCol, Bytes.fromString((String)"a"), Bytes.fromString((String)"a\u0000\u0000")));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)"a"), TestKuduPredicate.stringInList("a", "c", "b", ""), TestKuduPredicate.stringInList("a", "b", "c"));
        this.testMerge(KuduPredicate.newIsNotNullPredicate((ColumnSchema)stringCol), TestKuduPredicate.stringInList("a", "c", "b", ""), TestKuduPredicate.stringInList("", "a", "b", "c"));
    }

    @Test
    public void testBoolean() {
        Assert.assertEquals((Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)boolCol), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (boolean)false));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (boolean)true), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (boolean)false));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (boolean)false), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (boolean)false));
        Assert.assertEquals((Object)KuduPredicate.none((ColumnSchema)boolCol), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (boolean)false));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (boolean)false), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (boolean)false));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (boolean)true), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (boolean)true));
        Assert.assertEquals((Object)KuduPredicate.none((ColumnSchema)boolCol), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (boolean)true));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (boolean)true), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (boolean)true));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (boolean)false), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (boolean)true));
        Assert.assertEquals((Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)boolCol), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (boolean)true));
        Assert.assertEquals((Object)KuduPredicate.none((ColumnSchema)boolCol), (Object)TestKuduPredicate.boolInList(new Boolean[0]));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (boolean)true), (Object)TestKuduPredicate.boolInList(true, true, true));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (boolean)false), (Object)TestKuduPredicate.boolInList(false));
        Assert.assertEquals((Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)boolCol), (Object)TestKuduPredicate.boolInList(false, true, false, true));
    }

    @Test
    public void testAllTypesMerge() {
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (boolean)false), KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (boolean)true), new KuduPredicate(KuduPredicate.PredicateType.EQUALITY, boolCol, Bytes.fromBoolean((boolean)false), null));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (boolean)false), KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (boolean)true), KuduPredicate.newIsNotNullPredicate((ColumnSchema)boolCol));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)10L), new KuduPredicate(KuduPredicate.PredicateType.RANGE, byteCol, new byte[]{0}, new byte[]{10}));
        this.testMerge(KuduPredicate.newInListPredicate((ColumnSchema)byteCol, (List)ImmutableList.of((Object)12, (Object)14, (Object)16, (Object)18)), KuduPredicate.newInListPredicate((ColumnSchema)byteCol, (List)ImmutableList.of((Object)14, (Object)18, (Object)20)), KuduPredicate.newInListPredicate((ColumnSchema)byteCol, (List)ImmutableList.of((Object)14, (Object)18)));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)10L), new KuduPredicate(KuduPredicate.PredicateType.RANGE, shortCol, Bytes.fromShort((short)0), Bytes.fromShort((short)10)));
        this.testMerge(KuduPredicate.newInListPredicate((ColumnSchema)shortCol, (List)ImmutableList.of((Object)12, (Object)14, (Object)16, (Object)18)), KuduPredicate.newInListPredicate((ColumnSchema)shortCol, (List)ImmutableList.of((Object)14, (Object)18, (Object)20)), KuduPredicate.newInListPredicate((ColumnSchema)shortCol, (List)ImmutableList.of((Object)14, (Object)18)));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)10L), new KuduPredicate(KuduPredicate.PredicateType.RANGE, longCol, Bytes.fromLong((long)0L), Bytes.fromLong((long)10L)));
        this.testMerge(KuduPredicate.newInListPredicate((ColumnSchema)longCol, (List)ImmutableList.of((Object)12L, (Object)14L, (Object)16L, (Object)18L)), KuduPredicate.newInListPredicate((ColumnSchema)longCol, (List)ImmutableList.of((Object)14L, (Object)18L, (Object)20L)), KuduPredicate.newInListPredicate((ColumnSchema)longCol, (List)ImmutableList.of((Object)14L, (Object)18L)));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (float)123.45f), KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (float)678.9f), new KuduPredicate(KuduPredicate.PredicateType.RANGE, floatCol, Bytes.fromFloat((float)123.45f), Bytes.fromFloat((float)678.9f)));
        this.testMerge(KuduPredicate.newInListPredicate((ColumnSchema)floatCol, (List)ImmutableList.of((Object)Float.valueOf(12.0f), (Object)Float.valueOf(14.0f), (Object)Float.valueOf(16.0f), (Object)Float.valueOf(18.0f))), KuduPredicate.newInListPredicate((ColumnSchema)floatCol, (List)ImmutableList.of((Object)Float.valueOf(14.0f), (Object)Float.valueOf(18.0f), (Object)Float.valueOf(20.0f))), KuduPredicate.newInListPredicate((ColumnSchema)floatCol, (List)ImmutableList.of((Object)Float.valueOf(14.0f), (Object)Float.valueOf(18.0f))));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (double)123.45), KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (double)678.9), new KuduPredicate(KuduPredicate.PredicateType.RANGE, doubleCol, Bytes.fromDouble((double)123.45), Bytes.fromDouble((double)678.9)));
        this.testMerge(KuduPredicate.newInListPredicate((ColumnSchema)doubleCol, (List)ImmutableList.of((Object)12.0, (Object)14.0, (Object)16.0, (Object)18.0)), KuduPredicate.newInListPredicate((ColumnSchema)doubleCol, (List)ImmutableList.of((Object)14.0, (Object)18.0, (Object)20.0)), KuduPredicate.newInListPredicate((ColumnSchema)doubleCol, (List)ImmutableList.of((Object)14.0, (Object)18.0)));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (BigDecimal)BigDecimal.valueOf(12345L, 2)), KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (BigDecimal)BigDecimal.valueOf(67890L, 2)), new KuduPredicate(KuduPredicate.PredicateType.RANGE, decimal32Col, Bytes.fromBigDecimal((BigDecimal)BigDecimal.valueOf(12345L, 2), (int)9), Bytes.fromBigDecimal((BigDecimal)BigDecimal.valueOf(67890L, 2), (int)9)));
        this.testMerge(KuduPredicate.newInListPredicate((ColumnSchema)decimal32Col, (List)ImmutableList.of((Object)BigDecimal.valueOf(12345L, 2), (Object)BigDecimal.valueOf(45678L, 2))), KuduPredicate.newInListPredicate((ColumnSchema)decimal32Col, (List)ImmutableList.of((Object)BigDecimal.valueOf(45678L, 2), (Object)BigDecimal.valueOf(98765L, 2))), KuduPredicate.newInListPredicate((ColumnSchema)decimal32Col, (List)ImmutableList.of((Object)BigDecimal.valueOf(45678L, 2))));
        this.testMerge(KuduPredicate.newInListPredicate((ColumnSchema)decimal64Col, (List)ImmutableList.of((Object)BigDecimal.valueOf(12345678910L, 2), (Object)BigDecimal.valueOf(34567891011L, 2))), KuduPredicate.newInListPredicate((ColumnSchema)decimal64Col, (List)ImmutableList.of((Object)BigDecimal.valueOf(34567891011L, 2), (Object)BigDecimal.valueOf(98765432111L, 2))), KuduPredicate.newInListPredicate((ColumnSchema)decimal64Col, (List)ImmutableList.of((Object)BigDecimal.valueOf(34567891011L, 2))));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)decimal64Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (BigDecimal)BigDecimal.valueOf(12345678910L, 2)), KuduPredicate.newComparisonPredicate((ColumnSchema)decimal64Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (BigDecimal)BigDecimal.valueOf(67890101112L, 2)), new KuduPredicate(KuduPredicate.PredicateType.RANGE, decimal64Col, Bytes.fromBigDecimal((BigDecimal)BigDecimal.valueOf(12345678910L, 2), (int)18), Bytes.fromBigDecimal((BigDecimal)BigDecimal.valueOf(67890101112L, 2), (int)18)));
        this.testMerge(KuduPredicate.newInListPredicate((ColumnSchema)decimal128Col, (List)ImmutableList.of((Object)new BigDecimal("1234567891011121314.15"), (Object)new BigDecimal("3456789101112131415.16"))), KuduPredicate.newInListPredicate((ColumnSchema)decimal128Col, (List)ImmutableList.of((Object)new BigDecimal("3456789101112131415.16"), (Object)new BigDecimal("9876543212345678910.11"))), KuduPredicate.newInListPredicate((ColumnSchema)decimal128Col, (List)ImmutableList.of((Object)new BigDecimal("3456789101112131415.16"))));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)decimal128Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (BigDecimal)new BigDecimal("1234567891011121314.15")), KuduPredicate.newComparisonPredicate((ColumnSchema)decimal128Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (BigDecimal)new BigDecimal("67891011121314151617.18")), new KuduPredicate(KuduPredicate.PredicateType.RANGE, decimal128Col, Bytes.fromBigDecimal((BigDecimal)new BigDecimal("1234567891011121314.15"), (int)38), Bytes.fromBigDecimal((BigDecimal)new BigDecimal("67891011121314151617.18"), (int)38)));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)binaryCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (byte[])new byte[]{0, 1, 2, 3, 4, 5, 6}), KuduPredicate.newComparisonPredicate((ColumnSchema)binaryCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (byte[])new byte[]{10}), new KuduPredicate(KuduPredicate.PredicateType.RANGE, binaryCol, new byte[]{0, 1, 2, 3, 4, 5, 6}, new byte[]{10}));
        this.testMerge(KuduPredicate.newComparisonPredicate((ColumnSchema)varcharCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)"bar"), KuduPredicate.newComparisonPredicate((ColumnSchema)varcharCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"foo"), new KuduPredicate(KuduPredicate.PredicateType.RANGE, varcharCol, new byte[]{98, 97, 114}, new byte[]{102, 111, 111}));
        byte[] valA = "a".getBytes(StandardCharsets.UTF_8);
        byte[] valB = "b".getBytes(StandardCharsets.UTF_8);
        byte[] valC = "c".getBytes(StandardCharsets.UTF_8);
        byte[] valD = "d".getBytes(StandardCharsets.UTF_8);
        byte[] valE = "e".getBytes(StandardCharsets.UTF_8);
        this.testMerge(KuduPredicate.newInListPredicate((ColumnSchema)binaryCol, (List)ImmutableList.of((Object)valA, (Object)valB, (Object)valC, (Object)valD)), KuduPredicate.newInListPredicate((ColumnSchema)binaryCol, (List)ImmutableList.of((Object)valB, (Object)valD, (Object)valE)), KuduPredicate.newInListPredicate((ColumnSchema)binaryCol, (List)ImmutableList.of((Object)valB, (Object)valD)));
    }

    @Test
    public void testLessEqual() {
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (long)10L), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)11L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (long)10L), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)11L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (long)10L), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)11L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (long)10L), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)11L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (float)12.345f), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (float)Math.nextAfter(12.345f, Double.POSITIVE_INFINITY)));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (double)12.345), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (double)Math.nextAfter(12.345, Double.POSITIVE_INFINITY)));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (BigDecimal)BigDecimal.valueOf(12345L, 2)), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (BigDecimal)BigDecimal.valueOf(12346L, 2)));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (String)"a"), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"a\u0000"));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)binaryCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (byte[])new byte[]{10}), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)binaryCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (byte[])new byte[]{10, 0}));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)varcharCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (String)"a"), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)varcharCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"a\u0000"));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (long)127L), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)byteCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (long)32767L), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)shortCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (long)Integer.MAX_VALUE), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (long)Long.MAX_VALUE), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)longCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (float)Float.MAX_VALUE), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (float)Float.POSITIVE_INFINITY));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (float)Float.POSITIVE_INFINITY), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)floatCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (double)Double.MAX_VALUE), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (double)Double.POSITIVE_INFINITY));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (double)Double.POSITIVE_INFINITY), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)doubleCol));
    }

    @Test
    public void testGreater() {
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)11L), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (long)10L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)11L), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (long)10L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)11L), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (long)10L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)11L), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (long)10L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (float)Math.nextAfter(12.345f, 3.4028234663852886E38)), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (float)12.345f));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (double)Math.nextAfter(12.345, 3.4028234663852886E38)), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (double)12.345));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (BigDecimal)BigDecimal.valueOf(12346L, 2)), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (BigDecimal)BigDecimal.valueOf(12345L, 2)));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)"a\u0000"), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (String)"a"));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)binaryCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (byte[])new byte[]{10, 0}), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)binaryCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (byte[])new byte[]{10}));
        Assert.assertEquals((Object)KuduPredicate.none((ColumnSchema)byteCol), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (long)127L));
        Assert.assertEquals((Object)KuduPredicate.none((ColumnSchema)shortCol), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (long)32767L));
        Assert.assertEquals((Object)KuduPredicate.none((ColumnSchema)intCol), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (long)Integer.MAX_VALUE));
        Assert.assertEquals((Object)KuduPredicate.none((ColumnSchema)longCol), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (long)Long.MAX_VALUE));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (float)Float.POSITIVE_INFINITY), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (float)Float.MAX_VALUE));
        Assert.assertEquals((Object)KuduPredicate.none((ColumnSchema)floatCol), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (float)Float.POSITIVE_INFINITY));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (double)Double.POSITIVE_INFINITY), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (double)Double.MAX_VALUE));
        Assert.assertEquals((Object)KuduPredicate.none((ColumnSchema)doubleCol), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (double)Double.POSITIVE_INFINITY));
    }

    @Test
    public void testLess() {
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)-128L), (Object)KuduPredicate.none((ColumnSchema)byteCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)-32768L), (Object)KuduPredicate.none((ColumnSchema)shortCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)Integer.MIN_VALUE), (Object)KuduPredicate.none((ColumnSchema)intCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)Long.MIN_VALUE), (Object)KuduPredicate.none((ColumnSchema)longCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (float)Float.NEGATIVE_INFINITY), (Object)KuduPredicate.none((ColumnSchema)floatCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (double)Double.NEGATIVE_INFINITY), (Object)KuduPredicate.none((ColumnSchema)doubleCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (BigDecimal)DecimalUtil.minValue((int)9, (int)2)), (Object)KuduPredicate.none((ColumnSchema)decimal32Col));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal64Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (BigDecimal)DecimalUtil.minValue((int)18, (int)2)), (Object)KuduPredicate.none((ColumnSchema)decimal64Col));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal128Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (BigDecimal)DecimalUtil.minValue((int)38, (int)2)), (Object)KuduPredicate.none((ColumnSchema)decimal128Col));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)""), (Object)KuduPredicate.none((ColumnSchema)stringCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)binaryCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (byte[])new byte[0]), (Object)KuduPredicate.none((ColumnSchema)binaryCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)varcharCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)""), (Object)KuduPredicate.none((ColumnSchema)varcharCol));
    }

    @Test
    public void testGreaterEqual() {
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)-128L), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)byteCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)-32768L), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)shortCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)Integer.MIN_VALUE), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)intCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)Long.MIN_VALUE), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)longCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (float)Float.NEGATIVE_INFINITY), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)floatCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (double)Double.NEGATIVE_INFINITY), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)doubleCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (BigDecimal)DecimalUtil.minValue((int)9, (int)2)), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)decimal32Col));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal64Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (BigDecimal)DecimalUtil.minValue((int)18, (int)2)), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)decimal64Col));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal128Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (BigDecimal)DecimalUtil.minValue((int)38, (int)2)), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)decimal128Col));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)""), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)stringCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)binaryCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (byte[])new byte[0]), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)binaryCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)varcharCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)""), (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)varcharCol));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)127L), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)127L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)32767L), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)32767L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)Integer.MAX_VALUE), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)Integer.MAX_VALUE));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)Long.MAX_VALUE), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)Long.MAX_VALUE));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (float)Float.POSITIVE_INFINITY), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (float)Float.POSITIVE_INFINITY));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (double)Double.POSITIVE_INFINITY), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (double)Double.POSITIVE_INFINITY));
    }

    @Test
    public void testCreateWithObject() {
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (Object)10), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (Object)10), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (Object)10), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (Object)10L), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (Object)Float.valueOf(12.345f)), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (float)12.345f));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (Object)12.345), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (double)12.345));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (Object)BigDecimal.valueOf(12345L, 2)), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (BigDecimal)BigDecimal.valueOf(12345L, 2)));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (Object)"a"), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)binaryCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (Object)new byte[]{10}), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)binaryCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (byte[])new byte[]{10}));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)varcharCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (Object)"a"), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)varcharCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"`bool` = true", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)boolCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (boolean)true).toString());
        Assert.assertEquals((Object)"`byte` = 11", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)byteCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)11L).toString());
        Assert.assertEquals((Object)"`short` = 11", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)shortCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)11L).toString());
        Assert.assertEquals((Object)"`int` = -123", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)intCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)-123L).toString());
        Assert.assertEquals((Object)"`long` = 5454", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)longCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)5454L).toString());
        Assert.assertEquals((Object)"`float` = 123.456", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)floatCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (float)123.456f).toString());
        Assert.assertEquals((Object)"`double` = 123.456", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)doubleCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (double)123.456).toString());
        Assert.assertEquals((Object)"`decimal32` = 123.45", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (BigDecimal)BigDecimal.valueOf(12345L, 2)).toString());
        Assert.assertEquals((Object)"`decimal64` = 123456789.10", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal64Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (BigDecimal)BigDecimal.valueOf(12345678910L, 2)).toString());
        Assert.assertEquals((Object)"`decimal128` = 1234567891011121314.15", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal128Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (BigDecimal)new BigDecimal("1234567891011121314.15")).toString());
        Assert.assertEquals((Object)"`string` = \"my string\"", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)stringCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"my string").toString());
        Assert.assertEquals((Object)"`binary` = 0xAB01CD", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)binaryCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (byte[])new byte[]{-85, 1, -51}).toString());
        Assert.assertEquals((Object)"`int` IN (-10, 0, 10)", (Object)TestKuduPredicate.intInList(10, 0, -10).toString());
        Assert.assertEquals((Object)"`string` IS NOT NULL", (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)stringCol).toString());
        Assert.assertEquals((Object)"`string` IS NULL", (Object)KuduPredicate.newIsNullPredicate((ColumnSchema)stringCol).toString());
        Assert.assertEquals((Object)"`varchar` = \"my varchar\"", (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)varcharCol, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"my varchar").toString());
        Assert.assertEquals((Object)"`varchar` IS NOT NULL", (Object)KuduPredicate.newIsNotNullPredicate((ColumnSchema)varcharCol).toString());
        Assert.assertEquals((Object)"`varchar` IS NULL", (Object)KuduPredicate.newIsNullPredicate((ColumnSchema)varcharCol).toString());
        Assert.assertEquals((Object)"`int` NONE", (Object)KuduPredicate.newIsNullPredicate((ColumnSchema)intCol).toString());
        Assert.assertEquals((Object)"`bool` = true", (Object)KuduPredicate.newInListPredicate((ColumnSchema)boolCol, (List)ImmutableList.of((Object)true)).toString());
        Assert.assertEquals((Object)"`bool` = false", (Object)KuduPredicate.newInListPredicate((ColumnSchema)boolCol, (List)ImmutableList.of((Object)false)).toString());
        Assert.assertEquals((Object)"`bool` IS NOT NULL", (Object)KuduPredicate.newInListPredicate((ColumnSchema)boolCol, (List)ImmutableList.of((Object)false, (Object)true, (Object)true)).toString());
        Assert.assertEquals((Object)"`byte` IN (1, 10, 100)", (Object)KuduPredicate.newInListPredicate((ColumnSchema)byteCol, (List)ImmutableList.of((Object)1, (Object)10, (Object)100)).toString());
        Assert.assertEquals((Object)"`short` IN (1, 10, 100)", (Object)KuduPredicate.newInListPredicate((ColumnSchema)shortCol, (List)ImmutableList.of((Object)1, (Object)100, (Object)10)).toString());
        Assert.assertEquals((Object)"`int` IN (1, 10, 100)", (Object)KuduPredicate.newInListPredicate((ColumnSchema)intCol, (List)ImmutableList.of((Object)1, (Object)100, (Object)10)).toString());
        Assert.assertEquals((Object)"`long` IN (1, 10, 100)", (Object)KuduPredicate.newInListPredicate((ColumnSchema)longCol, (List)ImmutableList.of((Object)1L, (Object)100L, (Object)10L)).toString());
        Assert.assertEquals((Object)"`float` IN (78.9, 123.456)", (Object)KuduPredicate.newInListPredicate((ColumnSchema)floatCol, (List)ImmutableList.of((Object)Float.valueOf(123.456f), (Object)Float.valueOf(78.9f))).toString());
        Assert.assertEquals((Object)"`double` IN (78.9, 123.456)", (Object)KuduPredicate.newInListPredicate((ColumnSchema)doubleCol, (List)ImmutableList.of((Object)123.456, (Object)78.9)).toString());
        Assert.assertEquals((Object)"`string` IN (\"a\", \"my string\")", (Object)KuduPredicate.newInListPredicate((ColumnSchema)stringCol, (List)ImmutableList.of((Object)"my string", (Object)"a")).toString());
        Assert.assertEquals((Object)"`binary` IN (0x00, 0xAB01CD)", (Object)KuduPredicate.newInListPredicate((ColumnSchema)binaryCol, (List)ImmutableList.of((Object)new byte[]{-85, 1, -51}, (Object)new byte[]{0})).toString());
    }

    @Test
    public void testDecimalCoercion() {
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (BigDecimal)BigDecimal.valueOf(123L)), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (BigDecimal)BigDecimal.valueOf(12300L, 2)));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (BigDecimal)BigDecimal.valueOf(123L, 1)), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (BigDecimal)BigDecimal.valueOf(1230L, 2)));
        Assert.assertEquals((Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (BigDecimal)BigDecimal.valueOf(1L, 0)), (Object)KuduPredicate.newComparisonPredicate((ColumnSchema)decimal32Col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (BigDecimal)BigDecimal.valueOf(100L, 2)));
    }
}

