/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Common;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KeyEncoder;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.PartitionSchema;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.util.CharUtil;
import org.apache.kudu.util.DecimalUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestKeyEncoding {
    private KuduClient client;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
    }

    private static Schema buildSchema(ColumnSchema.ColumnSchemaBuilder ... columns) {
        int i = 0;
        Common.SchemaPB.Builder pb = Common.SchemaPB.newBuilder();
        for (ColumnSchema.ColumnSchemaBuilder column : columns) {
            Common.ColumnSchemaPB columnPb = ProtobufHelper.columnToPb((Common.ColumnSchemaPB.Builder)Common.ColumnSchemaPB.newBuilder(), (int)i++, (ColumnSchema)column.build());
            pb.addColumns(columnPb);
        }
        return ProtobufHelper.pbToSchema((Common.SchemaPB)pb.build());
    }

    private static void assertBytesEquals(byte[] actual, byte[] expected) {
        Assert.assertTrue((String)String.format("expected: '%s', got: '%s'", Bytes.pretty((byte[])expected), Bytes.pretty((byte[])actual)), (boolean)Bytes.equals((byte[])expected, (byte[])actual));
    }

    private static void assertBytesEquals(byte[] actual, String expected) {
        TestKeyEncoding.assertBytesEquals(actual, expected.getBytes(StandardCharsets.UTF_8));
    }

    private PartitionSchema defaultPartitionSchema(Schema schema) {
        ArrayList<Integer> columnIds = new ArrayList<Integer>();
        for (int i = 0; i < schema.getPrimaryKeyColumnCount(); ++i) {
            columnIds.add(i);
        }
        return new PartitionSchema(new PartitionSchema.RangeSchema(columnIds), (List)ImmutableList.of(), schema);
    }

    private CreateTableOptions defaultCreateTableOptions(Schema schema) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnSchema columnSchema : schema.getPrimaryKeyColumns()) {
            columnNames.add(columnSchema.getName());
        }
        return new CreateTableOptions().setRangePartitionColumns(columnNames);
    }

    @Test
    public void testPrimaryKeys() {
        Schema schemaOneString = TestKeyEncoding.buildSchema(new ColumnSchema.ColumnSchemaBuilder("key", Type.STRING).key(true));
        KuduTable table = new KuduTable(null, "one", "one", schemaOneString, this.defaultPartitionSchema(schemaOneString), 3, null);
        Insert oneKeyInsert = new Insert(table);
        PartialRow row = oneKeyInsert.getRow();
        row.addString("key", "foo");
        TestKeyEncoding.assertBytesEquals(row.encodePrimaryKey(), "foo");
        Schema schemaTwoString = TestKeyEncoding.buildSchema(new ColumnSchema.ColumnSchemaBuilder("key", Type.STRING).key(true), new ColumnSchema.ColumnSchemaBuilder("key2", Type.STRING).key(true));
        KuduTable table2 = new KuduTable(null, "two", "two", schemaTwoString, this.defaultPartitionSchema(schemaTwoString), 3, null);
        Insert twoKeyInsert = new Insert(table2);
        row = twoKeyInsert.getRow();
        row.addString("key", "foo");
        row.addString("key2", "bar");
        TestKeyEncoding.assertBytesEquals(row.encodePrimaryKey(), "foo\u0000\u0000bar");
        Insert twoKeyInsertWithNull = new Insert(table2);
        row = twoKeyInsertWithNull.getRow();
        row.addString("key", "xxx\u0000yyy");
        row.addString("key2", "bar");
        TestKeyEncoding.assertBytesEquals(row.encodePrimaryKey(), "xxx\u0000\u0001yyy\u0000\u0000bar");
        Schema schemaIntString = TestKeyEncoding.buildSchema(new ColumnSchema.ColumnSchemaBuilder("key", Type.INT32).key(true), new ColumnSchema.ColumnSchemaBuilder("key2", Type.STRING).key(true));
        PartitionSchema partitionSchemaIntString = this.defaultPartitionSchema(schemaIntString);
        KuduTable table3 = new KuduTable(null, "three", "three", schemaIntString, partitionSchemaIntString, 3, null);
        Insert small = new Insert(table3);
        row = small.getRow();
        row.addInt("key", 20);
        row.addString("key2", "data");
        byte[] smallPK = small.getRow().encodePrimaryKey();
        Assert.assertEquals((long)0L, (long)Bytes.memcmp((byte[])smallPK, (byte[])smallPK));
        Insert big = new Insert(table3);
        row = big.getRow();
        row.addInt("key", 10000);
        row.addString("key2", "data");
        byte[] bigPK = big.getRow().encodePrimaryKey();
        Assert.assertTrue((Bytes.memcmp((byte[])smallPK, (byte[])bigPK) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Bytes.memcmp((byte[])bigPK, (byte[])smallPK) > 0 ? 1 : 0) != 0);
        byte four = 4;
        byte onHundredTwentyFour = -4;
        four = Bytes.xorLeftMostBit((byte)four);
        onHundredTwentyFour = Bytes.xorLeftMostBit((byte)onHundredTwentyFour);
        Assert.assertTrue((four < onHundredTwentyFour ? 1 : 0) != 0);
        byte[] threeHundred = Bytes.fromInt((int)300);
        byte[] reallyBigNumber = Bytes.fromInt((int)-300);
        threeHundred[0] = Bytes.xorLeftMostBit((byte)threeHundred[0]);
        reallyBigNumber[3] = Bytes.xorLeftMostBit((byte)reallyBigNumber[3]);
        Assert.assertTrue((Bytes.memcmp((byte[])threeHundred, (byte[])reallyBigNumber) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPrimaryKeyEncoding() {
        Schema schema = TestKeyEncoding.buildSchema(new ColumnSchema.ColumnSchemaBuilder("int8", Type.INT8).key(true), new ColumnSchema.ColumnSchemaBuilder("int16", Type.INT16).key(true), new ColumnSchema.ColumnSchemaBuilder("int32", Type.INT32).key(true), new ColumnSchema.ColumnSchemaBuilder("int64", Type.INT64).key(true), new ColumnSchema.ColumnSchemaBuilder("decimal32", Type.DECIMAL).key(true).typeAttributes(DecimalUtil.typeAttributes((int)9, (int)0)), new ColumnSchema.ColumnSchemaBuilder("decimal64", Type.DECIMAL).key(true).typeAttributes(DecimalUtil.typeAttributes((int)18, (int)0)), new ColumnSchema.ColumnSchemaBuilder("decimal128", Type.DECIMAL).key(true).typeAttributes(DecimalUtil.typeAttributes((int)38, (int)0)), new ColumnSchema.ColumnSchemaBuilder("varchar", Type.VARCHAR).key(true).typeAttributes(CharUtil.typeAttributes((int)10)), new ColumnSchema.ColumnSchemaBuilder("string", Type.STRING).key(true), new ColumnSchema.ColumnSchemaBuilder("binary", Type.BINARY).key(true));
        PartialRow rowA = schema.newPartialRow();
        rowA.addByte("int8", (byte)-128);
        rowA.addShort("int16", (short)Short.MIN_VALUE);
        rowA.addInt("int32", Integer.MIN_VALUE);
        rowA.addLong("int64", Long.MIN_VALUE);
        rowA.addDecimal("decimal32", BigDecimal.valueOf(5L));
        rowA.addDecimal("decimal64", BigDecimal.valueOf(6L));
        rowA.addDecimal("decimal128", BigDecimal.valueOf(7L));
        rowA.addVarchar("varchar", "");
        rowA.addString("string", "");
        rowA.addBinary("binary", "".getBytes(StandardCharsets.UTF_8));
        byte[] rowAEncoded = rowA.encodePrimaryKey();
        TestKeyEncoding.assertBytesEquals(rowAEncoded, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, 0, 0, 5, -128, 0, 0, 0, 0, 0, 0, 6, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0});
        Assert.assertEquals((Object)rowA.stringifyRowKey(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])rowAEncoded).stringifyRowKey());
        PartialRow rowB = schema.newPartialRow();
        rowB.addByte("int8", (byte)127);
        rowB.addShort("int16", (short)Short.MAX_VALUE);
        rowB.addInt("int32", Integer.MAX_VALUE);
        rowB.addLong("int64", Long.MAX_VALUE);
        rowB.addDecimal("decimal32", BigDecimal.valueOf(5L));
        rowB.addDecimal("decimal64", BigDecimal.valueOf(6L));
        rowB.addDecimal("decimal128", BigDecimal.valueOf(7L));
        rowB.addVarchar("varchar", "abc\u0001\u0000defghij");
        rowB.addString("string", "abc\u0001\u0000def");
        rowB.addBinary("binary", "\u0000\u0001binary".getBytes(StandardCharsets.UTF_8));
        byte[] rowBEncoded = rowB.encodePrimaryKey();
        TestKeyEncoding.assertBytesEquals(rowB.encodePrimaryKey(), new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -128, 0, 0, 5, -128, 0, 0, 0, 0, 0, 0, 6, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 97, 98, 99, 1, 0, 1, 100, 101, 102, 103, 104, 0, 0, 97, 98, 99, 1, 0, 1, 100, 101, 102, 0, 0, 0, 1, 98, 105, 110, 97, 114, 121});
        Assert.assertEquals((Object)rowB.stringifyRowKey(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])rowBEncoded).stringifyRowKey());
        PartialRow rowC = schema.newPartialRow();
        rowC.addByte("int8", (byte)1);
        rowC.addShort("int16", (short)2);
        rowC.addInt("int32", 3);
        rowC.addLong("int64", 4L);
        rowC.addDecimal("decimal32", BigDecimal.valueOf(5L));
        rowC.addDecimal("decimal64", BigDecimal.valueOf(6L));
        rowC.addDecimal("decimal128", BigDecimal.valueOf(7L));
        rowC.addVarchar("varchar", "abc\n12345678");
        rowC.addString("string", "abc\n123");
        rowC.addBinary("binary", "\u0000\u0001\u0002\u0003\u0004\u0005".getBytes(StandardCharsets.UTF_8));
        byte[] rowCEncoded = rowC.encodePrimaryKey();
        TestKeyEncoding.assertBytesEquals(rowCEncoded, new byte[]{-127, -128, 2, -128, 0, 0, 3, -128, 0, 0, 0, 0, 0, 0, 4, -128, 0, 0, 5, -128, 0, 0, 0, 0, 0, 0, 6, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 97, 98, 99, 10, 49, 50, 51, 52, 53, 54, 0, 0, 97, 98, 99, 10, 49, 50, 51, 0, 0, 0, 1, 2, 3, 4, 5});
        Assert.assertEquals((Object)rowC.stringifyRowKey(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])rowCEncoded).stringifyRowKey());
        PartialRow rowD = schema.newPartialRow();
        rowD.addByte("int8", (byte)-1);
        rowD.addShort("int16", (short)-2);
        rowD.addInt("int32", -3);
        rowD.addLong("int64", -4L);
        rowD.addDecimal("decimal32", BigDecimal.valueOf(-5L));
        rowD.addDecimal("decimal64", BigDecimal.valueOf(-6L));
        rowD.addDecimal("decimal128", BigDecimal.valueOf(-7L));
        rowD.addVarchar("varchar", "\u0000abc\n\u0001\u0001\u0000 123\u0001\u0000");
        rowD.addString("string", "\u0000abc\n\u0001\u0001\u0000 123\u0001\u0000");
        rowD.addBinary("binary", "\u0000\u0001\u0002\u0003\u0004\u0005\u0000".getBytes(StandardCharsets.UTF_8));
        byte[] rowDEncoded = rowD.encodePrimaryKey();
        TestKeyEncoding.assertBytesEquals(rowDEncoded, new byte[]{127, 127, -2, 127, -1, -1, -3, 127, -1, -1, -1, -1, -1, -1, -4, 127, -1, -1, -5, 127, -1, -1, -1, -1, -1, -1, -6, 127, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -7, 0, 1, 97, 98, 99, 10, 1, 1, 0, 1, 32, 49, 0, 0, 0, 1, 97, 98, 99, 10, 1, 1, 0, 1, 32, 49, 50, 51, 1, 0, 1, 0, 0, 0, 1, 2, 3, 4, 5, 0});
        Assert.assertEquals((Object)rowD.stringifyRowKey(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])rowDEncoded).stringifyRowKey());
    }

    @Test
    public void testPartitionKeyEncoding() {
        Schema schema = TestKeyEncoding.buildSchema(new ColumnSchema.ColumnSchemaBuilder("a", Type.INT32).key(true), new ColumnSchema.ColumnSchemaBuilder("b", Type.STRING).key(true), new ColumnSchema.ColumnSchemaBuilder("c", Type.STRING).key(true));
        PartitionSchema partitionSchema = new PartitionSchema(new PartitionSchema.RangeSchema((List)ImmutableList.of((Object)0, (Object)1, (Object)2)), (List)ImmutableList.of((Object)new PartitionSchema.HashBucketSchema((List)ImmutableList.of((Object)0, (Object)1), 32, 0), (Object)new PartitionSchema.HashBucketSchema((List)ImmutableList.of((Object)2), 32, 42)), schema);
        PartialRow rowA = schema.newPartialRow();
        rowA.addInt("a", 0);
        rowA.addString("b", "");
        rowA.addString("c", "");
        TestKeyEncoding.assertBytesEquals(KeyEncoder.encodePartitionKey((PartialRow)rowA, (PartitionSchema)partitionSchema), new byte[]{0, 0, 0, 0, 0, 0, 0, 20, -128, 0, 0, 0, 0, 0});
        PartialRow rowB = schema.newPartialRow();
        rowB.addInt("a", 1);
        rowB.addString("b", "");
        rowB.addString("c", "");
        TestKeyEncoding.assertBytesEquals(KeyEncoder.encodePartitionKey((PartialRow)rowB, (PartitionSchema)partitionSchema), new byte[]{0, 0, 0, 5, 0, 0, 0, 20, -128, 0, 0, 1, 0, 0});
        PartialRow rowC = schema.newPartialRow();
        rowC.addInt("a", 0);
        rowC.addString("b", "b");
        rowC.addString("c", "c");
        TestKeyEncoding.assertBytesEquals(KeyEncoder.encodePartitionKey((PartialRow)rowC, (PartitionSchema)partitionSchema), new byte[]{0, 0, 0, 26, 0, 0, 0, 29, -128, 0, 0, 0, 98, 0, 0, 99});
        PartialRow rowD = schema.newPartialRow();
        rowD.addInt("a", 1);
        rowD.addString("b", "b");
        rowD.addString("c", "c");
        TestKeyEncoding.assertBytesEquals(KeyEncoder.encodePartitionKey((PartialRow)rowD, (PartitionSchema)partitionSchema), new byte[]{0, 0, 0, 0, 0, 0, 0, 29, -128, 0, 0, 1, 98, 0, 0, 99});
    }

    @Test(timeout=100000L)
    public void testAllPrimaryKeyTypes() throws Exception {
        Schema schema = TestKeyEncoding.buildSchema(new ColumnSchema.ColumnSchemaBuilder("int8", Type.INT8).key(true), new ColumnSchema.ColumnSchemaBuilder("int16", Type.INT16).key(true), new ColumnSchema.ColumnSchemaBuilder("int32", Type.INT32).key(true), new ColumnSchema.ColumnSchemaBuilder("int64", Type.INT64).key(true), new ColumnSchema.ColumnSchemaBuilder("string", Type.STRING).key(true), new ColumnSchema.ColumnSchemaBuilder("binary", Type.BINARY).key(true), new ColumnSchema.ColumnSchemaBuilder("timestamp", Type.UNIXTIME_MICROS).key(true), new ColumnSchema.ColumnSchemaBuilder("decimal32", Type.DECIMAL).key(true).typeAttributes(DecimalUtil.typeAttributes((int)9, (int)0)), new ColumnSchema.ColumnSchemaBuilder("decimal64", Type.DECIMAL).key(true).typeAttributes(DecimalUtil.typeAttributes((int)18, (int)0)), new ColumnSchema.ColumnSchemaBuilder("decimal128", Type.DECIMAL).key(true).typeAttributes(DecimalUtil.typeAttributes((int)38, (int)0)), new ColumnSchema.ColumnSchemaBuilder("varchar", Type.VARCHAR).key(true).typeAttributes(CharUtil.typeAttributes((int)10)), new ColumnSchema.ColumnSchemaBuilder("date", Type.DATE).key(true), new ColumnSchema.ColumnSchemaBuilder("bool", Type.BOOL), new ColumnSchema.ColumnSchemaBuilder("float", Type.FLOAT), new ColumnSchema.ColumnSchemaBuilder("double", Type.DOUBLE));
        KuduTable table = this.client.createTable("testAllPrimaryKeyTypes-" + System.currentTimeMillis(), schema, this.defaultCreateTableOptions(schema));
        KuduSession session = this.client.newSession();
        Insert insert = table.newInsert();
        PartialRow row = insert.getRow();
        row.addByte(0, (byte)1);
        row.addShort(1, (short)2);
        row.addInt(2, 3);
        row.addLong(3, 4L);
        row.addString(4, "foo");
        row.addBinary(5, "bar".getBytes(StandardCharsets.UTF_8));
        row.addLong(6, 6L);
        row.addDecimal(7, BigDecimal.valueOf(999999999L));
        row.addDecimal(8, BigDecimal.valueOf(999999999999999999L));
        row.addDecimal(9, new BigDecimal(DecimalUtil.MAX_UNSCALED_DECIMAL128));
        row.addVarchar(10, "varchar bar");
        row.addDate(11, new Date(0L));
        row.addBoolean(12, true);
        row.addFloat(13, 7.8f);
        row.addDouble(14, 9.9);
        session.apply((Operation)insert);
        session.close();
        KuduScanner scanner = this.client.newScannerBuilder(table).build();
        while (scanner.hasMoreRows()) {
            RowResultIterator it = scanner.nextRows();
            Assert.assertTrue((boolean)it.hasNext());
            RowResult rr = it.next();
            Assert.assertEquals((long)1L, (long)rr.getByte(0));
            Assert.assertEquals((long)2L, (long)rr.getShort(1));
            Assert.assertEquals((long)3L, (long)rr.getInt(2));
            Assert.assertEquals((long)4L, (long)rr.getLong(3));
            TestKeyEncoding.assertBytesEquals(rr.getBinaryCopy(4), "foo");
            TestKeyEncoding.assertBytesEquals(rr.getBinaryCopy(5), "bar");
            Assert.assertEquals((long)6L, (long)rr.getLong(6));
            Assert.assertTrue((BigDecimal.valueOf(999999999L).compareTo(rr.getDecimal(7)) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((BigDecimal.valueOf(999999999999999999L).compareTo(rr.getDecimal(8)) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((new BigDecimal(DecimalUtil.MAX_UNSCALED_DECIMAL128).compareTo(rr.getDecimal(9)) == 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"varchar ba", (Object)rr.getVarchar(10));
            Assert.assertEquals((long)0L, (long)rr.getInt(11));
            Assert.assertTrue((boolean)rr.getBoolean(12));
            Assert.assertEquals((float)7.8f, (float)rr.getFloat(13), (float)0.001f);
            Assert.assertEquals((double)9.9, (double)rr.getDouble(14), (double)0.001);
        }
    }
}

