/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.ExternalConsistencyMode;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.apache.kudu.util.HybridTimeUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHybridTime {
    private static final Logger LOG = LoggerFactory.getLogger(TestHybridTime.class);
    private static final String TABLE_NAME = TestHybridTime.class.getName() + "-" + System.currentTimeMillis();
    private static final Schema schema = TestHybridTime.getSchema();
    private KuduTable table;
    private KuduClient client;
    private static final MiniKuduCluster.MiniKuduClusterBuilder clusterBuilder = KuduTestHarness.getBaseClusterBuilder();
    @Rule
    public KuduTestHarness harness = new KuduTestHarness(clusterBuilder);

    @Before
    public void setUp() throws Exception {
        this.client = this.harness.getClient();
        CreateTableOptions builder = new CreateTableOptions().setRangePartitionColumns((List)ImmutableList.of((Object)"key"));
        this.table = this.client.createTable(TABLE_NAME, schema, builder);
    }

    private static Schema getSchema() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(1);
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key", Type.STRING).key(true).build());
        return new Schema(columns);
    }

    @Test(timeout=100000L)
    public void test() throws Exception {
        int i;
        KuduSession session = this.client.newSession();
        session.setExternalConsistencyMode(ExternalConsistencyMode.CLIENT_PROPAGATED);
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC);
        ArrayList<Long> logicalValues = new ArrayList<Long>();
        this.insertRow(session, "0");
        Assert.assertTrue((boolean)this.client.hasLastPropagatedTimestamp());
        long[] clockValues = HybridTimeUtil.HTTimestampToPhysicalAndLogical((long)this.client.getLastPropagatedTimestamp());
        Assert.assertEquals((long)clockValues[1], (long)0L);
        long futureTs = clockValues[0] + 5000000L;
        this.client.updateLastPropagatedTimestamp(HybridTimeUtil.clockTimestampToHTTimestamp((long)futureTs, (TimeUnit)TimeUnit.MICROSECONDS));
        String[] keys = new String[]{"1", "2", "3", "11", "22", "33"};
        for (i = 0; i < keys.length; ++i) {
            if (i == keys.length / 2) {
                session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
            }
            this.insertRow(session, keys[i]);
            Assert.assertTrue((boolean)this.client.hasLastPropagatedTimestamp());
            clockValues = HybridTimeUtil.HTTimestampToPhysicalAndLogical((long)this.client.getLastPropagatedTimestamp());
            LOG.debug("Clock value after write[%d]: %s Logical value: %d", new Object[]{i, new Date(clockValues[0] / 1000L).toString(), clockValues[1]});
            Assert.assertEquals((long)clockValues[0], (long)futureTs);
            logicalValues.add(clockValues[1]);
            Assert.assertTrue((boolean)Ordering.natural().isOrdered(logicalValues));
        }
        Assert.assertEquals((long)(1 + keys.length), (long)ClientTestUtil.countRowsInScan((KuduScanner)this.client.newScannerBuilder(this.table).build()));
        for (i = 0; i < logicalValues.size(); ++i) {
            long logicalValue = (Long)logicalValues.get(i);
            long snapshotTime = HybridTimeUtil.physicalAndLogicalToHTTimestamp((long)futureTs, (long)((Long)logicalValues.get(i)));
            int expected = i + 1;
            Assert.assertEquals((String)String.format("wrong number of rows for write %d at logical timestamp %d", i, logicalValue), (long)expected, (long)this.scanAtSnapshot(snapshotTime));
        }
        long latestLogicalValue = (Long)logicalValues.get(logicalValues.size() - 1);
        this.client.updateLastPropagatedTimestamp(this.client.getLastPropagatedTimestamp() + 1L);
        long snapshotTime = HybridTimeUtil.physicalAndLogicalToHTTimestamp((long)futureTs, (long)(latestLogicalValue + 1L));
        Assert.assertEquals((long)(1 + keys.length), (long)this.scanAtSnapshot(snapshotTime));
    }

    private int scanAtSnapshot(long time) throws Exception {
        AsyncKuduScanner.AsyncKuduScannerBuilder builder = (AsyncKuduScanner.AsyncKuduScannerBuilder)((AsyncKuduScanner.AsyncKuduScannerBuilder)this.harness.getAsyncClient().newScannerBuilder(this.table).snapshotTimestampRaw(time)).readMode(AsyncKuduScanner.ReadMode.READ_AT_SNAPSHOT);
        return ClientTestUtil.countRowsInScan((AsyncKuduScanner)builder.build());
    }

    private void insertRow(KuduSession session, String key) throws KuduException {
        Insert insert = this.table.newInsert();
        PartialRow row = insert.getRow();
        row.addString(0, key);
        session.apply((Operation)insert);
        session.flush();
    }
}

