/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.HiveMetastoreConfig;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestHiveMetastoreIntegration {
    @Rule
    public KuduTestHarness harness = new KuduTestHarness(KuduTestHarness.getBaseClusterBuilder().enableHiveMetastoreIntegration());
    private KuduClient client;

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
    }

    @Test(timeout=100000L)
    public void testOverrideTableOwner() throws Exception {
        String tableName = "default.testOverrideTableOwner";
        String owner = "alice";
        CreateTableOptions options = ClientTestUtil.getBasicCreateTableOptions();
        options.setOwner(owner);
        this.client.createTable(tableName, ClientTestUtil.getBasicSchema(), options);
        HiveMetastoreConfig hmsConfig = this.client.getHiveMetastoreConfig();
        HiveConf hiveConf = new HiveConf();
        hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, hmsConfig.getHiveMetastoreUris());
        hiveConf.setBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL, hmsConfig.getHiveMetastoreSaslEnabled());
        HiveMetaStoreClient hmsClient = new HiveMetaStoreClient(hiveConf);
        Assert.assertEquals((Object)owner, (Object)hmsClient.getTable("default", "testOverrideTableOwner").getOwner());
        this.client.alterTable(tableName, new AlterTableOptions().renameTable("default.testOverrideTableOwner_renamed"));
        Assert.assertEquals((Object)owner, (Object)hmsClient.getTable("default", "testOverrideTableOwner_renamed").getOwner());
    }
}

