/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduScanToken;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.TestKuduClient;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFlexiblePartitioning {
    private static final Logger LOG = LoggerFactory.getLogger(TestKuduClient.class);
    private String tableName;
    private KuduClient client;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
        this.tableName = TestFlexiblePartitioning.class.getName() + "-" + System.currentTimeMillis();
    }

    private static Schema createSchema() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(3);
        columns.add(new ColumnSchema.ColumnSchemaBuilder("a", Type.STRING).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("b", Type.STRING).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c", Type.STRING).key(true).build());
        return new Schema(columns);
    }

    private static Set<Row> rows() throws KuduException {
        HashSet<Row> rows = new HashSet<Row>();
        for (int a = 0; a < 6; ++a) {
            for (int b = 0; b < 6; ++b) {
                for (int c = 0; c < 6; ++c) {
                    rows.add(new Row(String.format("%s", a), String.format("%s", b), String.format("%s", c)));
                }
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRows(KuduTable table, Set<Row> rows) throws KuduException {
        try (KuduSession session = this.client.newSession();){
            for (Row row : rows) {
                Insert insert = table.newInsert();
                PartialRow insertRow = insert.getRow();
                row.fillPartialRow(insertRow);
                session.apply((Operation)insert);
            }
        }
    }

    private Set<Row> collectRows(KuduScanner scanner) throws KuduException {
        HashSet<Row> rows = new HashSet<Row>();
        for (RowResult result : scanner) {
            rows.add(Row.fromResult(result));
        }
        return rows;
    }

    private Set<Row> collectRows(KuduScanToken.KuduScanTokenBuilder scanTokens) throws Exception {
        HashSet<Row> rows = new HashSet<Row>();
        for (KuduScanToken token : scanTokens.build()) {
            LOG.debug("Scanning token: {}", (Object)KuduScanToken.stringifySerializedToken((byte[])token.serialize(), (KuduClient)this.client));
            int existingCount = rows.size();
            Set<Row> newRows = this.collectRows(token.intoScanner(this.client));
            rows.addAll(newRows);
            Assert.assertEquals((long)(existingCount + newRows.size()), (long)rows.size());
        }
        return rows;
    }

    private void testPartitionSchema(CreateTableOptions tableBuilder) throws Exception {
        Schema schema = TestFlexiblePartitioning.createSchema();
        this.client.createTable(this.tableName, schema, tableBuilder);
        KuduTable table = this.client.openTable(this.tableName);
        Set<Row> rows = TestFlexiblePartitioning.rows();
        this.insertRows(table, rows);
        Assert.assertEquals(rows, this.collectRows(this.client.newScannerBuilder(table).build()));
        Row minRow = new Row("1", "3", "5");
        PartialRow lowerBound = schema.newPartialRow();
        minRow.fillPartialRow(lowerBound);
        Set expected = Sets.filter(rows, arg_0 -> minRow.gtePred().apply(arg_0));
        KuduScanner scanner = ((KuduScanner.KuduScannerBuilder)this.client.newScannerBuilder(table).lowerBound(lowerBound)).build();
        Set<Row> results = this.collectRows(scanner);
        Assert.assertEquals((Object)expected, results);
        KuduScanToken.KuduScanTokenBuilder scanTokens = (KuduScanToken.KuduScanTokenBuilder)this.client.newScanTokenBuilder(table).lowerBound(lowerBound);
        Set<Row> tokenResults = this.collectRows(scanTokens);
        Assert.assertEquals((Object)expected, tokenResults);
        Row maxRow = new Row("1", "3", "5");
        PartialRow upperBound = schema.newPartialRow();
        maxRow.fillPartialRow(upperBound);
        expected = Sets.filter(rows, maxRow.ltPred());
        scanner = ((KuduScanner.KuduScannerBuilder)this.client.newScannerBuilder(table).exclusiveUpperBound(upperBound)).build();
        results = this.collectRows(scanner);
        Assert.assertEquals((Object)expected, results);
        scanTokens = (KuduScanToken.KuduScanTokenBuilder)this.client.newScanTokenBuilder(table).exclusiveUpperBound(upperBound);
        tokenResults = this.collectRows(scanTokens);
        Assert.assertEquals((Object)expected, tokenResults);
        minRow = new Row("1", "3", "5");
        Row maxRow2 = new Row("2", "4", "");
        PartialRow lowerBound2 = schema.newPartialRow();
        minRow.fillPartialRow(lowerBound2);
        PartialRow upperBound2 = schema.newPartialRow();
        maxRow2.fillPartialRow(upperBound2);
        Set expected2 = Sets.filter(rows, (Predicate)Predicates.and(arg_0 -> minRow.gtePred().apply(arg_0), maxRow2.ltPred()));
        KuduScanner scanner2 = ((KuduScanner.KuduScannerBuilder)((KuduScanner.KuduScannerBuilder)this.client.newScannerBuilder(table).lowerBound(lowerBound2)).exclusiveUpperBound(upperBound2)).build();
        Set<Row> results2 = this.collectRows(scanner2);
        Assert.assertEquals((Object)expected2, results2);
        KuduScanToken.KuduScanTokenBuilder scanTokens2 = (KuduScanToken.KuduScanTokenBuilder)((KuduScanToken.KuduScanTokenBuilder)this.client.newScanTokenBuilder(table).lowerBound(lowerBound2)).exclusiveUpperBound(upperBound2);
        Set<Row> tokenResults2 = this.collectRows(scanTokens2);
        Assert.assertEquals((Object)expected2, tokenResults2);
        List tablets = table.getTabletsLocations(50000L);
        HashSet<Row> results3 = new HashSet<Row>();
        for (LocatedTablet tablet : tablets) {
            KuduScanner scanner3 = ((KuduScanner.KuduScannerBuilder)((KuduScanner.KuduScannerBuilder)this.client.newScannerBuilder(table).lowerBoundPartitionKeyRaw(tablet.getPartition().getPartitionKeyStart())).exclusiveUpperBoundPartitionKeyRaw(tablet.getPartition().getPartitionKeyEnd())).build();
            Set<Row> tabletResults = this.collectRows(scanner3);
            Sets.SetView intersection = Sets.intersection(results3, tabletResults);
            Assert.assertEquals(new HashSet(), (Object)intersection);
            results3.addAll(tabletResults);
        }
        Assert.assertEquals(rows, results3);
        Row minRow2 = new Row("1", "3", "5");
        Row maxRow3 = new Row("2", "4", "");
        PartialRow lowerBound3 = schema.newPartialRow();
        minRow2.fillPartialRow(lowerBound3);
        PartialRow upperBound3 = schema.newPartialRow();
        maxRow3.fillPartialRow(upperBound3);
        Set expected3 = Sets.filter(rows, (Predicate)Predicates.and(arg_0 -> minRow2.gtePred().apply(arg_0), maxRow3.ltPred()));
        results2 = new HashSet<Row>();
        for (LocatedTablet tablet : tablets) {
            KuduScanner scanner4 = ((KuduScanner.KuduScannerBuilder)((KuduScanner.KuduScannerBuilder)((KuduScanner.KuduScannerBuilder)((KuduScanner.KuduScannerBuilder)this.client.newScannerBuilder(table).lowerBound(lowerBound3)).exclusiveUpperBound(upperBound3)).lowerBoundPartitionKeyRaw(tablet.getPartition().getPartitionKeyStart())).exclusiveUpperBoundPartitionKeyRaw(tablet.getPartition().getPartitionKeyEnd())).build();
            Set<Row> tabletResults = this.collectRows(scanner4);
            Sets.SetView intersection = Sets.intersection(results2, tabletResults);
            Assert.assertEquals(new HashSet(), (Object)intersection);
            results2.addAll(tabletResults);
        }
        Assert.assertEquals((Object)expected3, results2);
    }

    @Test(timeout=100000L)
    public void testHashBucketedTable() throws Exception {
        CreateTableOptions tableBuilder = new CreateTableOptions();
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"a"), 3);
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"b", (Object)"c"), 3, 42);
        tableBuilder.setRangePartitionColumns((List)ImmutableList.of());
        this.testPartitionSchema(tableBuilder);
    }

    @Test(timeout=100000L)
    public void testNonDefaultRangePartitionedTable() throws Exception {
        Schema schema = TestFlexiblePartitioning.createSchema();
        CreateTableOptions tableBuilder = new CreateTableOptions();
        tableBuilder.setRangePartitionColumns((List)ImmutableList.of((Object)"c", (Object)"b"));
        PartialRow split = schema.newPartialRow();
        split.addString("c", "3");
        tableBuilder.addSplitRow(split);
        split = schema.newPartialRow();
        split.addString("c", "3");
        split.addString("b", "3");
        tableBuilder.addSplitRow(split);
        this.testPartitionSchema(tableBuilder);
    }

    @Test(timeout=100000L)
    public void testHashBucketedAndRangePartitionedTable() throws Exception {
        Schema schema = TestFlexiblePartitioning.createSchema();
        CreateTableOptions tableBuilder = new CreateTableOptions();
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"a"), 3);
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"b", (Object)"c"), 3, 42);
        tableBuilder.setRangePartitionColumns((List)ImmutableList.of((Object)"c", (Object)"b"));
        PartialRow split = schema.newPartialRow();
        split.addString("c", "3");
        tableBuilder.addSplitRow(split);
        split = schema.newPartialRow();
        split.addString("c", "3");
        split.addString("b", "3");
        tableBuilder.addSplitRow(split);
        this.testPartitionSchema(tableBuilder);
    }

    @Test(timeout=100000L)
    public void testNonCoveredRangePartitionedTable() throws Exception {
        Schema schema = TestFlexiblePartitioning.createSchema();
        CreateTableOptions tableBuilder = new CreateTableOptions();
        tableBuilder.setRangePartitionColumns((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        PartialRow lowerBoundA = schema.newPartialRow();
        lowerBoundA.addString("a", "0");
        lowerBoundA.addString("b", "0");
        lowerBoundA.addString("c", "0");
        PartialRow upperBoundA = schema.newPartialRow();
        upperBoundA.addString("a", "3");
        upperBoundA.addString("b", "5");
        upperBoundA.addString("b", "6");
        tableBuilder.addRangePartition(lowerBoundA, upperBoundA);
        PartialRow lowerBoundB = schema.newPartialRow();
        lowerBoundB.addString("a", "4");
        lowerBoundB.addString("b", "0");
        lowerBoundB.addString("c", "0");
        PartialRow upperBoundB = schema.newPartialRow();
        upperBoundB.addString("a", "5");
        upperBoundB.addString("b", "5");
        upperBoundB.addString("b", "6");
        tableBuilder.addRangePartition(lowerBoundB, upperBoundB);
        this.testPartitionSchema(tableBuilder);
    }

    @Test(timeout=100000L)
    public void testHashBucketedAndNonCoveredRangePartitionedTable() throws Exception {
        Schema schema = TestFlexiblePartitioning.createSchema();
        CreateTableOptions tableBuilder = new CreateTableOptions();
        tableBuilder.setRangePartitionColumns((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        PartialRow lowerBoundA = schema.newPartialRow();
        lowerBoundA.addString("a", "0");
        lowerBoundA.addString("b", "0");
        lowerBoundA.addString("c", "0");
        PartialRow upperBoundA = schema.newPartialRow();
        upperBoundA.addString("a", "3");
        upperBoundA.addString("b", "5");
        upperBoundA.addString("c", "6");
        tableBuilder.addRangePartition(lowerBoundA, upperBoundA);
        PartialRow lowerBoundB = schema.newPartialRow();
        lowerBoundB.addString("a", "4");
        lowerBoundB.addString("b", "0");
        lowerBoundB.addString("c", "0");
        PartialRow upperBoundB = schema.newPartialRow();
        upperBoundB.addString("a", "5");
        upperBoundB.addString("b", "5");
        upperBoundB.addString("c", "6");
        tableBuilder.addRangePartition(lowerBoundB, upperBoundB);
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), 4);
        this.testPartitionSchema(tableBuilder);
    }

    @Test(timeout=100000L)
    public void testSimplePartitionedTable() throws Exception {
        Schema schema = TestFlexiblePartitioning.createSchema();
        CreateTableOptions tableBuilder = new CreateTableOptions().setRangePartitionColumns((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        PartialRow split = schema.newPartialRow();
        split.addString("c", "3");
        tableBuilder.addSplitRow(split);
        split = schema.newPartialRow();
        split.addString("c", "3");
        split.addString("b", "3");
        tableBuilder.addSplitRow(split);
        this.testPartitionSchema(tableBuilder);
    }

    @Test(timeout=100000L)
    public void testUnpartitionedTable() throws Exception {
        CreateTableOptions tableBuilder = new CreateTableOptions().setRangePartitionColumns((List)ImmutableList.of());
        this.testPartitionSchema(tableBuilder);
    }

    public static class Row
    implements Comparable<Row> {
        private final String valA;
        private final String valB;
        private final String valC;

        public Row(String a, String b, String c) {
            this.valA = a;
            this.valB = b;
            this.valC = c;
        }

        public String getValA() {
            return this.valA;
        }

        public String getValB() {
            return this.valB;
        }

        public String getValC() {
            return this.valC;
        }

        public void fillPartialRow(PartialRow row) {
            row.addString("a", this.valA);
            row.addString("b", this.valB);
            row.addString("c", this.valC);
        }

        private static Row fromResult(RowResult result) {
            return new Row(result.getString("a"), result.getString("b"), result.getString("c"));
        }

        public Predicate<Row> gtePred() {
            return new Predicate<Row>(){

                public boolean apply(Row other) {
                    return other.compareTo(this) >= 0;
                }
            };
        }

        public Predicate<Row> ltPred() {
            return new Predicate<Row>(){

                public boolean apply(Row other) {
                    return other.compareTo(this) < 0;
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row row = (Row)o;
            return Objects.equals(this.valA, row.valA) && Objects.equals(this.valB, row.valB) && Objects.equals(this.valC, row.valC);
        }

        public int hashCode() {
            return Objects.hash(this.valA, this.valB, this.valC);
        }

        @Override
        public int compareTo(Row other) {
            return ComparisonChain.start().compare((Comparable)((Object)this.valA), (Comparable)((Object)other.valA)).compare((Comparable)((Object)this.valB), (Comparable)((Object)other.valB)).compare((Comparable)((Object)this.valC), (Comparable)((Object)other.valC)).result();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("a", (Object)this.valA).add("b", (Object)this.valB).add("c", (Object)this.valC).toString();
        }
    }
}

