/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Deferred;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.Connection;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.PingRequest;
import org.apache.kudu.client.RpcProxy;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.client.TimeoutTracker;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.util.NetUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestConnectionCache {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test(timeout=50000L)
    public void test() throws Exception {
        try (MiniKuduCluster cluster = new MiniKuduCluster.MiniKuduClusterBuilder().numMasterServers(3).build();
             AsyncKuduClient client = new AsyncKuduClient.AsyncKuduClientBuilder(cluster.getMasterAddressesAsString()).build();){
            client.getTablesList().join();
            HostAndPort masterHostPort = (HostAndPort)cluster.getMasterServers().get(0);
            ServerInfo firstMaster = new ServerInfo("fake-uuid", masterHostPort, NetUtil.getInetAddress((String)masterHostPort.getHost()), "");
            Assert.assertEquals((long)3L, (long)client.getConnectionListCopy().size());
            Assert.assertFalse((boolean)this.allConnectionsTerminated(client));
            RpcProxy proxy = client.newRpcProxy(firstMaster);
            proxy.getConnection().disconnect().awaitUninterruptibly();
            this.waitForConnectionToTerminate(proxy.getConnection());
            Assert.assertTrue((boolean)proxy.getConnection().isTerminated());
            Assert.assertFalse((boolean)this.allConnectionsTerminated(client));
            RpcProxy newHelper = client.newRpcProxy(firstMaster);
            Connection newConnection = newHelper.getConnection();
            Assert.assertNotNull((Object)newConnection);
            Assert.assertNotSame((Object)proxy.getConnection(), (Object)newConnection);
            Thread.sleep(500L);
            Assert.assertFalse((boolean)newConnection.isReady());
            this.pingConnection(newHelper);
            Assert.assertTrue((boolean)newConnection.isReady());
            for (Connection c : client.getConnectionListCopy()) {
                c.disconnect().awaitUninterruptibly();
                this.waitForConnectionToTerminate(c);
            }
            Assert.assertTrue((boolean)this.allConnectionsTerminated(client));
        }
    }

    private boolean allConnectionsTerminated(AsyncKuduClient client) {
        for (Connection c : client.getConnectionListCopy()) {
            if (c.isTerminated()) continue;
            return false;
        }
        return true;
    }

    private void waitForConnectionToTerminate(Connection c) throws InterruptedException {
        TimeoutTracker timeoutTracker = new TimeoutTracker();
        timeoutTracker.setTimeout(5000L);
        while (!c.isTerminated() && !timeoutTracker.timedOut()) {
            Thread.sleep(250L);
        }
    }

    private void pingConnection(RpcProxy proxy) throws Exception {
        PingRequest ping = PingRequest.makeMasterPingRequest();
        Deferred d = ping.getDeferred();
        proxy.sendRpc((KuduRpc)ping);
        d.join(10000L);
    }
}

