/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.stumbleupon.async.Callback;
import java.util.List;
import org.apache.kudu.client.ConnectToCluster;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.NoLeaderFoundException;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.RecoverableException;
import org.apache.kudu.client.Status;
import org.apache.kudu.consensus.Metadata;
import org.apache.kudu.master.Master;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.apache.kudu.test.junit.RetryRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestConnectToCluster {
    private static final ImmutableList<HostAndPort> MASTERS = ImmutableList.of((Object)new HostAndPort("0", 9000), (Object)new HostAndPort("1", 9000), (Object)new HostAndPort("2", 9000));
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test(timeout=60000L)
    public void testFallbackConnectRpc() throws Exception {
        try (MiniKuduCluster cluster = new MiniKuduCluster.MiniKuduClusterBuilder().addMasterServerFlag("--master_support_connect_to_master_rpc=0").numMasterServers(1).numTabletServers(0).build();
             KuduClient c = new KuduClient.KuduClientBuilder(cluster.getMasterAddressesAsString()).build();){
            c.listTabletServers();
        }
    }

    @Test(timeout=60000L)
    public void testConnectToOneOfManyMasters() throws Exception {
        int successes = 0;
        try (MiniKuduCluster cluster = new MiniKuduCluster.MiniKuduClusterBuilder().numMasterServers(3).numTabletServers(0).build();){
            String[] masterAddrs = cluster.getMasterAddressesAsString().split(",", -1);
            Assert.assertEquals((long)3L, (long)masterAddrs.length);
            for (String masterAddr : masterAddrs) {
                try (KuduClient c = new KuduClient.KuduClientBuilder(masterAddr).build();){
                    c.listTabletServers();
                    ++successes;
                }
                catch (Exception e) {
                    Assert.assertTrue((String)("unexpected exception: " + e.toString()), (boolean)e.toString().matches(".*Client configured with 1 master\\(s\\) \\(.+?\\) but cluster indicates it expects 3 master\\(s\\) \\(.+?,.+?,.+?\\).*"));
                    Assert.assertThat((Object)Joiner.on((String)"\n").join((Object[])e.getStackTrace()), (Matcher)CoreMatchers.containsString((String)"testConnectToOneOfManyMasters"));
                }
            }
        }
        Assert.assertTrue((successes <= 1 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testAggregateResponses() throws Exception {
        NonRecoverableException reusableNRE = new NonRecoverableException(Status.RuntimeError((String)""));
        RecoverableException reusableRE = new RecoverableException(Status.RuntimeError((String)""));
        NoLeaderFoundException retryResponse = new NoLeaderFoundException(Status.RuntimeError((String)""));
        Object successResponse = new Object();
        this.runTest(TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.LEADER, MASTERS), TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), successResponse);
        this.runTest(TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.LEADER, MASTERS), TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), successResponse);
        this.runTest(TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.LEADER, MASTERS), TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.LEADER, MASTERS), TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), successResponse);
        this.runTest((Object)reusableNRE, TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.LEADER, MASTERS), successResponse);
        this.runTest((Object)reusableNRE, (Object)reusableNRE, TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.LEADER, MASTERS), successResponse);
        this.runTest((Object)reusableNRE, TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.LEADER, MASTERS), (Object)reusableNRE, successResponse);
        this.runTest((Object)reusableNRE, (Object)reusableNRE, TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.LEADER, (List<HostAndPort>)ImmutableList.of((Object)((HostAndPort)MASTERS.get(0)))), successResponse);
        this.runTest(TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), (Object)retryResponse);
        this.runTest(TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), (Object)reusableNRE, (Object)retryResponse);
        this.runTest((Object)reusableNRE, TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), (Object)reusableNRE, (Object)retryResponse);
        this.runTest(reusableRE, (Object)reusableNRE, TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, MASTERS), (Object)retryResponse);
        this.runTest(reusableRE, reusableRE, reusableRE, (Object)retryResponse);
        this.runTest(reusableRE, (Object)reusableNRE, (Object)reusableNRE, (Object)retryResponse);
        this.runTest((Object)reusableNRE, (Object)reusableNRE, TestConnectToCluster.makeCTMR(Metadata.RaftPeerPB.Role.FOLLOWER, (List<HostAndPort>)ImmutableList.of((Object)((HostAndPort)MASTERS.get(0)))), (Object)retryResponse);
        this.runTest((Object)reusableNRE, (Object)reusableNRE, (Object)reusableNRE, (Object)reusableNRE);
    }

    private void runTest(Object response0, Object response1, Object response2, Object expectedResponse) throws Exception {
        ConnectToCluster grrm = new ConnectToCluster(MASTERS);
        grrm.setNumMasters(MASTERS.size());
        Callback cb0 = grrm.callbackForNode((HostAndPort)MASTERS.get(0));
        Callback cb1 = grrm.callbackForNode((HostAndPort)MASTERS.get(1));
        Callback cb2 = grrm.callbackForNode((HostAndPort)MASTERS.get(2));
        Callback eb0 = grrm.errbackForNode((HostAndPort)MASTERS.get(0));
        Callback eb1 = grrm.errbackForNode((HostAndPort)MASTERS.get(1));
        Callback eb2 = grrm.errbackForNode((HostAndPort)MASTERS.get(2));
        TestConnectToCluster.callTheRightCallback((Callback<Void, Master.ConnectToMasterResponsePB>)cb0, (Callback<Void, Exception>)eb0, response0);
        TestConnectToCluster.callTheRightCallback((Callback<Void, Master.ConnectToMasterResponsePB>)cb1, (Callback<Void, Exception>)eb1, response1);
        TestConnectToCluster.callTheRightCallback((Callback<Void, Master.ConnectToMasterResponsePB>)cb2, (Callback<Void, Exception>)eb2, response2);
        try {
            grrm.getDeferred().join();
            if (expectedResponse instanceof Exception) {
                Assert.fail((String)("Should not work " + expectedResponse.getClass()));
            }
        }
        catch (Exception ex) {
            Assert.assertEquals(expectedResponse.getClass(), ex.getClass());
        }
    }

    private static void callTheRightCallback(Callback<Void, Master.ConnectToMasterResponsePB> cb, Callback<Void, Exception> eb, Object response) throws Exception {
        if (response instanceof Exception) {
            eb.call((Object)((Exception)response));
        } else {
            cb.call((Object)((Master.ConnectToMasterResponsePB)response));
        }
    }

    private static Master.ConnectToMasterResponsePB makeCTMR(Metadata.RaftPeerPB.Role role, List<HostAndPort> masters) {
        Master.ConnectToMasterResponsePB.Builder b = Master.ConnectToMasterResponsePB.newBuilder();
        b.setRole(role);
        for (HostAndPort master : masters) {
            b.addMasterAddrs(ProtobufHelper.hostAndPortToPB((HostAndPort)master));
        }
        return b.build();
    }
}

