/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.kudu.Schema;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.Operation;
import org.apache.kudu.test.CapturingLogAppender;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.junit.AssertHelpers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestClientFailoverSupport {
    private static final Schema basicSchema = ClientTestUtil.getBasicSchema();
    private CapturingLogAppender cla = new CapturingLogAppender();
    private Closeable claAttach;
    private KuduClient client;
    private AsyncKuduClient asyncClient;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
        this.asyncClient = this.harness.getAsyncClient();
        this.claAttach = this.cla.attach();
    }

    @After
    public void checkLogs() throws IOException {
        this.claAttach.close();
        String log = this.cla.getAppendedText();
        Assert.assertFalse((String)"Log should not contain Netty internals", (boolean)log.contains("socket.nio.AbstractNioSelector"));
    }

    private void waitUntilRowCount(final KuduTable table, final int rowCount, long timeoutMs) throws Exception {
        AssertHelpers.assertEventuallyTrue((String)String.format("Read count should be %s", rowCount), (AssertHelpers.BooleanExpression)new AssertHelpers.BooleanExpression(){

            public boolean get() throws Exception {
                AsyncKuduScanner scanner = TestClientFailoverSupport.this.asyncClient.newScannerBuilder(table).build();
                int readCount = ClientTestUtil.countRowsInScan((AsyncKuduScanner)scanner);
                return readCount == rowCount;
            }
        }, (long)timeoutMs);
    }

    @Test(timeout=100000L)
    public void testRestartLeaderMaster() throws Exception {
        this.doTestMasterFailover(MasterFailureType.RESTART);
    }

    @Test(timeout=100000L)
    public void testKillLeaderMaster() throws Exception {
        this.doTestMasterFailover(MasterFailureType.KILL);
    }

    private void doTestMasterFailover(MasterFailureType failureType) throws Exception {
        String TABLE_NAME = TestClientFailoverSupport.class.getName() + "-" + (Object)((Object)failureType);
        this.client.createTable(TABLE_NAME, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        KuduTable table = this.client.openTable(TABLE_NAME);
        KuduSession session = this.client.newSession();
        int TOTAL_ROWS_TO_INSERT = 10;
        for (int i = 0; i < 10; ++i) {
            session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)i));
        }
        this.waitUntilRowCount(table, 10, 50000L);
        switch (failureType) {
            case KILL: {
                this.harness.killLeaderMasterServer();
                break;
            }
            case RESTART: {
                this.harness.restartLeaderMaster();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected failure type: " + (Object)((Object)failureType));
            }
        }
        List tablets = table.getTabletsLocations(50000L);
        Assert.assertEquals((long)1L, (long)tablets.size());
        this.harness.killTabletLeader((LocatedTablet)tablets.get(0));
        for (int i = 10; i < 20; ++i) {
            session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)i));
        }
        this.waitUntilRowCount(table, 20, 50000L);
        this.client.deleteTable(TABLE_NAME);
        Assert.assertFalse((boolean)this.client.tableExists(TABLE_NAME));
    }

    static enum MasterFailureType {
        RESTART,
        KILL;

    }
}

