/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.test.junit.RetryRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestBytes {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void test() {
        byte[] bytes = new byte[16];
        Bytes.setUnsignedByte((byte[])bytes, (short)1);
        Assert.assertTrue((boolean)Bytes.getBoolean((byte[])bytes));
        Bytes.setUnsignedByte((byte[])bytes, (short)0);
        Assert.assertFalse((boolean)Bytes.getBoolean((byte[])bytes));
        short smallUbyte = 120;
        Bytes.setUnsignedByte((byte[])bytes, (short)smallUbyte);
        Assert.assertEquals((long)smallUbyte, (long)Bytes.getUnsignedByte((byte[])bytes));
        short largeUbyte = 250;
        Bytes.setUnsignedByte((byte[])bytes, (short)largeUbyte);
        Assert.assertEquals((long)largeUbyte, (long)Bytes.getUnsignedByte((byte[])bytes));
        short nshort = -300;
        Bytes.setShort((byte[])bytes, (short)nshort);
        Assert.assertEquals((long)nshort, (long)Bytes.getShort((byte[])bytes));
        short pshort = 300;
        Bytes.setShort((byte[])bytes, (short)pshort);
        Assert.assertEquals((long)pshort, (long)Bytes.getShort((byte[])bytes));
        int smallUshort = 300;
        Bytes.setUnsignedShort((byte[])bytes, (int)smallUshort);
        Assert.assertEquals((long)smallUshort, (long)Bytes.getUnsignedShort((byte[])bytes));
        int largeUshort = 60000;
        Bytes.setUnsignedShort((byte[])bytes, (int)largeUshort);
        Assert.assertEquals((long)largeUshort, (long)Bytes.getUnsignedShort((byte[])bytes));
        int nint = -60000;
        Bytes.setInt((byte[])bytes, (int)nint);
        Assert.assertEquals((long)nint, (long)Bytes.getInt((byte[])bytes));
        int pint = 60000;
        Bytes.setInt((byte[])bytes, (int)pint);
        Assert.assertEquals((long)pint, (long)Bytes.getInt((byte[])bytes));
        long smallUint = 60000L;
        Bytes.setUnsignedInt((byte[])bytes, (long)smallUint);
        Assert.assertEquals((long)smallUint, (long)Bytes.getUnsignedInt((byte[])bytes));
        long largeUint = 4000000000L;
        Bytes.setUnsignedInt((byte[])bytes, (long)largeUint);
        Assert.assertEquals((long)largeUint, (long)Bytes.getUnsignedInt((byte[])bytes));
        long nlong = -4000000000L;
        Bytes.setLong((byte[])bytes, (long)nlong);
        Assert.assertEquals((long)nlong, (long)Bytes.getLong((byte[])bytes));
        long plong = 4000000000L;
        Bytes.setLong((byte[])bytes, (long)plong);
        Assert.assertEquals((long)plong, (long)Bytes.getLong((byte[])bytes));
        BigInteger smallUlong = new BigInteger("4000000000");
        Bytes.setUnsignedLong((byte[])bytes, (BigInteger)smallUlong);
        Assert.assertEquals((Object)smallUlong, (Object)Bytes.getUnsignedLong((byte[])bytes));
        BigInteger largeUlong = new BigInteger("10000000000000000000");
        Bytes.setUnsignedLong((byte[])bytes, (BigInteger)largeUlong);
        Assert.assertEquals((Object)largeUlong, (Object)Bytes.getUnsignedLong((byte[])bytes));
        float floatVal = 123.456f;
        Bytes.setFloat((byte[])bytes, (float)floatVal);
        Assert.assertEquals((double)floatVal, (double)Bytes.getFloat((byte[])bytes), (double)0.001);
        double doubleVal = 123.456;
        Bytes.setDouble((byte[])bytes, (double)doubleVal);
        Assert.assertEquals((double)doubleVal, (double)Bytes.getDouble((byte[])bytes), (double)0.001);
        BigDecimal smallDecimal = new BigDecimal(BigInteger.valueOf(123456789L), 0, new MathContext(9, RoundingMode.UNNECESSARY));
        Bytes.setBigDecimal((byte[])bytes, (BigDecimal)smallDecimal, (int)9);
        Assert.assertEquals((Object)smallDecimal, (Object)Bytes.getDecimal((byte[])bytes, (int)0, (int)9, (int)0));
        BigDecimal negSmallDecimal = new BigDecimal(BigInteger.valueOf(-123456789L), 0, new MathContext(9, RoundingMode.UNNECESSARY));
        Bytes.setBigDecimal((byte[])bytes, (BigDecimal)negSmallDecimal, (int)9);
        Assert.assertEquals((Object)negSmallDecimal, (Object)Bytes.getDecimal((byte[])bytes, (int)0, (int)9, (int)0));
        BigDecimal mediumDecimal = new BigDecimal(BigInteger.valueOf(123456789L), 0, new MathContext(18, RoundingMode.UNNECESSARY));
        Bytes.setBigDecimal((byte[])bytes, (BigDecimal)mediumDecimal, (int)18);
        Assert.assertEquals((Object)mediumDecimal, (Object)Bytes.getDecimal((byte[])bytes, (int)18, (int)0));
        BigDecimal negMediumDecimal = new BigDecimal(BigInteger.valueOf(-123456789L), 0, new MathContext(18, RoundingMode.UNNECESSARY));
        Bytes.setBigDecimal((byte[])bytes, (BigDecimal)negMediumDecimal, (int)18);
        Assert.assertEquals((Object)negMediumDecimal, (Object)Bytes.getDecimal((byte[])bytes, (int)18, (int)0));
        BigDecimal largeDecimal = new BigDecimal(new BigInteger("1234567891011121314151617181920212223"), 0, new MathContext(38, RoundingMode.UNNECESSARY));
        Bytes.setBigDecimal((byte[])bytes, (BigDecimal)largeDecimal, (int)38);
        Assert.assertEquals((Object)largeDecimal, (Object)Bytes.getDecimal((byte[])bytes, (int)38, (int)0));
        BigDecimal negLargeDecimal = new BigDecimal(new BigInteger("-1234567891011121314151617181920212223"), 0, new MathContext(38, RoundingMode.UNNECESSARY));
        Bytes.setBigDecimal((byte[])bytes, (BigDecimal)negLargeDecimal, (int)38);
        Assert.assertEquals((Object)negLargeDecimal, (Object)Bytes.getDecimal((byte[])bytes, (int)38, (int)0));
    }

    @Test
    public void testHex() {
        byte[] bytes = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        Assert.assertEquals((Object)"0x0123456789ABCDEF", (Object)Bytes.hex((byte[])bytes));
    }
}

