/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Random;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.util.BloomFilter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestBloomFilter {
    private int numBytes = 32768;
    private long randomSeed = System.currentTimeMillis();
    private int numKeys = 2000;
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testNumberOfHashes() {
        Assert.assertEquals((long)BloomFilter.byCountAndFPRate((int)10, (double)0.1).getNumHashes(), (long)3L);
        Assert.assertEquals((long)BloomFilter.byCountAndFPRate((int)100, (double)0.2).getNumHashes(), (long)2L);
        Assert.assertEquals((long)BloomFilter.byCountAndFPRate((int)1000, (double)0.05).getNumHashes(), (long)4L);
        Assert.assertEquals((long)BloomFilter.byCountAndFPRate((int)10000, (double)0.01).getNumHashes(), (long)6L);
        Assert.assertEquals((long)BloomFilter.bySizeAndFPRate((int)10, (double)0.1).getNumHashes(), (long)3L);
        Assert.assertEquals((long)BloomFilter.bySizeAndFPRate((int)1000, (double)0.2).getNumHashes(), (long)2L);
        Assert.assertEquals((long)BloomFilter.bySizeAndFPRate((int)100000, (double)0.05).getNumHashes(), (long)4L);
        Assert.assertEquals((long)BloomFilter.bySizeAndFPRate((int)10000000, (double)0.01).getNumHashes(), (long)6L);
    }

    @Test
    public void testIntGenBFBySize() {
        int i;
        BloomFilter bf = BloomFilter.bySize((int)this.numBytes);
        Random rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            bf.put(rand.nextInt());
        }
        rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            Assert.assertTrue((boolean)bf.mayContain(rand.nextInt()));
        }
    }

    @Test
    public void testIntGenBFByCount() {
        int i;
        BloomFilter bf = BloomFilter.byCount((int)this.numKeys);
        Random rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            bf.put(rand.nextInt());
        }
        rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            Assert.assertTrue((boolean)bf.mayContain(rand.nextInt()));
        }
    }

    @Test
    public void testBytes() {
        int i;
        BloomFilter bf = BloomFilter.bySize((int)this.numBytes);
        Random rand = new Random(this.randomSeed);
        byte[] bytes = new byte[64];
        for (i = 0; i < this.numKeys; ++i) {
            rand.nextBytes(bytes);
            bf.put(bytes);
        }
        rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            rand.nextBytes(bytes);
            Assert.assertTrue((boolean)bf.mayContain(bytes));
        }
    }

    @Test
    public void testBoolean() {
        int i;
        BloomFilter bf = BloomFilter.bySize((int)this.numBytes);
        Random rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            bf.put(rand.nextBoolean());
        }
        rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            Assert.assertTrue((boolean)bf.mayContain(rand.nextBoolean()));
        }
    }

    @Test
    public void testShort() {
        int i;
        BloomFilter bf = BloomFilter.bySize((int)this.numBytes);
        Random rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            bf.put((short)rand.nextInt());
        }
        rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            Assert.assertTrue((boolean)bf.mayContain((short)rand.nextInt()));
        }
    }

    @Test
    public void testLong() {
        int i;
        BloomFilter bf = BloomFilter.bySize((int)this.numBytes);
        Random rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            bf.put(rand.nextLong());
        }
        rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            Assert.assertTrue((boolean)bf.mayContain(rand.nextLong()));
        }
    }

    @Test
    public void testFloat() {
        int i;
        BloomFilter bf = BloomFilter.bySize((int)this.numBytes);
        Random rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            bf.put(rand.nextFloat());
        }
        rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            Assert.assertTrue((boolean)bf.mayContain(rand.nextFloat()));
        }
    }

    @Test
    public void testDouble() {
        int i;
        BloomFilter bf = BloomFilter.bySize((int)this.numBytes);
        Random rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            bf.put(rand.nextDouble());
        }
        rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            Assert.assertTrue((boolean)bf.mayContain(rand.nextDouble()));
        }
    }

    @Test
    public void testString() {
        int i;
        BloomFilter bf = BloomFilter.bySize((int)this.numBytes);
        Random rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            bf.put(rand.nextInt() + "");
        }
        rand = new Random(this.randomSeed);
        for (i = 0; i < this.numKeys; ++i) {
            Assert.assertTrue((boolean)bf.mayContain(rand.nextInt() + ""));
        }
    }
}

