/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.AuthzTokenCache;
import org.apache.kudu.client.InvalidAuthzTokenException;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Status;
import org.apache.kudu.security.Token;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAuthzTokenCache {
    private static final Logger LOG = LoggerFactory.getLogger(TestAuthzTokenCache.class);
    private static final MiniKuduCluster.MiniKuduClusterBuilder clusterBuilder = KuduTestHarness.getBaseClusterBuilder().enableKerberos();
    private static final String tableName = "TestAuthzTokenCache-table";
    private KuduClient client;
    private AsyncKuduClient asyncClient;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness(clusterBuilder);

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
        this.asyncClient = this.harness.getAsyncClient();
    }

    public void fetchAuthzToken(KuduTable table) throws Exception {
        AsyncKuduScanner scanner = new AsyncKuduScanner.AsyncKuduScannerBuilder(this.asyncClient, table).build();
        KuduRpc req = scanner.getOpenRequest();
        Deferred d = req.getDeferred();
        this.asyncClient.getAuthzTokenCache().retrieveAuthzToken(req, (KuduException)new InvalidAuthzTokenException(Status.IOError((String)"test failure")));
        Assert.assertNotNull((Object)d.join());
    }

    @Test
    public void testBasicAuthzTokenCache() throws Exception {
        KuduTable table = this.client.createTable(tableName, ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions());
        AuthzTokenCache tokenCache = this.asyncClient.getAuthzTokenCache();
        String tableId = table.getTableId();
        Token.SignedTokenPB originalToken = this.asyncClient.getAuthzToken(tableId);
        Assert.assertNotNull((Object)originalToken);
        Thread.sleep(1100L);
        this.fetchAuthzToken(table);
        Assert.assertFalse((boolean)this.asyncClient.getAuthzToken(tableId).equals((Object)originalToken));
        tokenCache.put(tableId, originalToken);
        Assert.assertTrue((boolean)this.asyncClient.getAuthzToken(tableId).equals((Object)originalToken));
    }

    @Test
    public void testRetrieveAuthzTokensInParallel() throws Exception {
        final KuduTable table = this.client.createTable(tableName, ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions());
        String tableId = table.getTableId();
        int NUM_THREADS = 30;
        class AuthzTokenFetcher
        implements Callable<Exception> {
            AuthzTokenFetcher() {
            }

            @Override
            public Exception call() {
                try {
                    TestAuthzTokenCache.this.fetchAuthzToken(table);
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        }
        ArrayList<AuthzTokenFetcher> fetchers = new ArrayList<AuthzTokenFetcher>();
        for (int i = 0; i < 30; ++i) {
            fetchers.add(new AuthzTokenFetcher());
        }
        int fails = 0;
        ExecutorService pool = Executors.newFixedThreadPool(30);
        List exceptions = pool.invokeAll(fetchers);
        pool.shutdown();
        for (int i = 0; i < 30; ++i) {
            Exception e = (Exception)exceptions.get(i).get();
            if (e == null) continue;
            ++fails;
            e.printStackTrace();
        }
        Assert.assertEquals((long)0L, (long)fails);
        Assert.assertNotNull((Object)this.asyncClient.getAuthzToken(tableId));
        int numRetrievals = this.asyncClient.getAuthzTokenCache().numRetrievalsSent();
        LOG.debug(String.format("Sent %d RPCs for %d threads", numRetrievals, 30));
        Assert.assertTrue((0 < numRetrievals ? 1 : 0) != 0);
        Assert.assertTrue((numRetrievals < 30 ? 1 : 0) != 0);
    }
}

