/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.base.Stopwatch;
import com.google.protobuf.ByteString;
import com.stumbleupon.async.Deferred;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Common;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.Connection;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.NoLeaderFoundException;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.RowResultIterator;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.consensus.Metadata;
import org.apache.kudu.master.Master;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.ProtobufUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestAsyncKuduClient {
    private static final Schema basicSchema = ClientTestUtil.getBasicSchema();
    private KuduClient client;
    private AsyncKuduClient asyncClient;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
        this.asyncClient = this.harness.getAsyncClient();
    }

    @Test(timeout=100000L)
    public void testDisconnect() throws Exception {
        CreateTableOptions options = ClientTestUtil.getBasicCreateTableOptions().setNumReplicas(1);
        KuduTable table = this.client.createTable("testDisconnect-" + System.currentTimeMillis(), basicSchema, options);
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInScan((KuduScanner)this.client.newScannerBuilder(table).build()));
        this.disconnectAndWait();
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInScan((KuduScanner)this.client.newScannerBuilder(table).build()));
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        int rowCount = 200;
        for (int i = 0; i < rowCount; ++i) {
            session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)i));
        }
        session.flush();
        AsyncKuduScanner scanner = ((AsyncKuduScanner.AsyncKuduScannerBuilder)this.asyncClient.newScannerBuilder(table).batchSizeBytes(1)).build();
        Deferred rri = scanner.nextRows();
        int numRows = ((RowResultIterator)rri.join(50000L)).getNumRows();
        Assert.assertNotEquals((String)"The TS sent all the rows back, we can't properly test disconnection", (long)rowCount, (long)numRows);
        this.disconnectAndWait();
        Assert.assertEquals((long)(rowCount - numRows), (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)scanner));
    }

    private void disconnectAndWait() throws InterruptedException {
        for (Connection c : this.asyncClient.getConnectionListCopy()) {
            c.disconnect();
        }
        Stopwatch sw = Stopwatch.createStarted();
        boolean disconnected = false;
        while (sw.elapsed(TimeUnit.MILLISECONDS) < 50000L) {
            boolean sleep = false;
            if (!this.asyncClient.getConnectionListCopy().isEmpty()) {
                for (Connection c : this.asyncClient.getConnectionListCopy()) {
                    if (c.isTerminated()) continue;
                    sleep = true;
                    break;
                }
            }
            if (sleep) {
                Thread.sleep(50L);
                continue;
            }
            disconnected = true;
            break;
        }
        Assert.assertTrue((boolean)disconnected);
    }

    @Test
    public void testBadHostnames() throws Exception {
        String badHostname = "some-unknown-host-hopefully";
        int requestBatchSize = 10;
        try (AsyncKuduClient invalidClient = new AsyncKuduClient.AsyncKuduClientBuilder(badHostname).build();){
            try {
                invalidClient.listTabletServers().join(1000L);
                Assert.fail((String)"This should have failed quickly");
            }
            catch (Exception ex) {
                Assert.assertTrue((boolean)(ex instanceof NonRecoverableException));
                Assert.assertTrue((boolean)ex.getMessage().contains(badHostname));
            }
        }
        ArrayList<Master.TabletLocationsPB> tabletLocations = new ArrayList<Master.TabletLocationsPB>();
        ArrayList<Master.TSInfoPB> tsInfos = new ArrayList<Master.TSInfoPB>();
        Master.TabletLocationsPB.Builder tabletPb = Master.TabletLocationsPB.newBuilder();
        for (int i = 0; i < 3; ++i) {
            Common.PartitionPB.Builder partition = Common.PartitionPB.newBuilder();
            partition.setPartitionKeyStart(ByteString.copyFrom((String)("a" + i), (String)StandardCharsets.UTF_8.name()));
            partition.setPartitionKeyEnd(ByteString.copyFrom((String)("b" + i), (String)StandardCharsets.UTF_8.name()));
            tabletPb.setPartition(partition);
            tabletPb.setTabletId(ByteString.copyFromUtf8((String)("some id " + i)));
            tabletPb.addInternedReplicas(ProtobufUtils.getFakeTabletInternedReplicaPB((int)i, (Metadata.RaftPeerPB.Role)Metadata.RaftPeerPB.Role.FOLLOWER));
            tabletLocations.add(tabletPb.build());
            tsInfos.add(ProtobufUtils.getFakeTSInfoPB((String)"uuid", (String)(badHostname + i), (int)i).build());
        }
        try {
            KuduTable badTable = new KuduTable(this.asyncClient, "Invalid table name", "Invalid table ID", null, null, 3, null);
            this.asyncClient.discoverTablets(badTable, null, 10, tabletLocations, tsInfos, 1000L);
            Assert.fail((String)"This should have failed quickly");
        }
        catch (NonRecoverableException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains(badHostname));
        }
    }

    @Test
    public void testNoLeader() throws Exception {
        int requestBatchSize = 10;
        CreateTableOptions options = ClientTestUtil.getBasicCreateTableOptions();
        KuduTable table = this.client.createTable("testNoLeader-" + System.currentTimeMillis(), basicSchema, options);
        List tablets = (List)this.asyncClient.locateTable(table, null, null, 10, 50000L).join(50000L);
        LocatedTablet tablet = (LocatedTablet)tablets.get(0);
        LocatedTablet.Replica leader = tablet.getLeaderReplica();
        ArrayList<Master.TabletLocationsPB> tabletLocations = new ArrayList<Master.TabletLocationsPB>();
        ArrayList<Master.TSInfoPB> tsInfos = new ArrayList<Master.TSInfoPB>();
        Master.TabletLocationsPB.Builder tabletPb = Master.TabletLocationsPB.newBuilder();
        tabletPb.setPartition(ProtobufUtils.getFakePartitionPB());
        tabletPb.setTabletId(ByteString.copyFrom((byte[])tablet.getTabletId()));
        tabletPb.addInternedReplicas(ProtobufUtils.getFakeTabletInternedReplicaPB((int)0, (Metadata.RaftPeerPB.Role)Metadata.RaftPeerPB.Role.FOLLOWER));
        tabletLocations.add(tabletPb.build());
        tsInfos.add(ProtobufUtils.getFakeTSInfoPB((String)"master", (String)leader.getRpcHost(), (int)leader.getRpcPort()).build());
        try {
            this.asyncClient.discoverTablets(table, new byte[0], 10, tabletLocations, tsInfos, 1000L);
            Assert.fail((String)"discoverTablets should throw an exception if there's no leader");
        }
        catch (NoLeaderFoundException noLeaderFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testConnectionRefused() throws Exception {
        CreateTableOptions options = ClientTestUtil.getBasicCreateTableOptions();
        KuduTable table = this.client.createTable("testConnectionRefused-" + System.currentTimeMillis(), basicSchema, options);
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInScan((KuduScanner)this.client.newScannerBuilder(table).build()));
        this.harness.killAllTabletServers();
        KuduScanner scanner = ((KuduScanner.KuduScannerBuilder)this.client.newScannerBuilder(table).scanRequestTimeout(1000L)).build();
        try {
            while (scanner.hasMoreRows()) {
                scanner.nextRows();
                Assert.fail((String)"The scan should timeout");
            }
        }
        catch (NonRecoverableException ex) {
            Assert.assertTrue((boolean)ex.getStatus().isTimedOut());
        }
        KuduSession session = this.client.newSession();
        session.setTimeoutMillis(1000L);
        OperationResponse response = session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)1));
        Assert.assertTrue((boolean)response.hasRowError());
        Assert.assertTrue((boolean)response.getRowError().getErrorStatus().isTimedOut());
    }

    @Test(timeout=100000L)
    public void testCreateTableOutOfOrderPrimaryKeys() throws Exception {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(6);
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key_1", Type.INT8).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("column1_i", Type.INT32).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key_2", Type.INT16).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("column2_i", Type.INT32).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("column3_s", Type.STRING).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("column4_b", Type.BOOL).build());
        Schema schema = new Schema(columns);
        try {
            this.asyncClient.createTable("testCreateTableOutOfOrderPrimaryKeys-" + System.currentTimeMillis(), schema, ClientTestUtil.getBasicCreateTableOptions()).join();
            Assert.fail();
        }
        catch (NonRecoverableException nre) {
            Assert.assertTrue((boolean)nre.getMessage().startsWith("Got out-of-order key column"));
        }
    }
}

