/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RangePartitionBound;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.TestKuduClient;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.util.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class TestAlterTable {
    private String tableName;
    private KuduClient client;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
        this.tableName = TestKuduClient.class.getName() + "-" + System.currentTimeMillis();
    }

    private KuduTable createTable(List<Pair<Integer, Integer>> bounds) throws KuduException {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(1);
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c0", Type.INT32).nullable(false).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c1", Type.INT32).nullable(false).build());
        Schema schema = new Schema(columns);
        CreateTableOptions createOptions = new CreateTableOptions().setRangePartitionColumns((List)ImmutableList.of((Object)"c0")).setNumReplicas(1).addHashPartitions((List)ImmutableList.of((Object)"c0"), 2);
        for (Pair<Integer, Integer> bound : bounds) {
            PartialRow lower = schema.newPartialRow();
            PartialRow upper = schema.newPartialRow();
            lower.addInt("c0", ((Integer)bound.getFirst()).intValue());
            upper.addInt("c0", ((Integer)bound.getSecond()).intValue());
            createOptions.addRangePartition(lower, upper);
        }
        return this.client.createTable(this.tableName, schema, createOptions);
    }

    private void insertRows(KuduTable table, int start, int end) throws KuduException {
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        for (int i = start; i < end; ++i) {
            Insert insert = table.newInsert();
            for (int idx = 0; idx < table.getSchema().getColumnCount(); ++idx) {
                insert.getRow().addInt(idx, i);
            }
            session.apply((Operation)insert);
        }
        session.flush();
        Object[] rowErrors = session.getPendingErrors().getRowErrors();
        Assert.assertEquals((String)String.format("row errors: %s", Arrays.toString(rowErrors)), (long)0L, (long)rowErrors.length);
    }

    @Test
    public void testAlterAddColumns() throws Exception {
        KuduTable table = this.createTable((List<Pair<Integer, Integer>>)ImmutableList.of());
        this.insertRows(table, 0, 100);
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        this.client.alterTable(this.tableName, new AlterTableOptions().addColumn("addNonNull", Type.INT32, (Object)100).addNullableColumn("addNullable", Type.INT32).addNullableColumn("addNullableDef", Type.INT32, (Object)200));
        table = this.client.openTable(this.tableName);
        Assert.assertEquals((long)5L, (long)table.getSchema().getColumnCount());
        KuduSession session = this.client.newSession();
        Insert insert = table.newInsert();
        PartialRow row = insert.getRow();
        row.addInt("c0", 101);
        row.addInt("c1", 101);
        row.addInt("addNonNull", 101);
        row.addInt("addNullable", 101);
        row.setNull("addNullableDef");
        session.apply((Operation)insert);
        session.flush();
        Object[] rowErrors = session.getPendingErrors().getRowErrors();
        Assert.assertEquals((String)String.format("row errors: %s", Arrays.toString(rowErrors)), (long)0L, (long)rowErrors.length);
        List actual = ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
        ArrayList<String> expected = new ArrayList<String>(101);
        for (int i = 0; i < 100; ++i) {
            expected.add(i, String.format("INT32 c0=%d, INT32 c1=%d, INT32 addNonNull=100, INT32 addNullable=NULL, INT32 addNullableDef=200", i, i));
        }
        expected.add("INT32 c0=101, INT32 c1=101, INT32 addNonNull=101, INT32 addNullable=101, INT32 addNullableDef=NULL");
        Collections.sort(expected);
        Assert.assertArrayEquals((Object[])expected.toArray(new String[0]), (Object[])actual.toArray(new String[0]));
        NonRecoverableException thrown = (NonRecoverableException)Assert.assertThrows(NonRecoverableException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Exception {
                TestAlterTable.this.client.alterTable(TestAlterTable.this.tableName, new AlterTableOptions().addNullableColumn("addNullable", Type.INT32));
            }
        });
        Assert.assertTrue((boolean)thrown.getStatus().isAlreadyPresent());
        Assert.assertTrue((boolean)thrown.getMessage().contains("The column already exists"));
    }

    @Test
    public void testAlterModifyColumns() throws Exception {
        KuduTable table = this.createTable((List<Pair<Integer, Integer>>)ImmutableList.of());
        this.insertRows(table, 0, 100);
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        ColumnSchema col = (ColumnSchema)table.getSchema().getColumns().get(1);
        Assert.assertEquals((Object)ColumnSchema.CompressionAlgorithm.DEFAULT_COMPRESSION, (Object)col.getCompressionAlgorithm());
        Assert.assertEquals((Object)ColumnSchema.Encoding.AUTO_ENCODING, (Object)col.getEncoding());
        Assert.assertNull((Object)col.getDefaultValue());
        this.client.alterTable(this.tableName, new AlterTableOptions().changeCompressionAlgorithm(col.getName(), ColumnSchema.CompressionAlgorithm.SNAPPY).changeEncoding(col.getName(), ColumnSchema.Encoding.RLE).changeDefault(col.getName(), (Object)0));
        table = this.client.openTable(this.tableName);
        col = (ColumnSchema)table.getSchema().getColumns().get(1);
        Assert.assertEquals((Object)ColumnSchema.CompressionAlgorithm.SNAPPY, (Object)col.getCompressionAlgorithm());
        Assert.assertEquals((Object)ColumnSchema.Encoding.RLE, (Object)col.getEncoding());
        Assert.assertEquals((Object)0, (Object)col.getDefaultValue());
    }

    @Test
    public void testRenameKeyColumn() throws Exception {
        KuduTable table = this.createTable((List<Pair<Integer, Integer>>)ImmutableList.of());
        this.insertRows(table, 0, 100);
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        this.client.alterTable(this.tableName, new AlterTableOptions().renameColumn("c0", "c0Key"));
        try {
            KuduScanner scanner = ((KuduScanner.KuduScannerBuilder)this.client.newScannerBuilder(table).setProjectedColumnNames((List)Lists.newArrayList((Object[])new String[]{"c0", "c1"}))).build();
            while (scanner.hasMoreRows()) {
                scanner.nextRows();
            }
            Assert.fail();
        }
        catch (KuduException e) {
            Assert.assertTrue((boolean)e.getStatus().isInvalidArgument());
            Assert.assertTrue((boolean)e.getStatus().getMessage().contains("Some columns are not present in the current schema: c0"));
        }
        table = this.client.openTable(this.tableName);
        Assert.assertEquals((Object)"c0Key", (Object)((ColumnSchema)table.getSchema().getPrimaryKeyColumns().get(0)).getName());
        Assert.assertEquals((long)2L, (long)table.getSchema().getColumnCount());
        KuduSession session = this.client.newSession();
        Insert insert = table.newInsert();
        PartialRow row = insert.getRow();
        row.addInt("c0Key", 101);
        row.addInt("c1", 101);
        session.apply((Operation)insert);
        session.flush();
        Object[] rowErrors = session.getPendingErrors().getRowErrors();
        Assert.assertEquals((String)String.format("row errors: %s", Arrays.toString(rowErrors)), (long)0L, (long)rowErrors.length);
        KuduScanner scanner = ((KuduScanner.KuduScannerBuilder)this.client.newScannerBuilder(table).setProjectedColumnNames((List)Lists.newArrayList((Object[])new String[]{"c0Key", "c1"}))).build();
        while (scanner.hasMoreRows()) {
            RowResultIterator it = scanner.nextRows();
            Assert.assertTrue((boolean)it.hasNext());
            RowResult rr = it.next();
            Assert.assertEquals((long)rr.getInt(0), (long)rr.getInt(1));
        }
    }

    @Test
    public void testAlterRangePartitioning() throws Exception {
        KuduTable table = this.createTable((List<Pair<Integer, Integer>>)ImmutableList.of());
        Schema schema = table.getSchema();
        this.insertRows(table, 0, 100);
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        PartialRow lower = schema.newPartialRow();
        PartialRow upper = schema.newPartialRow();
        this.client.alterTable(this.tableName, new AlterTableOptions().dropRangePartition(lower, upper));
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        lower.addInt("c0", 0);
        upper.addInt("c0", 100);
        this.client.alterTable(this.tableName, new AlterTableOptions().addRangePartition(lower, upper));
        this.insertRows(table, 0, 100);
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        AlterTableOptions options = new AlterTableOptions();
        options.dropRangePartition(lower, upper);
        lower.addInt("c0", 50);
        upper.addInt("c0", 150);
        options.addRangePartition(lower, upper);
        this.client.alterTable(this.tableName, options);
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        this.insertRows(table, 50, 125);
        Assert.assertEquals((long)75L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        this.client.alterTable(this.tableName, new AlterTableOptions().dropRangePartition(lower, upper).addRangePartition(lower, upper));
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        this.insertRows(table, 50, 125);
        Assert.assertEquals((long)75L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        lower.addInt("c0", 200);
        upper.addInt("c0", 300);
        this.client.alterTable(this.tableName, new AlterTableOptions().addRangePartition(lower, upper).renameTable(this.tableName + "-renamed").addNullableColumn("c2", Type.INT32));
        this.tableName = this.tableName + "-renamed";
        this.insertRows(table, 200, 300);
        Assert.assertEquals((long)175L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        Assert.assertEquals((long)3L, (long)this.client.openTable(this.tableName).getSchema().getColumnCount());
        options = new AlterTableOptions();
        options.dropRangePartition(lower, upper);
        lower.addInt("c0", 50);
        upper.addInt("c0", 150);
        options.dropRangePartition(lower, upper);
        options.dropColumn("c2");
        this.client.alterTable(this.tableName, options);
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        Assert.assertEquals((long)2L, (long)this.client.openTable(this.tableName).getSchema().getColumnCount());
    }

    @Test
    public void testAlterRangePartitioningExclusiveInclusive() throws Exception {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(1);
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c0", Type.INT32).nullable(false).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c1", Type.INT32).nullable(false).build());
        Schema schema = new Schema(columns);
        CreateTableOptions createOptions = new CreateTableOptions().setRangePartitionColumns((List)ImmutableList.of((Object)"c0")).setNumReplicas(1);
        PartialRow lower = schema.newPartialRow();
        PartialRow upper = schema.newPartialRow();
        lower.addInt("c0", -1);
        upper.addInt("c0", 99);
        createOptions.addRangePartition(lower, upper, RangePartitionBound.EXCLUSIVE_BOUND, RangePartitionBound.INCLUSIVE_BOUND);
        KuduTable table = this.client.createTable(this.tableName, schema, createOptions);
        lower.addInt("c0", 199);
        upper.addInt("c0", 299);
        this.client.alterTable(this.tableName, new AlterTableOptions().addRangePartition(lower, upper, RangePartitionBound.EXCLUSIVE_BOUND, RangePartitionBound.INCLUSIVE_BOUND));
        this.insertRows(table, 0, 100);
        this.insertRows(table, 200, 300);
        Assert.assertEquals((long)200L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        AlterTableOptions alter = new AlterTableOptions();
        lower.addInt("c0", 0);
        upper.addInt("c0", 100);
        alter.dropRangePartition(lower, upper, RangePartitionBound.INCLUSIVE_BOUND, RangePartitionBound.EXCLUSIVE_BOUND);
        lower.addInt("c0", 199);
        upper.addInt("c0", 299);
        alter.dropRangePartition(lower, upper, RangePartitionBound.EXCLUSIVE_BOUND, RangePartitionBound.INCLUSIVE_BOUND);
        this.client.alterTable(this.tableName, alter);
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
    }

    @Test
    public void testAlterRangeParitioningInvalid() throws KuduException {
        KuduTable table = this.createTable((List<Pair<Integer, Integer>>)ImmutableList.of((Object)new Pair((Object)0, (Object)100)));
        Schema schema = table.getSchema();
        this.insertRows(table, 0, 100);
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        PartialRow lower = schema.newPartialRow();
        PartialRow upper = schema.newPartialRow();
        lower.addInt("c0", 0);
        upper.addInt("c0", 100);
        try {
            this.client.alterTable(this.tableName, new AlterTableOptions().addRangePartition(lower, upper));
            Assert.fail();
        }
        catch (KuduException e) {
            Assert.assertTrue((boolean)e.getStatus().isInvalidArgument());
            Assert.assertTrue((boolean)e.getStatus().getMessage().contains("New range partition conflicts with existing range partition"));
        }
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        lower.addInt("c0", 50);
        upper.addInt("c0", 150);
        try {
            this.client.alterTable(this.tableName, new AlterTableOptions().addRangePartition(lower, upper));
            Assert.fail();
        }
        catch (KuduException e) {
            Assert.assertTrue((boolean)e.getStatus().isInvalidArgument());
            Assert.assertTrue((boolean)e.getStatus().getMessage().contains("New range partition conflicts with existing range partition"));
        }
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        lower.addInt("c0", -50);
        upper.addInt("c0", 50);
        try {
            this.client.alterTable(this.tableName, new AlterTableOptions().addRangePartition(lower, upper));
            Assert.fail();
        }
        catch (KuduException e) {
            Assert.assertTrue((boolean)e.getStatus().isInvalidArgument());
            Assert.assertTrue((boolean)e.getStatus().getMessage().contains("New range partition conflicts with existing range partition"));
        }
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        lower.addInt("c0", 200);
        upper.addInt("c0", 300);
        AlterTableOptions options = new AlterTableOptions();
        options.addRangePartition(lower, upper);
        lower.addInt("c0", -50);
        upper.addInt("c0", 150);
        options.addRangePartition(lower, upper);
        try {
            this.client.alterTable(this.tableName, options);
            Assert.fail();
        }
        catch (KuduException e) {
            Assert.assertTrue((boolean)e.getStatus().isInvalidArgument());
            Assert.assertTrue((boolean)e.getStatus().getMessage().contains("New range partition conflicts with existing range partition"));
        }
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        try {
            this.client.alterTable(this.tableName, new AlterTableOptions().dropRangePartition(schema.newPartialRow(), schema.newPartialRow()));
            Assert.fail();
        }
        catch (KuduException e) {
            Assert.assertTrue((boolean)e.getStatus().isInvalidArgument());
            Assert.assertTrue((String)e.getStatus().getMessage(), (boolean)e.getStatus().getMessage().contains("No range partition found for drop range partition step"));
        }
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        lower.addInt("c0", 50);
        upper.addInt("c0", 150);
        try {
            this.client.alterTable(this.tableName, new AlterTableOptions().dropRangePartition(lower, upper).renameTable("foo"));
            Assert.fail();
        }
        catch (KuduException e) {
            Assert.assertTrue((boolean)e.getStatus().isInvalidArgument());
            Assert.assertTrue((boolean)e.getStatus().getMessage().contains("No range partition found for drop range partition step"));
        }
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        Assert.assertFalse((boolean)this.client.tableExists("foo"));
        options = new AlterTableOptions();
        lower.addInt("c0", 0);
        upper.addInt("c0", 100);
        options.dropRangePartition(lower, upper);
        lower.addInt("c0", 100);
        upper.addInt("c0", 200);
        options.addRangePartition(lower, upper);
        options.dropRangePartition(lower, upper);
        lower.addInt("c0", 150);
        upper.addInt("c0", 250);
        options.addRangePartition(lower, upper);
        lower.addInt("c0", 0);
        upper.addInt("c0", 10);
        options.dropRangePartition(lower, upper);
        try {
            this.client.alterTable(this.tableName, options);
            Assert.fail();
        }
        catch (KuduException e) {
            Assert.assertTrue((boolean)e.getStatus().isInvalidArgument());
            Assert.assertTrue((boolean)e.getStatus().getMessage().contains("No range partition found for drop range partition step"));
        }
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
    }

    @Test
    public void testAlterExtraConfigs() throws Exception {
        KuduTable table = this.createTable((List<Pair<Integer, Integer>>)ImmutableList.of());
        this.insertRows(table, 0, 100);
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        table = this.client.openTable(this.tableName);
        Map extraConfigs = table.getExtraConfig();
        Assert.assertFalse((boolean)extraConfigs.containsKey("kudu.table.history_max_age_sec"));
        HashMap<String, String> alterExtraConfigs = new HashMap<String, String>();
        alterExtraConfigs.put("kudu.table.history_max_age_sec", "3600");
        this.client.alterTable(this.tableName, new AlterTableOptions().alterExtraConfigs(alterExtraConfigs));
        table = this.client.openTable(this.tableName);
        extraConfigs = table.getExtraConfig();
        Assert.assertTrue((boolean)extraConfigs.containsKey("kudu.table.history_max_age_sec"));
        Assert.assertEquals((Object)"3600", extraConfigs.get("kudu.table.history_max_age_sec"));
        alterExtraConfigs = new HashMap();
        alterExtraConfigs.put("kudu.table.history_max_age_sec", "7200");
        this.client.alterTable(this.tableName, new AlterTableOptions().alterExtraConfigs(alterExtraConfigs));
        table = this.client.openTable(this.tableName);
        extraConfigs = table.getExtraConfig();
        Assert.assertTrue((boolean)extraConfigs.containsKey("kudu.table.history_max_age_sec"));
        Assert.assertEquals((Object)"7200", extraConfigs.get("kudu.table.history_max_age_sec"));
        alterExtraConfigs = new HashMap();
        alterExtraConfigs.put("kudu.table.history_max_age_sec", "");
        this.client.alterTable(this.tableName, new AlterTableOptions().alterExtraConfigs(alterExtraConfigs));
        table = this.client.openTable(this.tableName);
        Assert.assertTrue((boolean)table.getExtraConfig().isEmpty());
    }

    @Test
    @KuduTestHarness.MasterServerConfig(flags={"--max_num_columns=10"})
    public void testAlterExceedsColumnLimit() throws Exception {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        for (int i = 0; i < 10; ++i) {
            columns.add(new ColumnSchema.ColumnSchemaBuilder(Integer.toString(i), Type.INT32).key(i == 0).build());
        }
        Schema schema = new Schema(columns);
        CreateTableOptions createOptions = new CreateTableOptions().setRangePartitionColumns((List)ImmutableList.of((Object)"0"));
        this.client.createTable(this.tableName, schema, createOptions);
        NonRecoverableException thrown = (NonRecoverableException)Assert.assertThrows(NonRecoverableException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Exception {
                TestAlterTable.this.client.alterTable(TestAlterTable.this.tableName, new AlterTableOptions().addNullableColumn("11", Type.INT32));
            }
        });
        Assert.assertTrue((boolean)thrown.getStatus().isInvalidArgument());
        Assert.assertTrue((boolean)thrown.getMessage().contains("number of columns 11 is greater than the permitted maximum 10"));
    }
}

