/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import org.apache.kudu.Schema;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowResultIterator;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;

public class ITScannerMultiTablet {
    private static final String TABLE_NAME = ITScannerMultiTablet.class.getName() + "-" + System.currentTimeMillis();
    protected static final int ROW_COUNT = 20000;
    protected static final int TABLET_COUNT = 3;
    private static Schema schema = ClientTestUtil.getBasicSchema();
    protected KuduTable table;
    private static Random random = new Random(1234L);
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() throws Exception {
        CreateTableOptions builder = new CreateTableOptions();
        builder.addHashPartitions((List)Lists.newArrayList((Object[])new String[]{schema.getColumnByIndex(0).getName()}), 3);
        this.table = this.harness.getClient().createTable(TABLE_NAME, schema, builder);
        KuduSession session = this.harness.getClient().newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        char[] chars = new char[1024];
        for (int i = 0; i < 20000; ++i) {
            Insert insert = this.table.newInsert();
            PartialRow row = insert.getRow();
            row.addInt(0, random.nextInt());
            row.addInt(1, i);
            row.addInt(2, i);
            row.addString(3, new String(chars));
            row.addBoolean(4, true);
            session.apply((Operation)insert);
        }
        session.flush();
        Assert.assertEquals((long)0L, (long)session.countPendingErrors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serverFaultInjection(boolean restart, boolean isFaultTolerant, boolean finishFirstScan) throws Exception {
        try (KuduScanner scanner = ((KuduScanner.KuduScannerBuilder)((KuduScanner.KuduScannerBuilder)((KuduScanner.KuduScannerBuilder)this.harness.getClient().newScannerBuilder(this.table).setFaultTolerant(isFaultTolerant)).batchSizeBytes(1)).setProjectedColumnIndexes((List)Lists.newArrayList((Object[])new Integer[]{0}))).build();){
            int rowCount = 0;
            int previousRow = -1;
            int tableBoundariesCount = 0;
            if (scanner.hasMoreRows()) {
                RowResultIterator rri = scanner.nextRows();
                while (rri.hasNext()) {
                    int key = rri.next().getInt(0);
                    if (key < previousRow) {
                        ++tableBoundariesCount;
                    }
                    previousRow = key;
                    ++rowCount;
                }
            }
            if (!finishFirstScan) {
                if (restart) {
                    this.harness.restartTabletServer(scanner.currentTablet());
                } else {
                    this.harness.killTabletLeader(scanner.currentTablet());
                }
            }
            boolean failureInjected = false;
            while (scanner.hasMoreRows()) {
                RowResultIterator rri = scanner.nextRows();
                while (rri.hasNext()) {
                    int key = rri.next().getInt(0);
                    if (key < previousRow) {
                        ++tableBoundariesCount;
                        if (finishFirstScan && !failureInjected) {
                            if (restart) {
                                this.harness.restartTabletServer(scanner.currentTablet());
                            } else {
                                this.harness.killTabletLeader(scanner.currentTablet());
                            }
                            failureInjected = true;
                        }
                    }
                    previousRow = key;
                    ++rowCount;
                }
            }
            Assert.assertEquals((long)20000L, (long)rowCount);
            Assert.assertEquals((long)3L, (long)tableBoundariesCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clientFaultInjection(boolean isFaultTolerant) throws KuduException {
        try (KuduScanner scanner = ((KuduScanner.KuduScannerBuilder)((KuduScanner.KuduScannerBuilder)this.harness.getClient().newScannerBuilder(this.table).setFaultTolerant(isFaultTolerant)).batchSizeBytes(1)).build();){
            RowResultIterator rri;
            int rowCount = 0;
            int loopCount = 0;
            if (scanner.hasMoreRows()) {
                ++loopCount;
                rri = scanner.nextRows();
                rowCount += rri.getNumRows();
            }
            this.harness.getAsyncClient().newRpcProxy(scanner.currentTablet().getReplicaSelectedServerInfo(scanner.getReplicaSelection(), "")).getConnection().disconnect();
            while (scanner.hasMoreRows()) {
                ++loopCount;
                rri = scanner.nextRows();
                rowCount += rri.getNumRows();
            }
            Assert.assertTrue((loopCount > 3 ? 1 : 0) != 0);
            Assert.assertEquals((long)20000L, (long)rowCount);
        }
    }
}

