/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.ITScannerMultiTablet;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.RowResultIterator;
import org.junit.Assert;
import org.junit.Test;

public class ITNonFaultTolerantScanner
extends ITScannerMultiTablet {
    @Test(timeout=100000L)
    public void testKudu1343() throws Exception {
        KuduScanner scanner = ((KuduScanner.KuduScannerBuilder)this.harness.getClient().newScannerBuilder(this.table).batchSizeBytes(1)).build();
        int rowCount = 0;
        int loopCount = 0;
        while (scanner.hasMoreRows()) {
            ++loopCount;
            RowResultIterator rri = scanner.nextRows();
            rowCount += rri.getNumRows();
        }
        Assert.assertTrue((loopCount > 3 ? 1 : 0) != 0);
        Assert.assertEquals((long)20000L, (long)rowCount);
    }

    @Test(timeout=100000L)
    public void testNonFaultTolerantDisconnect() throws KuduException {
        this.clientFaultInjection(false);
    }

    @Test(timeout=100000L, expected=NonRecoverableException.class)
    public void testNonFaultTolerantScannerKill() throws Exception {
        this.serverFaultInjection(false, false, false);
    }

    @Test(timeout=100000L, expected=NonRecoverableException.class)
    public void testNonFaultTolerantScannerRestart() throws Exception {
        this.serverFaultInjection(true, false, false);
    }
}

