/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.Connection;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.ExternalConsistencyMode;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.TimeoutTracker;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.RandomUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITClient {
    private static final Logger LOG = LoggerFactory.getLogger(ITClient.class);
    private static final String RUNTIME_PROPERTY_NAME = "itclient.runtime.seconds";
    private static final long DEFAULT_RUNTIME_SECONDS = 60L;
    private static final long TEST_MIN_RUNTIME_SECONDS = 2L;
    private static final long TEST_TIMEOUT_SECONDS = 600000L;
    private static final String TABLE_NAME = ITClient.class.getName() + "-" + System.currentTimeMillis();
    private CountDownLatch keepRunningLatch;
    private Exception failureException;
    private KuduTable table;
    private long runtimeInSeconds;
    private volatile long sharedWriteTimestamp;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() throws Exception {
        this.keepRunningLatch = new CountDownLatch(1);
        this.failureException = null;
        this.sharedWriteTimestamp = 0L;
        String runtimeProp = System.getProperty(RUNTIME_PROPERTY_NAME);
        long l = this.runtimeInSeconds = runtimeProp == null ? 60L : Long.parseLong(runtimeProp);
        if (this.runtimeInSeconds < 2L || this.runtimeInSeconds > 600000L) {
            Assert.fail((String)"This test needs to run more than 2 seconds and less than 600000 seconds");
        }
        LOG.info("Test will run for {} seconds", (Object)this.runtimeInSeconds);
        CreateTableOptions builder = new CreateTableOptions().setNumReplicas(3);
        builder.setRangePartitionColumns((List)ImmutableList.of((Object)"key"));
        this.table = this.harness.getClient().createTable(TABLE_NAME, ClientTestUtil.getBasicSchema(), builder);
    }

    @Test(timeout=600000L)
    public void test() throws Exception {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        threads.add(new Thread((Runnable)new ChaosThread(), "chaos-test-thread"));
        threads.add(new Thread((Runnable)new WriterThread(), "writer-test-thread"));
        threads.add(new Thread((Runnable)new ScannerThread(), "scanner-test-thread"));
        for (Thread thread : threads) {
            thread.setUncaughtExceptionHandler(new UncaughtExceptionHandler());
            thread.start();
        }
        boolean failure = this.keepRunningLatch.await(this.runtimeInSeconds, TimeUnit.SECONDS);
        if (!failure) {
            this.keepRunningLatch.countDown();
        }
        for (Thread thread : threads) {
            thread.join(50000L);
        }
        if (failure) {
            throw this.failureException;
        }
        AsyncKuduScanner asyncKuduScanner = this.harness.getAsyncClient().newScannerBuilder(this.table).build();
        int rowCount = ClientTestUtil.countRowsInScan((AsyncKuduScanner)asyncKuduScanner);
        Assert.assertTrue((String)(rowCount + " should be higher than 0"), (rowCount > 0 ? 1 : 0) != 0);
    }

    private void reportError(String message, Exception exception) {
        this.failureException = new Exception(message, exception);
        this.keepRunningLatch.countDown();
    }

    private class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (ITClient.this.keepRunningLatch.getCount() != 0L) {
                ITClient.this.reportError("Uncaught exception", new Exception(e));
            }
        }
    }

    class ScannerThread
    implements Runnable {
        private final Random random = RandomUtils.getRandom();
        private int lastRowCount = 0;

        ScannerThread() {
        }

        @Override
        public void run() {
            while (ITClient.this.keepRunningLatch.getCount() > 0L) {
                boolean shouldContinue = ITClient.this.sharedWriteTimestamp == 0L ? true : (this.lastRowCount == 0 || this.random.nextBoolean() ? this.fullScan() : this.randomGet());
                if (!shouldContinue) {
                    return;
                }
                if (this.lastRowCount != 0) continue;
                try {
                    ITClient.this.keepRunningLatch.await(50L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        private boolean randomGet() {
            int key = this.random.nextInt(this.lastRowCount);
            KuduPredicate predicate = KuduPredicate.newComparisonPredicate((ColumnSchema)ITClient.this.table.getSchema().getColumnByIndex(0), (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)key);
            KuduScanner scanner = ((KuduScanner.KuduScannerBuilder)this.getScannerBuilder().addPredicate(predicate)).build();
            ArrayList<RowResult> results = new ArrayList<RowResult>();
            for (RowResult row : scanner) {
                results.add(row);
            }
            if (results.size() != 1) {
                ITClient.this.reportError("Random get got 0 or many rows " + results.size() + " for key " + key, null);
                return false;
            }
            int receivedKey = ((RowResult)results.get(0)).getInt(0);
            if (receivedKey != key) {
                ITClient.this.reportError("Tried to get key " + key + " and received " + receivedKey, null);
                return false;
            }
            return true;
        }

        private boolean fullScan() {
            TimeoutTracker timeoutTracker = new TimeoutTracker();
            timeoutTracker.setTimeout(50000L);
            while (ITClient.this.keepRunningLatch.getCount() > 0L && !timeoutTracker.timedOut()) {
                int rowCount;
                KuduScanner scanner = this.getScannerBuilder().build();
                try {
                    rowCount = ClientTestUtil.countRowsInScan((KuduScanner)scanner);
                }
                catch (KuduException e) {
                    return this.checkAndReportError("Got error while row counting", e);
                }
                if (rowCount >= this.lastRowCount) {
                    if (rowCount > this.lastRowCount) {
                        this.lastRowCount = rowCount;
                        LOG.info("New row count {}", (Object)this.lastRowCount);
                    }
                    return true;
                }
                ITClient.this.reportError("Row count unexpectedly decreased from " + this.lastRowCount + " to " + rowCount, null);
                try {
                    ITClient.this.keepRunningLatch.await(50L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            return !timeoutTracker.timedOut();
        }

        private KuduScanner.KuduScannerBuilder getScannerBuilder() {
            return (KuduScanner.KuduScannerBuilder)((KuduScanner.KuduScannerBuilder)((KuduScanner.KuduScannerBuilder)ITClient.this.harness.getClient().newScannerBuilder(ITClient.this.table).readMode(AsyncKuduScanner.ReadMode.READ_AT_SNAPSHOT)).snapshotTimestampRaw(ITClient.this.sharedWriteTimestamp)).setFaultTolerant(true);
        }

        private boolean checkAndReportError(String message, KuduException e) {
            if (e.getStatus().isTimedOut()) {
                LOG.warn("Received a scan timeout", (Throwable)e);
                return true;
            }
            if (!e.getStatus().isNotFound() && !e.getStatus().getMessage().contains("Invalid call sequence ID")) {
                ITClient.this.reportError(message, (Exception)((Object)e));
                return false;
            }
            return true;
        }
    }

    class WriterThread
    implements Runnable {
        private final KuduSession session;
        private final Random random;
        private int currentRowKey;

        WriterThread() {
            this.session = ITClient.this.harness.getClient().newSession();
            this.random = RandomUtils.getRandom();
            this.currentRowKey = 0;
        }

        @Override
        public void run() {
            this.session.setExternalConsistencyMode(ExternalConsistencyMode.CLIENT_PROPAGATED);
            while (ITClient.this.keepRunningLatch.getCount() > 0L) {
                try {
                    OperationResponse resp = this.session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)ITClient.this.table, (int)this.currentRowKey));
                    if (this.hasRowErrorAndReport(resp)) {
                        return;
                    }
                    ++this.currentRowKey;
                    if (this.currentRowKey % 10 != 0) continue;
                    List responses = this.session.flush();
                    if (responses != null) {
                        for (OperationResponse batchedResp : responses) {
                            if (!this.hasRowErrorAndReport(batchedResp)) continue;
                            return;
                        }
                    }
                    if (this.random.nextBoolean()) {
                        this.session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
                        continue;
                    }
                    this.session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC);
                }
                catch (Exception e) {
                    if (ITClient.this.keepRunningLatch.getCount() == 0L) {
                        return;
                    }
                    ITClient.this.reportError("Got error while inserting row " + this.currentRowKey, e);
                    return;
                }
            }
        }

        private boolean hasRowErrorAndReport(OperationResponse resp) {
            if (resp != null && resp.hasRowError()) {
                ITClient.this.reportError("The following RPC " + resp.getOperation().getRow() + " returned this error: " + resp.getRowError(), null);
                return true;
            }
            if (resp == null) {
                return false;
            }
            ITClient.this.sharedWriteTimestamp = resp.getWriteTimestampRaw();
            return false;
        }
    }

    class ChaosThread
    implements Runnable {
        private final Random random = RandomUtils.getRandom();

        ChaosThread() {
        }

        @Override
        public void run() {
            try {
                ITClient.this.keepRunningLatch.await(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                return;
            }
            while (ITClient.this.keepRunningLatch.getCount() > 0L) {
                try {
                    int randomInt = this.random.nextInt(3);
                    boolean shouldContinue = randomInt == 0 ? this.restartTS() : (randomInt == 1 ? this.disconnectNode() : this.restartMaster());
                    if (!shouldContinue) {
                        return;
                    }
                    ITClient.this.keepRunningLatch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        private boolean disconnectNode() {
            try {
                List connections = ITClient.this.harness.getAsyncClient().getConnectionListCopy();
                if (connections.isEmpty()) {
                    return true;
                }
                ((Connection)connections.get(this.random.nextInt(connections.size()))).disconnect();
            }
            catch (Exception e) {
                if (ITClient.this.keepRunningLatch.getCount() == 0L) {
                    return false;
                }
                ITClient.this.reportError("Couldn't disconnect a TS", e);
                return false;
            }
            return true;
        }

        private boolean restartTS() {
            try {
                ITClient.this.harness.restartTabletServer(ITClient.this.table);
            }
            catch (Exception e) {
                ITClient.this.reportError("Couldn't restart a TS", e);
                return false;
            }
            return true;
        }

        private boolean restartMaster() {
            try {
                ITClient.this.harness.restartLeaderMaster();
            }
            catch (Exception e) {
                ITClient.this.reportError("Couldn't restart a master", e);
                return false;
            }
            return true;
        }
    }
}

