/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kudu.Schema;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.InsertIgnore;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduScanToken;
import org.apache.kudu.client.KuduTableStatistics;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.PartitionSchema;
import org.apache.kudu.client.Update;
import org.apache.kudu.client.Upsert;
import org.apache.kudu.shaded.com.google.common.base.Predicates;
import org.apache.kudu.shaded.com.google.common.collect.Iterators;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KuduTable {
    private final Schema schema;
    private final PartitionSchema partitionSchema;
    private final AsyncKuduClient client;
    private final String name;
    private final String tableId;
    private final int numReplicas;
    private final Map<String, String> extraConfig;
    private final String owner;

    KuduTable(AsyncKuduClient client, String name, String tableId, Schema schema, PartitionSchema partitionSchema, int numReplicas, Map<String, String> extraConfig, String owner) {
        this.schema = schema;
        this.partitionSchema = partitionSchema;
        this.client = client;
        this.name = name;
        this.tableId = tableId;
        this.numReplicas = numReplicas;
        this.extraConfig = extraConfig;
        this.owner = owner;
    }

    public Schema getSchema() {
        return this.schema;
    }

    @InterfaceAudience.LimitedPrivate(value={"Impala"})
    @InterfaceStability.Unstable
    public PartitionSchema getPartitionSchema() {
        return this.partitionSchema;
    }

    public String getName() {
        return this.name;
    }

    public String getTableId() {
        return this.tableId;
    }

    public int getNumReplicas() {
        return this.numReplicas;
    }

    public Map<String, String> getExtraConfig() {
        return this.extraConfig;
    }

    public String getOwner() {
        return this.owner;
    }

    public AsyncKuduClient getAsyncClient() {
        return this.client;
    }

    public Insert newInsert() {
        return new Insert(this);
    }

    public Update newUpdate() {
        return new Update(this);
    }

    public Delete newDelete() {
        return new Delete(this);
    }

    public Upsert newUpsert() {
        return new Upsert(this);
    }

    public InsertIgnore newInsertIgnore() {
        return new InsertIgnore(this);
    }

    @Deprecated
    public Deferred<List<LocatedTablet>> asyncGetTabletsLocations(long deadline) {
        return this.asyncGetTabletsLocations(null, null, deadline);
    }

    @Deprecated
    public Deferred<List<LocatedTablet>> asyncGetTabletsLocations(byte[] startKey, byte[] endKey, long deadline) {
        return this.client.locateTable(this, startKey, endKey, AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP, deadline);
    }

    @Deprecated
    public List<LocatedTablet> getTabletsLocations(long deadline) throws Exception {
        return this.getTabletsLocations(null, null, deadline);
    }

    @Deprecated
    public List<LocatedTablet> getTabletsLocations(byte[] startKey, byte[] endKey, long deadline) throws Exception {
        return this.client.syncLocateTable(this, startKey, endKey, AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP, deadline);
    }

    @InterfaceAudience.LimitedPrivate(value={"Impala"})
    @InterfaceStability.Unstable
    public List<String> getFormattedRangePartitions(long timeout) throws Exception {
        List<Partition> rangePartitions = this.getRangePartitions(timeout);
        ArrayList<String> formattedPartitions = new ArrayList<String>();
        for (Partition partition : rangePartitions) {
            formattedPartitions.add(partition.formatRangePartition(this));
        }
        return formattedPartitions;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public List<Partition> getRangePartitions(long timeout) throws Exception {
        ArrayList<Partition> rangePartitions = new ArrayList<Partition>();
        Object scanTokens = new KuduScanToken.KuduScanTokenBuilder(this.client, this).setTimeout(timeout).build();
        Iterator iterator = scanTokens.iterator();
        while (iterator.hasNext()) {
            KuduScanToken token = (KuduScanToken)iterator.next();
            Partition partition = token.getTablet().getPartition();
            if (!Iterators.all(partition.getHashBuckets().iterator(), Predicates.equalTo(0))) continue;
            rangePartitions.add(partition);
        }
        return rangePartitions;
    }

    public KuduTableStatistics getTableStatistics() throws KuduException {
        return this.client.syncClient().getTableStatistics(this.name);
    }
}

