/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.httpcomponents;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.httpcomponents.DefaultUriMapper;
import io.micrometer.core.instrument.binder.httpcomponents.HttpContextUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.kudu.shaded.org.apache.http.HttpRequest;
import org.apache.kudu.shaded.org.apache.http.HttpRequestInterceptor;
import org.apache.kudu.shaded.org.apache.http.HttpResponseInterceptor;
import org.apache.kudu.shaded.org.apache.http.protocol.HttpContext;

@Incubating(since="1.4.0")
public class MicrometerHttpClientInterceptor {
    private static final String METER_NAME = "httpcomponents.httpclient.request";
    private final Map<HttpContext, Timer.Sample> timerByHttpContext = new ConcurrentHashMap<HttpContext, Timer.Sample>();
    private final HttpRequestInterceptor requestInterceptor = (request, context) -> this.timerByHttpContext.put(context, Timer.start(meterRegistry).tags("method", request.getRequestLine().getMethod(), "uri", (String)uriMapper.apply(request)));
    private final HttpResponseInterceptor responseInterceptor = (response, context) -> {
        Timer.Sample sample = this.timerByHttpContext.remove(context);
        sample.stop(meterRegistry, Timer.builder(METER_NAME).tag("status", Integer.toString(response.getStatusLine().getStatusCode())).tags(exportTagsForRoute ? HttpContextUtils.generateTagsForRoute(context) : Tags.empty()).tags(extraTags));
    };

    public MicrometerHttpClientInterceptor(MeterRegistry meterRegistry, Function<HttpRequest, String> uriMapper, Iterable<Tag> extraTags, boolean exportTagsForRoute) {
    }

    public MicrometerHttpClientInterceptor(MeterRegistry meterRegistry, Iterable<Tag> extraTags, boolean exportTagsForRoute) {
        this(meterRegistry, new DefaultUriMapper(), extraTags, exportTagsForRoute);
    }

    public HttpRequestInterceptor getRequestInterceptor() {
        return this.requestInterceptor;
    }

    public HttpResponseInterceptor getResponseInterceptor() {
        return this.responseInterceptor;
    }
}

