/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.client.HostAndPort;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NetUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetUtil.class);

    public static String hostsAndPortsToString(List<HostAndPort> hostsAndPorts) {
        return Joiner.on((String)",").join((Iterable)Lists.transform(hostsAndPorts, (Function)Functions.toStringFunction()));
    }

    public static HostAndPort parseString(String addrString, int defaultPort) {
        com.google.common.net.HostAndPort hostAndPort = addrString.indexOf(58) == -1 ? com.google.common.net.HostAndPort.fromParts((String)addrString, (int)defaultPort) : com.google.common.net.HostAndPort.fromString((String)addrString);
        return new HostAndPort(hostAndPort.getHost(), hostAndPort.getPort());
    }

    public static List<HostAndPort> parseStrings(String commaSepAddrs, int defaultPort) {
        Iterable addrStrings = Splitter.on((char)',').trimResults().split((CharSequence)commaSepAddrs);
        ArrayList hostsAndPorts = Lists.newArrayListWithCapacity((int)Iterables.size((Iterable)addrStrings));
        for (String addrString : addrStrings) {
            HostAndPort hostAndPort = NetUtil.parseString(addrString, defaultPort);
            hostsAndPorts.add(hostAndPort);
        }
        return hostsAndPorts;
    }

    public static InetAddress getInetAddress(String host) {
        InetAddress[] addrs = NetUtil.getAllInetAddresses(host);
        if (addrs != null && addrs.length > 0) {
            return addrs[0];
        }
        return null;
    }

    public static InetAddress[] getAllInetAddresses(String host) {
        long start = System.nanoTime();
        try {
            InetAddress[] ipAddrs = InetAddress.getAllByName(host);
            long latency = System.nanoTime() - start;
            if (latency > 500000L && LOG.isDebugEnabled()) {
                LOG.debug("Resolved IP of `{}' to {} in {}ns", new Object[]{host, ipAddrs, latency});
            } else if (latency >= 3000000L) {
                LOG.warn("Slow DNS lookup! Resolved IP of `{}' to {} in {}ns", new Object[]{host, ipAddrs, latency});
            }
            return ipAddrs;
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to resolve the IP of `{}' in {}ns", (Object)host, (Object)(System.nanoTime() - start));
            return null;
        }
    }

    public static boolean isLocalAddress(InetAddress addr) {
        boolean local;
        boolean bl = local = addr.isAnyLocalAddress() || addr.isLoopbackAddress();
        if (!local) {
            try {
                local = NetworkInterface.getByInetAddress(addr) != null;
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return local;
    }
}

