/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.client.Status;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RpcTraceFrame {
    private final String rpcMethod;
    private final Action action;
    private final ServerInfo serverInfo;
    private final long timestampMs;
    private final Status callStatus;

    private RpcTraceFrame(String rpcMethod, Action action, ServerInfo serverInfo, Status callStatus) {
        this.rpcMethod = rpcMethod;
        this.action = action;
        this.serverInfo = serverInfo;
        this.callStatus = callStatus;
        this.timestampMs = System.currentTimeMillis();
    }

    public String getRpcMethod() {
        return this.rpcMethod;
    }

    Action getAction() {
        return this.action;
    }

    ServerInfo getServer() {
        return this.serverInfo;
    }

    long getTimestampMs() {
        return this.timestampMs;
    }

    public Status getStatus() {
        return this.callStatus;
    }

    public static String getHumanReadableStringForTraces(List<RpcTraceFrame> traces) {
        if (traces.isEmpty()) {
            return "No traces";
        }
        RpcTraceFrame firstTrace = traces.get(0);
        String rootMethod = firstTrace.getRpcMethod();
        long baseTimestamp = firstTrace.getTimestampMs();
        StringBuilder sb = new StringBuilder("Traces: ");
        for (int i = 0; i < traces.size(); ++i) {
            RpcTraceFrame trace = traces.get(i);
            sb.append('[');
            sb.append(trace.getTimestampMs() - baseTimestamp);
            sb.append("ms] ");
            if (!rootMethod.equals(trace.getRpcMethod())) {
                sb.append(String.format("Sub RPC %s: ", trace.getRpcMethod()));
            }
            trace.getAction().appendToStringBuilder(trace, sb);
            if (i >= traces.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String getHumanReadableSummaryStringForTraces(List<RpcTraceFrame> traces) {
        if (traces.isEmpty()) {
            return "No traces";
        }
        RpcTraceFrame firstTrace = traces.get(0);
        long baseTimestamp = firstTrace.getTimestampMs();
        TreeBasedTable sentTable = TreeBasedTable.create();
        long sentCount = 0L;
        TreeBasedTable receivedTable = TreeBasedTable.create();
        long receivedCount = 0L;
        TreeBasedTable delayedTable = TreeBasedTable.create();
        long delayedCount = 0L;
        long masterRefreshCount = 0L;
        long authRefreshCount = 0L;
        boolean truncated = false;
        long maxTime = 0L;
        for (RpcTraceFrame trace : traces) {
            String uuid = trace.getServer() == null ? "UNKNOWN" : trace.getServer().getUuid();
            String method = trace.getRpcMethod() == null ? "UNKNOWN" : trace.getRpcMethod();
            String status = trace.getStatus() == null ? "UNKNOWN" : trace.getStatus().getCodeName();
            switch (trace.getAction()) {
                case SEND_TO_SERVER: {
                    long count = sentTable.contains((Object)uuid, (Object)method) ? (Long)sentTable.get((Object)uuid, (Object)method) : 0L;
                    sentTable.put((Object)uuid, (Object)method, (Object)(count + 1L));
                    ++sentCount;
                    break;
                }
                case RECEIVE_FROM_SERVER: {
                    long count = receivedTable.contains((Object)uuid, (Object)status) ? (Long)receivedTable.get((Object)uuid, (Object)status) : 0L;
                    receivedTable.put((Object)uuid, (Object)status, (Object)(count + 1L));
                    ++receivedCount;
                    break;
                }
                case SLEEP_THEN_RETRY: {
                    long count = delayedTable.contains((Object)uuid, (Object)method) ? (Long)delayedTable.get((Object)uuid, (Object)method) : 0L;
                    delayedTable.put((Object)uuid, (Object)method, (Object)(count + 1L));
                    ++delayedCount;
                    break;
                }
                case QUERY_MASTER: {
                    ++masterRefreshCount;
                    break;
                }
                case GET_NEW_AUTHENTICATION_TOKEN_THEN_RETRY: {
                    ++authRefreshCount;
                    break;
                }
                case TRACE_TRUNCATED: {
                    truncated = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected action: " + (Object)((Object)trace.getAction()));
                }
            }
            maxTime = Long.max(maxTime, trace.getTimestampMs() - baseTimestamp);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Trace Summary(%s ms): Sent(%s), Received(%s), Delayed(%s), MasterRefresh(%s), AuthRefresh(%s), Truncated: %s", maxTime, sentCount, receivedCount, delayedCount, masterRefreshCount, authRefreshCount, truncated));
        if (!sentTable.isEmpty()) {
            sb.append(String.format("%n Sent: %s", RpcTraceFrame.tableToString((Table<String, String, Long>)sentTable)));
        }
        if (!receivedTable.isEmpty()) {
            sb.append(String.format("%n Received: %s", RpcTraceFrame.tableToString((Table<String, String, Long>)receivedTable)));
        }
        if (!delayedTable.isEmpty()) {
            sb.append(String.format("%n Delayed: %s", RpcTraceFrame.tableToString((Table<String, String, Long>)delayedTable)));
        }
        return sb.toString();
    }

    private static String tableToString(Table<String, String, Long> table) {
        StringBuilder sb = new StringBuilder();
        ArrayList rowKeys = new ArrayList(table.rowKeySet());
        for (int i = 0; i < rowKeys.size(); ++i) {
            String rowKey = (String)rowKeys.get(i);
            sb.append("(").append(rowKey).append(", ");
            ArrayList columns = new ArrayList(table.row((Object)rowKey).entrySet());
            for (int j = 0; j < columns.size(); ++j) {
                Map.Entry column = (Map.Entry)columns.get(j);
                sb.append(String.format("[ %s, %s ]", column.getKey(), column.getValue()));
                if (j >= columns.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            if (i >= rowKeys.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rpcMethod", (Object)this.rpcMethod).add("timestampMs", this.timestampMs).add("action", (Object)this.action).add("serverInfo", (Object)this.serverInfo).add("callStatus", (Object)this.callStatus).toString();
    }

    static class RpcTraceFrameBuilder {
        private final String rpcMethod;
        private final Action action;
        private ServerInfo serverInfo;
        private Status callStatus;

        RpcTraceFrameBuilder(String rpcMethod, Action action) {
            this.rpcMethod = rpcMethod;
            this.action = action;
        }

        public RpcTraceFrameBuilder serverInfo(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            return this;
        }

        public RpcTraceFrameBuilder callStatus(Status callStatus) {
            this.callStatus = callStatus;
            return this;
        }

        public RpcTraceFrame build() {
            return new RpcTraceFrame(this.rpcMethod, this.action, this.serverInfo, this.callStatus);
        }
    }

    static enum Action {
        SEND_TO_SERVER{

            @Override
            void appendToStringBuilder(RpcTraceFrame trace, StringBuilder sb) {
                sb.append(String.format("sending RPC to server %s", trace.getServer().getUuid()));
            }
        }
        ,
        RECEIVE_FROM_SERVER{

            @Override
            void appendToStringBuilder(RpcTraceFrame trace, StringBuilder sb) {
                sb.append(String.format("received response from server %s: %s", trace.getServer().getUuid(), trace.getStatus()));
            }
        }
        ,
        SLEEP_THEN_RETRY{

            @Override
            void appendToStringBuilder(RpcTraceFrame trace, StringBuilder sb) {
                sb.append(String.format("delaying RPC due to: %s", trace.getStatus()));
            }
        }
        ,
        GET_NEW_AUTHENTICATION_TOKEN_THEN_RETRY{

            @Override
            void appendToStringBuilder(RpcTraceFrame trace, StringBuilder sb) {
                sb.append("waiting for new authn token");
            }
        }
        ,
        QUERY_MASTER{

            @Override
            void appendToStringBuilder(RpcTraceFrame trace, StringBuilder sb) {
                sb.append("refreshing cache from master");
            }
        }
        ,
        TRACE_TRUNCATED{

            @Override
            void appendToStringBuilder(RpcTraceFrame trace, StringBuilder sb) {
                sb.append(String.format("too many traces: truncated at %d traces", 100));
            }
        };


        abstract void appendToStringBuilder(RpcTraceFrame var1, StringBuilder var2);
    }
}

