/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.rpc.RpcHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RpcOutboundMessage {
    private static final Logger LOG = LoggerFactory.getLogger(RpcOutboundMessage.class);
    private final RpcHeader.RequestHeader.Builder headerBuilder;
    private final Message body;

    RpcOutboundMessage(RpcHeader.RequestHeader.Builder header, Message body) {
        this.headerBuilder = header;
        this.body = body;
    }

    public RpcHeader.RequestHeader.Builder getHeaderBuilder() {
        return this.headerBuilder;
    }

    public Message getBody() {
        return this.body;
    }

    public String toString() {
        return "RpcOutboundMessage[header={" + TextFormat.shortDebugString((MessageOrBuilder)this.headerBuilder) + "}, body={" + TextFormat.shortDebugString((MessageOrBuilder)this.body) + "}]";
    }

    static class Encoder
    extends MessageToByteEncoder<RpcOutboundMessage> {
        Encoder() {
        }

        protected void encode(ChannelHandlerContext ctx, RpcOutboundMessage msg, ByteBuf out) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}: sending RPC {}", (Object)ctx.channel(), (Object)msg);
            }
            KuduRpc.toByteBuf(out, (Message)msg.getHeaderBuilder().build(), msg.getBody());
        }
    }
}

