/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class IPCUtil {
    public static int write(OutputStream dos, Message header, Message param) throws IOException {
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited(header, param);
        return IPCUtil.write(dos, header, param, totalSize);
    }

    private static int write(OutputStream dos, Message header, Message param, int totalSize) throws IOException {
        dos.write(IPCUtil.toBytes(totalSize));
        header.writeDelimitedTo(dos);
        if (param != null) {
            param.writeDelimitedTo(dos);
        }
        dos.flush();
        return totalSize;
    }

    public static int getTotalSizeWhenWrittenDelimited(Message ... messages) {
        int totalSize = 0;
        for (Message m : messages) {
            if (m == null) continue;
            totalSize += m.getSerializedSize();
            totalSize += CodedOutputStream.computeUInt32SizeNoTag((int)m.getSerializedSize());
        }
        return totalSize;
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }
}

