/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.base.Objects;
import java.net.InetSocketAddress;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HostAndPort {
    private final InetSocketAddress address;

    public HostAndPort(String host, int port) {
        this.address = InetSocketAddress.createUnresolved(host, port);
    }

    public String getHost() {
        return this.address.getHostString();
    }

    public int getPort() {
        return this.address.getPort();
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostAndPort)) {
            return false;
        }
        HostAndPort that = (HostAndPort)o;
        return Objects.equal((Object)this.address, (Object)that.address);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.address});
    }

    public String toString() {
        return this.address.toString();
    }
}

