/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.netty.util.Timer;
import java.util.Collection;
import java.util.List;
import org.apache.kudu.Schema;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.GetTableSchemaResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class GetTableSchemaRequest
extends KuduRpc<GetTableSchemaResponse> {
    private final String id;
    private final String name;
    private final List<Integer> requiredFeatures;

    GetTableSchemaRequest(KuduTable masterTable, String id, String name, Timer timer, long timeoutMillis, boolean requiresAuthzTokenSupport) {
        super(masterTable, timer, timeoutMillis);
        Preconditions.checkArgument((boolean)(id != null ^ name != null), (Object)"Only one of table ID or the table name should be provided");
        this.id = id;
        this.name = name;
        this.requiredFeatures = requiresAuthzTokenSupport ? ImmutableList.of((Object)5) : ImmutableList.of();
    }

    @Override
    Message createRequestPB() {
        Master.GetTableSchemaRequestPB.Builder builder = Master.GetTableSchemaRequestPB.newBuilder();
        Master.TableIdentifierPB.Builder identifierBuilder = Master.TableIdentifierPB.newBuilder();
        if (this.id != null) {
            identifierBuilder.setTableId(ByteString.copyFromUtf8((String)this.id));
        } else {
            Preconditions.checkNotNull((Object)this.name);
            identifierBuilder.setTableName(this.name);
        }
        builder.setTable(identifierBuilder.build());
        return builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "GetTableSchema";
    }

    @Override
    Pair<GetTableSchemaResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.GetTableSchemaResponsePB.Builder respBuilder = Master.GetTableSchemaResponsePB.newBuilder();
        GetTableSchemaRequest.readProtobuf(callResponse.getPBMessage(), (Message.Builder)respBuilder);
        Schema schema = ProtobufHelper.pbToSchema(respBuilder.getSchema());
        GetTableSchemaResponse response = new GetTableSchemaResponse(this.timeoutTracker.getElapsedMillis(), tsUUID, schema, respBuilder.getTableId().toStringUtf8(), respBuilder.getTableName(), respBuilder.getNumReplicas(), ProtobufHelper.pbToPartitionSchema(respBuilder.getPartitionSchema(), schema), respBuilder.hasAuthzToken() ? respBuilder.getAuthzToken() : null, respBuilder.getExtraConfigsMap(), respBuilder.hasOwner() ? respBuilder.getOwner() : "");
        return new Pair<GetTableSchemaResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }

    @Override
    Collection<Integer> getRequiredFeatures() {
        return this.requiredFeatures;
    }
}

