/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.UnsafeByteOperations;
import io.netty.util.Timer;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class GetTableLocationsRequest
extends KuduRpc<Master.GetTableLocationsResponsePB> {
    private final byte[] startPartitionKey;
    private final byte[] endKey;
    private final String tableId;
    private final int maxReturnedLocations;

    GetTableLocationsRequest(KuduTable table, byte[] startPartitionKey, byte[] endPartitionKey, String tableId, int maxReturnedLocations, Timer timer, long timeoutMillis) {
        super(table, timer, timeoutMillis);
        if (startPartitionKey != null && endPartitionKey != null && Bytes.memcmp(startPartitionKey, endPartitionKey) > 0) {
            throw new IllegalArgumentException("The start partition key must be smaller or equal to the end partition key");
        }
        this.startPartitionKey = startPartitionKey;
        this.endKey = endPartitionKey;
        this.tableId = tableId;
        this.maxReturnedLocations = maxReturnedLocations;
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "GetTableLocations";
    }

    @Override
    Pair<Master.GetTableLocationsResponsePB, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.GetTableLocationsResponsePB.Builder builder = Master.GetTableLocationsResponsePB.newBuilder();
        GetTableLocationsRequest.readProtobuf(callResponse.getPBMessage(), (Message.Builder)builder);
        Master.GetTableLocationsResponsePB resp = builder.build();
        return new Pair<Master.GetTableLocationsResponsePB, Object>(resp, builder.hasError() ? builder.getError() : null);
    }

    @Override
    Message createRequestPB() {
        Master.GetTableLocationsRequestPB.Builder builder = Master.GetTableLocationsRequestPB.newBuilder();
        builder.setTable(Master.TableIdentifierPB.newBuilder().setTableId(ByteString.copyFromUtf8((String)this.tableId)));
        if (this.startPartitionKey != null) {
            builder.setPartitionKeyStart(UnsafeByteOperations.unsafeWrap((byte[])this.startPartitionKey));
        }
        if (this.endKey != null) {
            builder.setPartitionKeyEnd(UnsafeByteOperations.unsafeWrap((byte[])this.endKey));
        }
        builder.setMaxReturnedLocations(this.maxReturnedLocations);
        builder.setInternTsInfosInResponse(true);
        return builder.build();
    }
}

