/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import io.netty.util.Timer;
import java.util.Collection;
import java.util.List;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.AlterTableResponse;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AlterTableRequest
extends KuduRpc<AlterTableResponse> {
    static final String ALTER_TABLE = "AlterTable";
    private final String name;
    private final Master.AlterTableRequestPB.Builder builder;
    private final List<Integer> requiredFeatures;

    AlterTableRequest(KuduTable masterTable, String name, AlterTableOptions ato, Timer timer, long timeoutMillis) {
        super(masterTable, timer, timeoutMillis);
        this.name = name;
        this.builder = ato.getProtobuf();
        this.requiredFeatures = ato.hasAddDropRangePartitions() ? ImmutableList.of((Object)1) : ImmutableList.of();
    }

    @Override
    Message createRequestPB() {
        Master.TableIdentifierPB tableID = Master.TableIdentifierPB.newBuilder().setTableName(this.name).build();
        this.builder.setTable(tableID);
        return this.builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return ALTER_TABLE;
    }

    @Override
    Pair<AlterTableResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.AlterTableResponsePB.Builder respBuilder = Master.AlterTableResponsePB.newBuilder();
        AlterTableRequest.readProtobuf(callResponse.getPBMessage(), (Message.Builder)respBuilder);
        AlterTableResponse response = new AlterTableResponse(this.timeoutTracker.getElapsedMillis(), tsUUID, respBuilder.hasTableId() ? respBuilder.getTableId().toStringUtf8() : null);
        return new Pair<AlterTableResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }

    @Override
    Collection<Integer> getRequiredFeatures() {
        return this.requiredFeatures;
    }
}

