/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.util.TimestampUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestTimestampUtil {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testTimestampConversion() throws Exception {
        Timestamp epoch = new Timestamp(0L);
        Assert.assertEquals((long)0L, (long)TimestampUtil.timestampToMicros((Timestamp)epoch));
        Assert.assertEquals((Object)epoch, (Object)TimestampUtil.microsToTimestamp((long)0L));
        Timestamp t1 = new Timestamp(0L);
        t1.setNanos(123456000);
        Assert.assertEquals((long)123456L, (long)TimestampUtil.timestampToMicros((Timestamp)t1));
        Assert.assertEquals((Object)t1, (Object)TimestampUtil.microsToTimestamp((long)123456L));
        SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        iso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
        Timestamp t3 = new Timestamp(iso8601.parse("1923-12-01T00:44:36.876").getTime());
        t3.setNanos(876544000);
        Assert.assertEquals((long)-1454368523123456L, (long)TimestampUtil.timestampToMicros((Timestamp)t3));
        Assert.assertEquals((Object)t3, (Object)TimestampUtil.microsToTimestamp((long)-1454368523123456L));
    }

    @Test
    public void testNonZuluTimestampConversion() throws Exception {
        SimpleDateFormat cst = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        cst.setTimeZone(TimeZone.getTimeZone("America/Chicago"));
        String timeString = "2016-08-19T12:12:12.121";
        Timestamp timestamp = new Timestamp(cst.parse(timeString).getTime());
        long toMicros = TimestampUtil.timestampToMicros((Timestamp)timestamp);
        Timestamp fromMicros = TimestampUtil.microsToTimestamp((long)toMicros);
        String formattedCST = cst.format(fromMicros);
        Assert.assertEquals((long)1471626732121000L, (long)toMicros);
        Assert.assertEquals((Object)timestamp, (Object)fromMicros);
        Assert.assertEquals((Object)timeString, (Object)formattedCST);
        SimpleDateFormat pst = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        pst.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
        String formattedPST = pst.format(fromMicros);
        Assert.assertEquals((Object)"2016-08-19T10:12:12.121", (Object)formattedPST);
        SimpleDateFormat utc = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        utc.setTimeZone(TimeZone.getTimeZone("UTC"));
        String formattedUTC = utc.format(fromMicros);
        Assert.assertEquals((Object)"2016-08-19T17:12:12.121", (Object)formattedUTC);
    }
}

