/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.util.NetUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestNetUtil {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testParseString() {
        String stringWithPort = "1.2.3.4:1234";
        HostAndPort hostAndPortForStringWithPort = NetUtil.parseString((String)stringWithPort, (int)0);
        Assert.assertEquals((Object)hostAndPortForStringWithPort.getHost(), (Object)"1.2.3.4");
        Assert.assertEquals((long)hostAndPortForStringWithPort.getPort(), (long)1234L);
        String stringWithoutPort = "1.2.3.4";
        HostAndPort hostAndPortForStringWithoutPort = NetUtil.parseString((String)stringWithoutPort, (int)12345);
        Assert.assertEquals((Object)hostAndPortForStringWithoutPort.getHost(), (Object)stringWithoutPort);
        Assert.assertEquals((long)hostAndPortForStringWithoutPort.getPort(), (long)12345L);
    }

    @Test
    public void testParseStrings() {
        String testAddrs = "1.2.3.4.5,10.0.0.1:5555,127.0.0.1:7777";
        List hostsAndPorts = NetUtil.parseStrings((String)testAddrs, (int)3333);
        Assert.assertArrayEquals((Object[])hostsAndPorts.toArray(), (Object[])new HostAndPort[]{new HostAndPort("1.2.3.4.5", 3333), new HostAndPort("10.0.0.1", 5555), new HostAndPort("127.0.0.1", 7777)});
    }

    @Test
    public void testHostsAndPortsToString() {
        List<HostAndPort> hostsAndPorts = Arrays.asList(new HostAndPort("127.0.0.1", 1111), new HostAndPort("1.2.3.4.5", 0));
        Assert.assertEquals((Object)NetUtil.hostsAndPortsToString(hostsAndPorts), (Object)"127.0.0.1:1111,1.2.3.4.5:0");
    }

    @Test
    public void testLocal() throws Exception {
        Assert.assertTrue((boolean)NetUtil.isLocalAddress((InetAddress)NetUtil.getInetAddress((String)"localhost")));
        Assert.assertTrue((boolean)NetUtil.isLocalAddress((InetAddress)NetUtil.getInetAddress((String)"127.0.0.1")));
        Assert.assertTrue((boolean)NetUtil.isLocalAddress((InetAddress)InetAddress.getLocalHost()));
        Assert.assertFalse((boolean)NetUtil.isLocalAddress((InetAddress)NetUtil.getInetAddress((String)"kudu.apache.org")));
    }
}

