/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import java.nio.charset.StandardCharsets;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.util.HashUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestFashHash {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testFastHash64() {
        long hash = HashUtil.fastHash64((byte[])"ab".getBytes(StandardCharsets.UTF_8), (long)0L);
        Assert.assertEquals((long)Long.parseUnsignedLong("17293172613997361769"), (long)hash);
        hash = HashUtil.fastHash64((byte[])"abcdefg".getBytes(StandardCharsets.UTF_8), (long)0L);
        Assert.assertEquals((long)Long.parseUnsignedLong("10206404559164245992"), (long)hash);
        hash = HashUtil.fastHash64((byte[])"quick brown fox".getBytes(StandardCharsets.UTF_8), (long)42L);
        Assert.assertEquals((long)Long.parseUnsignedLong("3757424404558187042"), (long)hash);
        hash = HashUtil.fastHash64(null, (long)0L);
        Assert.assertEquals((long)Long.parseUnsignedLong("12680076593665652444"), (long)hash);
        hash = HashUtil.fastHash64((byte[])"".getBytes(StandardCharsets.UTF_8), (long)0L);
        Assert.assertEquals((long)0L, (long)hash);
    }

    @Test
    public void testFastHash32() {
        int hash = HashUtil.fastHash32((byte[])"ab".getBytes(StandardCharsets.UTF_8), (int)0);
        Assert.assertEquals((long)Integer.parseUnsignedInt("2564147595"), (long)hash);
        hash = HashUtil.fastHash32((byte[])"abcdefg".getBytes(StandardCharsets.UTF_8), (int)0);
        Assert.assertEquals((long)Integer.parseUnsignedInt("1497700618"), (long)hash);
        hash = HashUtil.fastHash32((byte[])"quick brown fox".getBytes(StandardCharsets.UTF_8), (int)42);
        Assert.assertEquals((long)Integer.parseUnsignedInt("1676541068"), (long)hash);
        hash = HashUtil.fastHash32(null, (int)0);
        Assert.assertEquals((long)Integer.parseUnsignedInt("842467426"), (long)hash);
        hash = HashUtil.fastHash32((byte[])"".getBytes(StandardCharsets.UTF_8), (int)0);
        Assert.assertEquals((long)0L, (long)hash);
    }
}

