/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.Status;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class TestTimeouts {
    private static final String TABLE_NAME = TestTimeouts.class.getName() + "-" + System.currentTimeMillis();
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Test(timeout=100000L)
    public void testLowTimeouts() throws Exception {
        try (KuduClient lowTimeoutsClient = new KuduClient.KuduClientBuilder(this.harness.getMasterAddressesAsString()).defaultAdminOperationTimeoutMs(1L).defaultOperationTimeoutMs(1L).build();){
            Status failureStatus;
            try {
                lowTimeoutsClient.listTabletServers();
                Assert.fail((String)"Should have timed out");
            }
            catch (KuduException ex) {
                failureStatus = ex.getStatus();
                Assert.assertTrue((failureStatus.isTimedOut() || failureStatus.isServiceUnavailable() ? 1 : 0) != 0);
            }
            this.harness.getClient().createTable(TABLE_NAME, ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions());
            try {
                KuduTable table = lowTimeoutsClient.openTable(TABLE_NAME);
                KuduSession lowTimeoutSession = lowTimeoutsClient.newSession();
                OperationResponse response = lowTimeoutSession.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)1));
                Assert.assertTrue((boolean)response.hasRowError());
                Assert.assertTrue((boolean)response.getRowError().getErrorStatus().isTimedOut());
                KuduScanner lowTimeoutScanner = lowTimeoutsClient.newScannerBuilder(table).build();
                lowTimeoutScanner.nextRows();
                Assert.fail((String)"Should have timed out");
            }
            catch (KuduException ex) {
                failureStatus = ex.getStatus();
                Assert.assertTrue((failureStatus.isTimedOut() || failureStatus.isServiceUnavailable() ? 1 : 0) != 0);
            }
        }
    }

    @Test(timeout=100000L)
    @KuduTestHarness.TabletServerConfig(flags={"--scanner_inject_latency_on_each_batch_ms=200000"})
    public void testTimeoutEvenWhenServerHangs() throws Exception {
        KuduClient client = this.harness.getClient();
        KuduTable table = client.createTable(TABLE_NAME, ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions());
        Assert.assertFalse((boolean)client.newSession().apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)0)).hasRowError());
        client.getTablesList();
        KuduScanner scanner = ((KuduScanner.KuduScannerBuilder)client.newScannerBuilder(table).scanRequestTimeout(1000L)).build();
        try {
            scanner.nextRows();
            Assert.fail((String)"should not have completed nextRows");
        }
        catch (NonRecoverableException e) {
            Assert.assertTrue((boolean)e.getStatus().isTimedOut());
        }
    }

    @Test(timeout=100000L)
    @Ignore
    @KuduTestHarness.MasterServerConfig(flags={"--rpc_negotiation_inject_delay_ms=1000"})
    public void testClientNegotiationTimeout() throws Exception {
        try (KuduClient lowTimeoutsClient = new KuduClient.KuduClientBuilder(this.harness.getMasterAddressesAsString()).defaultAdminOperationTimeoutMs(5000L).build();){
            try {
                lowTimeoutsClient.getTablesList();
                Assert.fail((String)"should not have completed getTablesList");
            }
            catch (NonRecoverableException nonRecoverableException) {
                // empty catch block
            }
        }
    }
}

