/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.client.TableLocationsCache;
import org.apache.kudu.client.TestRemoteTablet;
import org.apache.kudu.test.junit.RetryRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTableLocationsCache {
    private TableLocationsCache cache = new TableLocationsCache();
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Before
    public void mockTime() {
        TableLocationsCache.ticker = (Ticker)Mockito.mock(Ticker.class);
    }

    @After
    public void unmockTime() {
        TableLocationsCache.ticker = Ticker.systemTicker();
    }

    @Test
    public void testToString() {
        RemoteTablet tablet = TestRemoteTablet.getTablet(0, 1, -1);
        ImmutableList tablets = ImmutableList.of((Object)tablet);
        this.cache.cacheTabletLocations((List)tablets, tablet.getPartition().getPartitionKeyStart(), 1, 100L);
        Mockito.when((Object)TableLocationsCache.ticker.read()).thenReturn((Object)10000000L);
        Assert.assertEquals((Object)("[Tablet{lowerBoundPartitionKey=0x, upperBoundPartitionKey=0x, ttl=90, tablet=" + tablet.toString() + "}]"), (Object)this.cache.toString());
    }
}

