/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Arrays;
import org.apache.kudu.client.Status;
import org.apache.kudu.test.junit.RetryRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestStatus {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testOKStatus() {
        Status s = Status.OK();
        Assert.assertTrue((boolean)s.ok());
        Assert.assertFalse((boolean)s.isNotAuthorized());
        Assert.assertEquals((long)-1L, (long)s.getPosixCode());
        Assert.assertEquals((Object)"OK", (Object)s.toString());
    }

    @Test
    public void testStatusNonPosix() {
        Status s = Status.Aborted((String)"foo");
        Assert.assertFalse((boolean)s.ok());
        Assert.assertTrue((boolean)s.isAborted());
        Assert.assertEquals((Object)"ABORTED", (Object)s.getCodeName());
        Assert.assertEquals((Object)"foo", (Object)s.getMessage());
        Assert.assertEquals((long)-1L, (long)s.getPosixCode());
        Assert.assertEquals((Object)"Aborted: foo", (Object)s.toString());
    }

    @Test
    public void testPosixCode() {
        Status s = Status.NotFound((String)"File not found", (int)2);
        Assert.assertFalse((boolean)s.ok());
        Assert.assertFalse((boolean)s.isAborted());
        Assert.assertTrue((boolean)s.isNotFound());
        Assert.assertEquals((long)2L, (long)s.getPosixCode());
        Assert.assertEquals((Object)"Not found: File not found (error 2)", (Object)s.toString());
    }

    @Test
    public void testMessageTooLong() {
        char[] chars = new char[32768];
        Arrays.fill(chars, 'a');
        Status s = Status.Corruption((String)new String(chars));
        Assert.assertEquals((long)32768L, (long)s.getMessage().length());
        Assert.assertEquals((Object)s.getMessage().substring(32768 - Status.ABBREVIATION_CHARS_LENGTH), (Object)"aaa");
        chars = new char[32769];
        Arrays.fill(chars, 'a');
        s = Status.Corruption((String)new String(chars));
        Assert.assertEquals((long)32768L, (long)s.getMessage().length());
        Assert.assertEquals((Object)s.getMessage().substring(32768 - Status.ABBREVIATION_CHARS_LENGTH), (Object)"...");
        chars = new char[65536];
        Arrays.fill(chars, 'a');
        s = Status.Corruption((String)new String(chars));
        Assert.assertEquals((long)32768L, (long)s.getMessage().length());
        Assert.assertEquals((Object)s.getMessage().substring(32768 - Status.ABBREVIATION_CHARS_LENGTH), (Object)"...");
    }
}

