/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.List;
import org.apache.kudu.Schema;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.KeyEncoder;
import org.apache.kudu.client.KeyRange;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestSplitKeyRange {
    private static final String TABLE_NAME = TestSplitKeyRange.class.getName() + "-" + System.currentTimeMillis();
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Test
    @KuduTestHarness.TabletServerConfig(flags={"--flush_threshold_mb=1", "--flush_threshold_secs=1", "--enable_rowset_compaction=false"})
    public void testSplitKeyRange() throws Exception {
        KuduTable table = ClientTestUtil.createTableWithOneThousandRows((AsyncKuduClient)this.harness.getAsyncClient(), (String)TABLE_NAME, (int)32768, (long)50000L);
        Thread.sleep(5000L);
        Schema schema = table.getSchema();
        List keyRanges = (List)table.getAsyncClient().getTableKeyRanges(table, null, null, null, null, AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP, -1L, 50000L).join();
        Assert.assertEquals((long)4L, (long)keyRanges.size());
        LocatedTablet tablet0 = ((KeyRange)keyRanges.get(0)).getTablet();
        LocatedTablet tablet1 = ((KeyRange)keyRanges.get(1)).getTablet();
        LocatedTablet tablet2 = ((KeyRange)keyRanges.get(2)).getTablet();
        LocatedTablet tablet3 = ((KeyRange)keyRanges.get(3)).getTablet();
        keyRanges = (List)table.getAsyncClient().getTableKeyRanges(table, null, null, tablet1.getPartition().getPartitionKeyStart(), tablet1.getPartition().getPartitionKeyEnd(), AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP, -1L, 50000L).join();
        Assert.assertEquals((long)1L, (long)keyRanges.size());
        Assert.assertEquals((Object)tablet1.toString(), (Object)((KeyRange)keyRanges.get(0)).getTablet().toString());
        Assert.assertNull((Object)((KeyRange)keyRanges.get(0)).getPrimaryKeyStart());
        Assert.assertNull((Object)((KeyRange)keyRanges.get(0)).getPrimaryKeyEnd());
        keyRanges = (List)table.getAsyncClient().getTableKeyRanges(table, null, null, tablet1.getPartition().getPartitionKeyStart(), tablet1.getPartition().getPartitionKeyEnd(), AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP, 0x40000000L, 50000L).join();
        Assert.assertEquals((long)1L, (long)keyRanges.size());
        Assert.assertEquals((Object)tablet1.toString(), (Object)((KeyRange)keyRanges.get(0)).getTablet().toString());
        keyRanges = (List)table.getAsyncClient().getTableKeyRanges(table, null, null, tablet1.getPartition().getPartitionKeyStart(), tablet2.getPartition().getPartitionKeyEnd(), AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP, 0x40000000L, 50000L).join();
        Assert.assertEquals((long)2L, (long)keyRanges.size());
        Assert.assertEquals((Object)tablet1.toString(), (Object)((KeyRange)keyRanges.get(0)).getTablet().toString());
        Assert.assertEquals((Object)tablet2.toString(), (Object)((KeyRange)keyRanges.get(1)).getTablet().toString());
        PartialRow partialRowStart = schema.newPartialRow();
        partialRowStart.addInt(0, 1500);
        PartialRow partialRowEnd = schema.newPartialRow();
        partialRowEnd.addInt(0, 2000);
        byte[] primaryKeyStart = KeyEncoder.encodePrimaryKey((PartialRow)partialRowStart);
        byte[] primaryKeyEnd = KeyEncoder.encodePrimaryKey((PartialRow)partialRowEnd);
        keyRanges = (List)table.getAsyncClient().getTableKeyRanges(table, primaryKeyStart, primaryKeyEnd, tablet1.getPartition().getPartitionKeyStart(), tablet1.getPartition().getPartitionKeyEnd(), AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP, 0x40000000L, 50000L).join();
        Assert.assertEquals((long)1L, (long)keyRanges.size());
        Assert.assertEquals((Object)tablet1.toString(), (Object)((KeyRange)keyRanges.get(0)).getTablet().toString());
        Assert.assertEquals((Object)partialRowStart.toString(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])((KeyRange)keyRanges.get(0)).getPrimaryKeyStart()).toString());
        Assert.assertEquals((Object)partialRowEnd.toString(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])((KeyRange)keyRanges.get(0)).getPrimaryKeyEnd()).toString());
        primaryKeyStart = KeyEncoder.encodePrimaryKey((PartialRow)partialRowStart);
        primaryKeyEnd = KeyEncoder.encodePrimaryKey((PartialRow)partialRowEnd);
        keyRanges = (List)table.getAsyncClient().getTableKeyRanges(table, primaryKeyStart, primaryKeyEnd, null, null, AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP, 0x40000000L, 50000L).join();
        Assert.assertEquals((long)4L, (long)keyRanges.size());
        Assert.assertEquals((Object)tablet0.toString(), (Object)((KeyRange)keyRanges.get(0)).getTablet().toString());
        Assert.assertEquals((Object)partialRowStart.toString(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])((KeyRange)keyRanges.get(0)).getPrimaryKeyStart()).toString());
        Assert.assertEquals((Object)partialRowEnd.toString(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])((KeyRange)keyRanges.get(0)).getPrimaryKeyEnd()).toString());
        Assert.assertEquals((Object)tablet1.toString(), (Object)((KeyRange)keyRanges.get(1)).getTablet().toString());
        Assert.assertEquals((Object)partialRowStart.toString(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])((KeyRange)keyRanges.get(1)).getPrimaryKeyStart()).toString());
        Assert.assertEquals((Object)partialRowEnd.toString(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])((KeyRange)keyRanges.get(1)).getPrimaryKeyEnd()).toString());
        Assert.assertEquals((Object)tablet2.toString(), (Object)((KeyRange)keyRanges.get(2)).getTablet().toString());
        Assert.assertEquals((Object)partialRowStart.toString(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])((KeyRange)keyRanges.get(2)).getPrimaryKeyStart()).toString());
        Assert.assertEquals((Object)partialRowEnd.toString(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])((KeyRange)keyRanges.get(2)).getPrimaryKeyEnd()).toString());
        Assert.assertEquals((Object)tablet3.toString(), (Object)((KeyRange)keyRanges.get(3)).getTablet().toString());
        Assert.assertEquals((Object)partialRowStart.toString(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])((KeyRange)keyRanges.get(3)).getPrimaryKeyStart()).toString());
        Assert.assertEquals((Object)partialRowEnd.toString(), (Object)KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])((KeyRange)keyRanges.get(3)).getPrimaryKeyEnd()).toString());
        partialRowStart = schema.newPartialRow();
        partialRowStart.addInt(0, 200);
        partialRowEnd = schema.newPartialRow();
        partialRowEnd.addInt(0, 800);
        primaryKeyStart = KeyEncoder.encodePrimaryKey((PartialRow)partialRowStart);
        primaryKeyEnd = KeyEncoder.encodePrimaryKey((PartialRow)partialRowEnd);
        keyRanges = (List)table.getAsyncClient().getTableKeyRanges(table, primaryKeyStart, primaryKeyEnd, null, null, AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP, 1024L, 50000L).join();
        Assert.assertTrue((keyRanges.size() > 4 ? 1 : 0) != 0);
        for (KeyRange keyRange : keyRanges) {
            int startKey = KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])keyRange.getPrimaryKeyStart()).getInt(0);
            int endKey = KeyEncoder.decodePrimaryKey((Schema)schema, (byte[])keyRange.getPrimaryKeyEnd()).getInt(0);
            Assert.assertTrue((200 <= startKey ? 1 : 0) != 0);
            Assert.assertTrue((startKey <= endKey ? 1 : 0) != 0);
            Assert.assertTrue((800 >= endKey ? 1 : 0) != 0);
            Assert.assertTrue((0L <= keyRange.getDataSizeBytes() ? 1 : 0) != 0);
        }
    }
}

