/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.test.cluster.FakeDNS;
import org.apache.kudu.test.junit.RetryRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestServerInfo {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testGetAndCanonicalizeUnknownHostname() throws Exception {
        this.installFakeDNS("master1.example.com", "server123.example.com", "10.1.2.3");
        ServerInfo serverInfo = new ServerInfo("nevermind", new HostAndPort("master2.example.com", 12345), InetAddress.getByName("10.1.2.3"), "");
        Assert.assertEquals((Object)"master2.example.com", (Object)serverInfo.getAndCanonicalizeHostname());
        Assert.assertEquals((Object)"", (Object)serverInfo.getLocation());
    }

    @Test
    public void testGetAndCanonicalizeHostname() throws Exception {
        this.installFakeDNS("master1.example.com", "server123.example.com", "10.1.2.3");
        ServerInfo serverInfo = new ServerInfo("abcdef", new HostAndPort("master1.example.com", 12345), InetAddress.getByName("10.1.2.3"), "/foo");
        Assert.assertEquals((Object)"server123.example.com", (Object)serverInfo.getAndCanonicalizeHostname());
        Assert.assertEquals((Object)"/foo", (Object)serverInfo.getLocation());
        Assert.assertEquals((Object)"abcdef(master1.example.com:12345)", (Object)serverInfo.toString());
    }

    private void installFakeDNS(String alias, String canonical, String ip) throws UnknownHostException {
        FakeDNS fakeDNS = FakeDNS.getInstance();
        fakeDNS.install();
        InetAddress inetAddress = InetAddress.getByName(ip);
        fakeDNS.addForwardResolution(alias, inetAddress);
        fakeDNS.addForwardResolution(canonical, inetAddress);
        fakeDNS.addReverseResolution(inetAddress, canonical);
    }
}

