/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import org.apache.kudu.client.Client;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestSecurityContextRealUser {
    private String tableName;
    private static final MiniKuduCluster.MiniKuduClusterBuilder clusterBuilder = KuduTestHarness.getBaseClusterBuilder().enableKerberos().addMasterServerFlag("--user-acl=token-user").addMasterServerFlag("--superuser-acl=test-admin").addMasterServerFlag("--rpc-authentication=optional").addMasterServerFlag("--rpc-trace-negotiation").addTabletServerFlag("--user-acl=token-user").addTabletServerFlag("--superuser-acl=test-admin").addTabletServerFlag("--rpc-authentication=optional").addTabletServerFlag("--rpc-trace-negotiation");
    @Rule
    public KuduTestHarness harness = new KuduTestHarness(clusterBuilder);

    @Before
    public void setTableName() {
        this.tableName = TestSecurityContextRealUser.class.getName() + "-" + System.currentTimeMillis();
    }

    @Test
    public void test() throws Exception {
        Throwable throwable;
        KuduClient client;
        this.harness.kdestroy();
        try {
            client = new KuduClient.KuduClientBuilder(this.harness.getMasterAddressesAsString()).build();
            throwable = null;
            try {
                client.listTabletServers();
                Assert.fail();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (client != null) {
                    TestSecurityContextRealUser.$closeResource(throwable, (AutoCloseable)client);
                }
            }
        }
        catch (KuduException e) {
            Assert.assertTrue((String)e.getStatus().toString(), (boolean)e.getStatus().isServiceUnavailable());
        }
        client = new KuduClient.KuduClientBuilder(this.harness.getMasterAddressesAsString()).build();
        throwable = null;
        try {
            Client.AuthenticationCredentialsPB credentials = Client.AuthenticationCredentialsPB.newBuilder().setRealUser("token-user").build();
            client.importAuthenticationCredentials(credentials.toByteArray());
            client.listTabletServers();
            KuduTable table = client.createTable(this.tableName, ClientTestUtil.getBasicSchema(), new CreateTableOptions().setRangePartitionColumns(new ArrayList()));
            Assert.assertEquals((long)0L, (long)ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]).size());
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            if (client != null) {
                TestSecurityContextRealUser.$closeResource(throwable, (AutoCloseable)client);
            }
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

